/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.defrag;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.collections.sort.RedBlackTreeLong;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.math.FragmentedRangeLong;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.util.Pair;

public class DefragmenterMinimumMoves<TError extends Exception> {
    protected List<? extends UsedBlock> usedBlocks;
    protected FragmentedRangeLong freeSpaces;
    protected DataMover<TError> mover;

    public DefragmenterMinimumMoves(List<? extends UsedBlock> usedBlocks, FragmentedRangeLong freeSpaces, DataMover<TError> mover) {
        this.usedBlocks = usedBlocks;
        this.freeSpaces = freeSpaces;
        this.mover = mover;
    }

    public FragmentedRangeLong getFreeSpaces() {
        return this.freeSpaces;
    }

    public ISynchronizationPoint<TError> defragment() {
        JoinPoint jp = new JoinPoint();
        this.defragment(jp);
        return jp;
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="block.block is supposed to be set by implementation")
    private void defragment(JoinPoint<TError> jp) {
        while (true) {
            if (this.freeSpaces.isEmpty() || this.usedBlocks.isEmpty()) {
                jp.start();
                return;
            }
            RangeLong first = (RangeLong)this.freeSpaces.removeFirst();
            long size = first.max - first.min + 1L;
            LinkedArrayList combinations = new LinkedArrayList(20);
            Iterator<? extends UsedBlock> it = this.usedBlocks.iterator();
            while (it.hasNext()) {
                UsedBlock block = it.next();
                if (block.block.min < first.min) {
                    it.remove();
                    continue;
                }
                long blockSize = block.block.max - block.block.min + 1L;
                if (blockSize == size) {
                    combinations = null;
                    this.freeSpaces.addRange(block.block);
                    jp.addToJoin(this.mover.move(block, first.min));
                    it.remove();
                    break;
                }
                if (blockSize > size) continue;
                ArrayList list = new ArrayList(combinations);
                for (Pair combination : list) {
                    long s = (Long)combination.getValue2();
                    if (s + blockSize > size) continue;
                    if (s + blockSize == size) {
                        combinations = null;
                        long offset = 0L;
                        for (UsedBlock b : (List)combination.getValue1()) {
                            this.freeSpaces.addRange(b.block);
                            jp.addToJoin(this.mover.move(b, first.min + offset));
                            offset += b.block.max - b.block.min + 1L;
                            this.usedBlocks.remove(b);
                        }
                        this.freeSpaces.addRange(block.block);
                        jp.addToJoin(this.mover.move(block, first.min + offset));
                        break;
                    }
                    ArrayList<UsedBlock> newComb = new ArrayList<UsedBlock>(((List)combination.getValue1()).size() + 1);
                    newComb.addAll((Collection)combination.getValue1());
                    newComb.add(block);
                    combinations.add(new Pair(newComb, s + blockSize));
                }
                if (combinations == null) break;
                combinations.add(new Pair<List<UsedBlock>, Long>(Collections.singletonList(block), blockSize));
            }
            if (combinations == null) continue;
            if (this.usedBlocks.isEmpty()) {
                this.freeSpaces.addRange(first);
                continue;
            }
            if (!combinations.isEmpty()) {
                List comb = null;
                long combSize = 0L;
                for (Pair combination : combinations) {
                    if (comb == null) {
                        comb = (List)combination.getValue1();
                        combSize = (Long)combination.getValue2();
                        continue;
                    }
                    if ((Long)combination.getValue2() <= combSize) continue;
                    comb = (List)combination.getValue1();
                    combSize = (Long)combination.getValue2();
                }
                combinations = null;
                long offset = 0L;
                for (UsedBlock b : comb) {
                    this.freeSpaces.addRange(b.block);
                    jp.addToJoin(this.mover.move(b, first.min + offset));
                    offset += b.block.max - b.block.min + 1L;
                    this.usedBlocks.remove(b);
                }
                first.min += combSize;
            }
            RangeLong nextFree = this.freeSpaces.isEmpty() ? null : (RangeLong)this.freeSpaces.getFirst();
            RedBlackTreeLong<UsedBlock> toMove = new RedBlackTreeLong<UsedBlock>();
            Iterator<? extends UsedBlock> it2 = this.usedBlocks.iterator();
            while (it2.hasNext()) {
                UsedBlock block = it2.next();
                if (block.block.min < first.min) {
                    it2.remove();
                    continue;
                }
                if (nextFree != null && block.block.min >= nextFree.min) continue;
                toMove.add(block.block.min, block);
                it2.remove();
            }
            long offset = first.min;
            long lastBlockEnd = 0L;
            for (UsedBlock b : toMove) {
                lastBlockEnd = b.block.max;
                jp.addToJoin(this.mover.move(b, offset));
                offset += b.block.max - b.block.min + 1L;
            }
            if (nextFree != null) {
                nextFree.min = offset;
                continue;
            }
            this.freeSpaces.addRange(offset, lastBlockEnd);
        }
    }

    public static interface DataMover<TError extends Exception> {
        public ISynchronizationPoint<TError> move(UsedBlock var1, long var2);
    }

    public static class UsedBlock {
        public RangeLong block;
    }
}

