/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.encoding;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.encoding.Base64;

public class Base64Decoder {
    private IO.Writable output;
    private ISynchronizationPoint<IOException> lastWrite = new SynchronizationPoint<boolean>(true);
    private byte[] previous = new byte[4];
    private int nbPrev = 0;

    public Base64Decoder(IO.Writable output) {
        this.output = output;
    }

    public ISynchronizationPoint<IOException> decode(final ByteBuffer buffer) {
        final SynchronizationPoint<IOException> result = new SynchronizationPoint<IOException>();
        new Task.Cpu<Void, NoException>("Decoding base 64", this.output.getPriority()){

            @Override
            public Void run() {
                byte[] out;
                if (Base64Decoder.this.nbPrev > 0) {
                    while (Base64Decoder.this.nbPrev < 4 && buffer.hasRemaining()) {
                        ((Base64Decoder)Base64Decoder.this).previous[((Base64Decoder)Base64Decoder.this).nbPrev++] = buffer.get();
                    }
                    if (Base64Decoder.this.nbPrev < 4) {
                        result.unblock();
                        return null;
                    }
                    out = new byte[3];
                    try {
                        Base64.decode4BytesBase64(Base64Decoder.this.previous, out);
                    }
                    catch (IOException e) {
                        result.error(e);
                        return null;
                    }
                    Base64Decoder.this.nbPrev = 0;
                    if (!buffer.hasRemaining()) {
                        Base64Decoder.this.write(out, result);
                        return null;
                    }
                    Base64Decoder.this.write(out, null);
                }
                try {
                    out = Base64.decode(buffer);
                }
                catch (IOException e) {
                    result.error(e);
                    return null;
                }
                while (buffer.hasRemaining()) {
                    ((Base64Decoder)Base64Decoder.this).previous[((Base64Decoder)Base64Decoder.this).nbPrev++] = buffer.get();
                }
                Base64Decoder.this.write(out, result);
                return null;
            }
        }.start();
        return result;
    }

    public ISynchronizationPoint<IOException> decode(final CharBuffer buffer) {
        final SynchronizationPoint<IOException> result = new SynchronizationPoint<IOException>();
        new Task.Cpu<Void, NoException>("Decoding base 64", this.output.getPriority()){

            @Override
            public Void run() {
                byte[] out;
                if (Base64Decoder.this.nbPrev > 0) {
                    while (Base64Decoder.this.nbPrev < 4 && buffer.hasRemaining()) {
                        ((Base64Decoder)Base64Decoder.this).previous[((Base64Decoder)Base64Decoder.this).nbPrev++] = (byte)buffer.get();
                    }
                    if (Base64Decoder.this.nbPrev < 4) {
                        result.unblock();
                        return null;
                    }
                    out = new byte[3];
                    try {
                        Base64.decode4BytesBase64(Base64Decoder.this.previous, out);
                    }
                    catch (IOException e) {
                        result.error(e);
                        return null;
                    }
                    Base64Decoder.this.nbPrev = 0;
                    if (!buffer.hasRemaining()) {
                        Base64Decoder.this.write(out, result);
                        return null;
                    }
                    Base64Decoder.this.write(out, null);
                }
                try {
                    out = Base64.decode(buffer);
                }
                catch (IOException e) {
                    result.error(e);
                    return null;
                }
                while (buffer.hasRemaining()) {
                    ((Base64Decoder)Base64Decoder.this).previous[((Base64Decoder)Base64Decoder.this).nbPrev++] = (byte)buffer.get();
                }
                Base64Decoder.this.write(out, result);
                return null;
            }
        }.start();
        return result;
    }

    public ISynchronizationPoint<IOException> flush() {
        if (this.nbPrev == 0) {
            return this.lastWrite;
        }
        while (this.nbPrev < 4) {
            this.previous[this.nbPrev++] = 61;
        }
        try {
            this.write(Base64.decode(this.previous), null);
        }
        catch (IOException e) {
            return new SynchronizationPoint<IOException>(e);
        }
        return this.lastWrite;
    }

    private void write(byte[] buf, SynchronizationPoint<IOException> result) {
        ISynchronizationPoint<IOException> last = this.lastWrite;
        SynchronizationPoint<IOException> thisOne = new SynchronizationPoint<IOException>();
        this.lastWrite = thisOne;
        last.listenInline(() -> {
            if (last.hasError()) {
                if (result != null) {
                    result.error((IOException)last.getError());
                }
                return;
            }
            this.output.writeAsync(ByteBuffer.wrap(buf)).listenInline(thisOne);
            if (result != null) {
                result.unblock();
            }
        });
    }
}

