/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.out2in;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.LockPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class OutputToInput
extends ConcurrentCloseable
implements IO.OutputToInput,
IO.Writable,
IO.Readable.Seekable {
    private IO io;
    private String sourceDescription;
    private boolean eof = false;
    private LockPoint<IOException> lock = new LockPoint();
    private long writePos = 0L;
    private long readPos = 0L;
    private LockPoint<NoException> lockIO = new LockPoint();

    public <T extends IO.Writable.Seekable & IO.Readable.Seekable> OutputToInput(T io, String sourceDescription) {
        this.io = io;
        this.sourceDescription = sourceDescription;
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        this.eof = true;
        this.lock.error(new EOFException());
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.io = null;
        ondone.unblock();
    }

    @Override
    public byte getPriority() {
        return this.io != null ? this.io.getPriority() : (byte)4;
    }

    @Override
    public void setPriority(byte priority) {
        this.io.setPriority(priority);
    }

    @Override
    public String getSourceDescription() {
        return "OutputToInput from " + this.sourceDescription;
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public void endOfData() {
        this.eof = true;
        this.lock.error(new EOFException());
    }

    @Override
    public void signalErrorBeforeEndOfData(IOException error) {
        this.lock.error(error);
        this.lockIO.unlock();
    }

    @Override
    public ISynchronizationPoint<IOException> canStartWriting() {
        return ((IO.Writable)this.io).canStartWriting();
    }

    @Override
    public int writeSync(ByteBuffer buffer) throws IOException {
        this.lockIO.lock();
        int nb = ((IO.Writable.Seekable)this.io).writeSync(this.writePos, buffer);
        this.writePos += (long)nb;
        this.lockIO.unlock();
        this.lock.unlock();
        return nb;
    }

    @Override
    public AsyncWork<Integer, IOException> writeAsync(final ByteBuffer buffer, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        final AsyncWork result = new AsyncWork();
        this.operation(new Task.Cpu<Void, NoException>("OutputToInput.writeAsync", this.getPriority()){

            @Override
            public Void run() {
                OutputToInput.this.lockIO.lock();
                AsyncWork<Integer, IOException> write = ((IO.Writable.Seekable)OutputToInput.this.io).writeAsync(OutputToInput.this.writePos, buffer, new RunnableWithParameter<Pair<Integer, IOException>>(){

                    @Override
                    public void run(Pair<Integer, IOException> param) {
                        if (param.getValue1() != null) {
                            OutputToInput.this.writePos = OutputToInput.this.writePos + (long)param.getValue1().intValue();
                            OutputToInput.this.lock.unlock();
                            if (ondone != null) {
                                ondone.run(param);
                            }
                        } else {
                            if (ondone != null) {
                                ondone.run(param);
                            }
                            OutputToInput.this.lock.error((Exception)param.getValue2());
                        }
                    }
                });
                write.forwardCancel(OutputToInput.this.lock);
                write.listenInline(result);
                OutputToInput.this.lockIO.unlock();
                return null;
            }
        }).start();
        return this.operation(result);
    }

    @Override
    public ISynchronizationPoint<IOException> canStartReading() {
        if (this.eof) {
            return new SynchronizationPoint<boolean>(true);
        }
        if (this.lock.hasError()) {
            return this.lock;
        }
        if (this.readPos < this.writePos) {
            return new SynchronizationPoint<boolean>(true);
        }
        return this.lock;
    }

    @Override
    public int readSync(long pos, ByteBuffer buffer) throws IOException {
        if (this.lock.hasError() && !this.eof) {
            throw new IOException("An error occured during the transfer of data", this.lock.getError());
        }
        while (pos >= this.writePos) {
            if (this.eof) {
                return -1;
            }
            if (this.lock.hasError() && !this.eof) {
                throw new IOException("An error occured during the transfer of data", this.lock.getError());
            }
            this.lock.lock();
        }
        this.lockIO.lock();
        int nb = ((IO.Readable.Seekable)this.io).readSync(pos, buffer);
        this.readPos = pos + (long)nb;
        this.lockIO.unlock();
        return nb;
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        return this.readSync(this.readPos, buffer);
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return IOUtil.readFully(this, buffer);
    }

    @Override
    public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        this.readPos = pos;
        return this.readFullySync(buffer);
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.readAsync(this.readPos, buffer, ondone);
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(final long pos, final ByteBuffer buffer, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        if (this.lock.hasError() && !this.eof) {
            IOException e = new IOException("An error occured during the transfer of data", this.lock.getError());
            if (ondone != null) {
                ondone.run(new Pair<Object, IOException>(null, e));
            }
            return new AsyncWork<Object, IOException>(null, e);
        }
        if (pos >= this.writePos) {
            if (this.eof && pos >= this.writePos) {
                this.readPos = this.writePos;
                if (ondone != null) {
                    ondone.run(new Pair<Integer, Object>(-1, null));
                }
                return new AsyncWork<Integer, Object>(-1, null);
            }
            final AsyncWork<Integer, IOException> result = new AsyncWork<Integer, IOException>();
            this.lock.listenAsync(this.operation(new Task.Cpu<Integer, IOException>("OutputToInput.readAsync", this.io.getPriority()){

                @Override
                public Integer run() throws IOException {
                    try {
                        Integer nb = OutputToInput.this.readSync(pos, buffer);
                        if (ondone != null) {
                            ondone.run(new Pair<Integer, Object>(nb, null));
                        }
                        result.unblockSuccess(nb);
                        return nb;
                    }
                    catch (IOException e) {
                        if (ondone != null) {
                            ondone.run(new Pair<Object, IOException>(null, e));
                        }
                        result.unblockError(e);
                        throw e;
                    }
                }
            }), true);
            return result;
        }
        final AsyncWork result = new AsyncWork();
        new Task.Cpu<Void, NoException>("OutputToInput.readAsync", this.io.getPriority()){

            @Override
            public Void run() {
                OutputToInput.this.lockIO.lock();
                ((IO.Readable.Seekable)OutputToInput.this.io).readAsync(pos, buffer, new RunnableWithParameter<Pair<Integer, IOException>>(){

                    @Override
                    public void run(Pair<Integer, IOException> param) {
                        if (param.getValue1() != null) {
                            OutputToInput.this.readPos = pos + (long)param.getValue1().intValue();
                        } else {
                            OutputToInput.this.readPos = pos;
                        }
                        if (ondone != null) {
                            ondone.run(param);
                        }
                    }
                }).listenInline(result);
                OutputToInput.this.lockIO.unlock();
                return null;
            }
        }.start();
        return this.operation(result);
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync(this, buffer, ondone));
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync(this, pos, buffer, ondone));
    }

    @Override
    public long skipSync(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        if (n < 0L) {
            if (this.readPos + n < 0L) {
                n = -this.readPos;
            }
            this.readPos += n;
            return n;
        }
        if (this.readPos + n > this.writePos) {
            if (this.lock.hasError() && !this.eof) {
                throw new IOException("An error occured during the transfer of data", this.lock.getError());
            }
            while (this.readPos + n > this.writePos) {
                if (this.eof) {
                    n = this.writePos - this.readPos;
                    this.readPos = this.writePos;
                    return n;
                }
                if (this.lock.hasError() && !this.eof) {
                    throw new IOException("An error occured during the transfer of data", this.lock.getError());
                }
                this.lock.lock();
            }
        }
        this.readPos += n;
        return n;
    }

    @Override
    public AsyncWork<Long, IOException> skipAsync(final long n, final RunnableWithParameter<Pair<Long, IOException>> ondone) {
        if (n <= 0L || this.readPos + n <= this.writePos) {
            try {
                Long r = this.skipSync(n);
                if (ondone != null) {
                    ondone.run(new Pair<Long, Object>(r, null));
                }
                return new AsyncWork<Long, Object>(r, null);
            }
            catch (IOException e) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, IOException>(null, e));
                }
                return new AsyncWork<Object, IOException>(null, e);
            }
        }
        if (this.eof) {
            long m = this.writePos - this.readPos;
            if (m > n) {
                m = n;
            }
            this.readPos += m;
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(m, null));
            }
            return new AsyncWork<Long, Object>(m, null);
        }
        final AsyncWork<Long, IOException> result = new AsyncWork<Long, IOException>();
        this.lock.listenAsync(this.operation(new Task.Cpu<Long, IOException>("OutputToInput.skipAsync", this.io.getPriority()){

            @Override
            public Long run() throws IOException {
                try {
                    Long nb = OutputToInput.this.skipSync(n);
                    if (ondone != null) {
                        ondone.run(new Pair<Long, Object>(nb, null));
                    }
                    result.unblockSuccess(nb);
                    return nb;
                }
                catch (IOException e) {
                    if (ondone != null) {
                        ondone.run(new Pair<Object, IOException>(null, e));
                    }
                    result.unblockError(e);
                    throw e;
                }
            }
        }), true);
        return result;
    }

    @Override
    public long getPosition() {
        return this.readPos;
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
        switch (type) {
            case FROM_BEGINNING: {
                this.readPos = 0L;
                this.skipSync(move);
                return this.readPos;
            }
            case FROM_CURRENT: {
                this.skipSync(move);
                return this.readPos;
            }
            case FROM_END: {
                while (!this.eof && !this.lock.hasError()) {
                    this.lock.lock();
                }
                if (this.eof) {
                    this.readPos = this.writePos;
                    this.skipSync(-move);
                    return this.readPos;
                }
                throw new IOException("An error occured during the transfer of data", this.lock.getError());
            }
        }
        throw new IOException("Unknown SeekType " + (Object)((Object)type));
    }

    @Override
    public AsyncWork<Long, IOException> seekAsync(final IO.Seekable.SeekType type, final long move, final RunnableWithParameter<Pair<Long, IOException>> ondone) {
        AsyncWork<Long, IOException> res = new AsyncWork<Long, IOException>();
        switch (type) {
            case FROM_BEGINNING: {
                this.readPos = 0L;
                this.skipAsync(move).listenInline(() -> {
                    if (ondone != null) {
                        ondone.run(new Pair<Long, Object>(this.readPos, null));
                    }
                    res.unblockSuccess(this.readPos);
                }, res);
                return res;
            }
            case FROM_CURRENT: {
                this.skipAsync(move).listenInline(() -> {
                    if (ondone != null) {
                        ondone.run(new Pair<Long, Object>(this.readPos, null));
                    }
                    res.unblockSuccess(this.readPos);
                }, res);
                return res;
            }
            case FROM_END: {
                if (this.lock.hasError() && !this.eof) {
                    IOException e = new IOException("An error occured during the transfer of data", this.lock.getError());
                    if (ondone != null) {
                        ondone.run(new Pair<Object, IOException>(null, e));
                    }
                    return new AsyncWork<Object, IOException>(null, e);
                }
                if (this.eof) {
                    this.readPos = move <= 0L ? this.writePos : this.writePos - move;
                    if (this.readPos < 0L) {
                        this.readPos = 0L;
                    }
                    Long r = this.readPos;
                    if (ondone != null) {
                        ondone.run(new Pair<Long, Object>(r, null));
                    }
                    return new AsyncWork<Long, Object>(r, null);
                }
                final AsyncWork<Long, IOException> result = new AsyncWork<Long, IOException>();
                this.lock.listenAsync(this.operation(new Task.Cpu<Void, NoException>("OutputToInput.seekAsync", this.io.getPriority()){

                    @Override
                    public Void run() {
                        try {
                            Long nb = OutputToInput.this.seekSync(type, move);
                            if (ondone != null) {
                                ondone.run(new Pair<Long, Object>(nb, null));
                            }
                            result.unblockSuccess(nb);
                        }
                        catch (IOException e) {
                            if (ondone != null) {
                                ondone.run(new Pair<Object, IOException>(null, e));
                            }
                            result.unblockError(e);
                        }
                        return null;
                    }
                }), true);
                return result;
            }
        }
        return new AsyncWork<Object, IOException>(null, new IOException("Unknown SeekType " + (Object)((Object)type)));
    }
}

