/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOAsInputStream;
import net.lecousin.framework.io.serialization.Deserializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationUtil;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnAttribute;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnType;
import net.lecousin.framework.io.serialization.annotations.TypeAnnotationToRule;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.math.IntegerUnit;
import net.lecousin.framework.util.Pair;

public abstract class AbstractDeserializer
implements Deserializer {
    protected byte priority;

    protected abstract ISynchronizationPoint<Exception> initializeDeserialization(IO.Readable var1);

    protected abstract ISynchronizationPoint<Exception> finalizeDeserialization();

    @Override
    public <T> AsyncWork<T, Exception> deserialize(TypeDefinition type, IO.Readable input, List<SerializationRule> rules) {
        this.priority = input.getPriority();
        ISynchronizationPoint<Exception> init = this.initializeDeserialization(input);
        AsyncWork result = new AsyncWork();
        init.listenAsync(new DeserializationTask(() -> {
            AsyncWork<Object, Exception> sp = this.deserializeValue(null, type, "", rules);
            sp.listenInline(obj -> this.finalizeDeserialization().listenInline(() -> result.unblockSuccess(obj), result), (ISynchronizationPoint<Exception>)result);
        }), result);
        return result;
    }

    protected List<SerializationRule> addRulesForType(SerializationClass type, List<SerializationRule> currentList) {
        currentList = TypeAnnotationToRule.addRules(type, currentList);
        currentList = AttributeAnnotationToRuleOnType.addRules(type, false, currentList);
        return currentList;
    }

    protected List<SerializationRule> addRulesForAttribute(SerializationClass.Attribute a, List<SerializationRule> currentList) {
        return AttributeAnnotationToRuleOnAttribute.addRules(a, true, currentList);
    }

    public <T> AsyncWork<T, Exception> deserializeValue(SerializationContext context, TypeDefinition type, String path, List<SerializationRule> rules) {
        rules = this.addRulesForType(new SerializationClass(type), rules);
        TypeDefinition newType = type;
        ArrayList<TypeDefinition> rulesTypes = new ArrayList<TypeDefinition>(rules.size());
        for (SerializationRule rule : rules) {
            rulesTypes.add(newType);
            newType = rule.getDeserializationType(newType, context);
        }
        AsyncWork value = this.deserializeValueType(context, newType, path, rules);
        AsyncWork result = new AsyncWork();
        if (value.isUnblocked()) {
            if (value.hasError()) {
                result.error(value.getError());
            } else {
                Object o = value.getResult();
                ListIterator itType = rulesTypes.listIterator(rules.size());
                ListIterator<SerializationRule> itRule = rules.listIterator(rules.size());
                while (itRule.hasPrevious()) {
                    try {
                        o = itRule.previous().getDeserializationValue(o, (TypeDefinition)itType.previous(), context);
                    }
                    catch (Exception e) {
                        result.error(e);
                        return result;
                    }
                }
                result.unblockSuccess(o);
            }
            return result;
        }
        List<SerializationRule> rul = rules;
        value.listenAsync(new DeserializationTask(() -> {
            Object o = value.getResult();
            ListIterator itType = rulesTypes.listIterator(rul.size());
            ListIterator itRule = rul.listIterator(rul.size());
            while (itRule.hasPrevious()) {
                try {
                    o = ((SerializationRule)itRule.previous()).getDeserializationValue(o, (TypeDefinition)itType.previous(), context);
                }
                catch (Exception e) {
                    result.error(e);
                    return;
                }
            }
            result.unblockSuccess(o);
        }), result);
        return result;
    }

    private <T> AsyncWork<T, Exception> deserializeValueType(SerializationContext context, TypeDefinition type, String path, List<SerializationRule> rules) {
        Class<?> c = type.getBase();
        if (Void.TYPE.equals(c) || Void.class.equals(c)) {
            return new AsyncWork<Object, Object>(null, null);
        }
        if (c.isArray()) {
            return this.deserializeCollectionValue(context, type, path, rules);
        }
        if (Boolean.TYPE.equals(c)) {
            return this.deserializeBooleanValue(false);
        }
        if (Boolean.class.equals(c)) {
            return this.deserializeBooleanValue(true);
        }
        if (Byte.TYPE.equals(c) || Short.TYPE.equals(c) || Integer.TYPE.equals(c) || Long.TYPE.equals(c) || Float.TYPE.equals(c) || Double.TYPE.equals(c)) {
            return this.deserializeNumericValue(c, false, null);
        }
        if (Number.class.isAssignableFrom(c)) {
            return this.deserializeNumericValue(c, true, null);
        }
        if (Character.TYPE.equals(c)) {
            return this.deserializeCharacterValue(false);
        }
        if (Character.class.equals(c)) {
            return this.deserializeCharacterValue(true);
        }
        if (CharSequence.class.isAssignableFrom(c)) {
            AsyncWork<? extends CharSequence, Exception> str = this.deserializeStringValue();
            AsyncWork result = new AsyncWork();
            str.listenInline(string -> {
                if (string == null) {
                    result.unblockSuccess(null);
                    return;
                }
                if (c.isAssignableFrom(string.getClass())) {
                    result.unblockSuccess(string);
                    return;
                }
                for (Constructor<?> ctor : c.getConstructors()) {
                    Class<?>[] params = ctor.getParameterTypes();
                    if (params.length != 1) continue;
                    if (params[0].isAssignableFrom(string.getClass())) {
                        try {
                            result.unblockSuccess(ctor.newInstance(string));
                        }
                        catch (Throwable t) {
                            result.error(new Exception("Error instantiating type " + c.getName(), t));
                        }
                        return;
                    }
                    if (!params[0].isAssignableFrom(String.class)) continue;
                    try {
                        result.unblockSuccess(ctor.newInstance(string.toString()));
                    }
                    catch (Throwable t) {
                        result.error(new Exception("Error instantiating type " + c.getName(), t));
                    }
                    return;
                }
                result.error(new Exception("Type " + c.getName() + " does not have a compatible constructor with parameter type " + string.getClass() + " or String"));
            }, result);
            return result;
        }
        if (c.isEnum()) {
            AsyncWork<? extends CharSequence, Exception> str = this.deserializeStringValue();
            AsyncWork result = new AsyncWork();
            str.listenInline(string -> {
                if (string == null) {
                    result.unblockSuccess(null);
                    return;
                }
                try {
                    result.unblockSuccess(Enum.valueOf(c, string.toString()));
                }
                catch (IllegalArgumentException e) {
                    result.error(new Exception("Unknown enum value '" + string + "' for " + c.getName()));
                }
            }, result);
            return result;
        }
        if (Collection.class.isAssignableFrom(c)) {
            return this.deserializeCollectionValue(context, type, path, rules);
        }
        if (Map.class.isAssignableFrom(c)) {
            return this.deserializeMapValue(context, type, path, rules);
        }
        if (InputStream.class.isAssignableFrom(c)) {
            return this.deserializeInputStreamValue(context, rules);
        }
        if (IO.Readable.class.isAssignableFrom(c)) {
            return this.deserializeIOReadableValue(context, rules);
        }
        return this.deserializeObjectValue(context, type, path, rules);
    }

    protected abstract AsyncWork<Boolean, Exception> deserializeBooleanValue(boolean var1);

    protected AsyncWork<Boolean, Exception> deserializeBooleanAttributeValue(SerializationContext.AttributeContext context, boolean nullable) {
        return this.deserializeBooleanValue(nullable);
    }

    protected abstract AsyncWork<? extends Number, Exception> deserializeNumericValue(Class<?> var1, boolean var2, Class<? extends IntegerUnit> var3);

    protected AsyncWork<? extends Number, Exception> deserializeNumericAttributeValue(SerializationContext.AttributeContext context, boolean nullable) {
        IntegerUnit.Unit unit = context.getAttribute().getAnnotation(false, IntegerUnit.Unit.class);
        Class<? extends IntegerUnit> target = unit != null ? unit.value() : null;
        return this.deserializeNumericValue(context.getAttribute().getType().getBase(), nullable, target);
    }

    public static void convertBigDecimalValue(BigDecimal n, Class<?> type, AsyncWork<Number, Exception> result) {
        block10: {
            try {
                if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
                    result.unblockSuccess(n.byteValueExact());
                    break block10;
                }
                if (Short.TYPE.equals(type) || Short.class.equals(type)) {
                    result.unblockSuccess(n.shortValueExact());
                    break block10;
                }
                if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
                    result.unblockSuccess(n.intValueExact());
                    break block10;
                }
                if (Long.TYPE.equals(type) || Long.class.equals(type)) {
                    result.unblockSuccess(n.longValueExact());
                    break block10;
                }
                if (Float.TYPE.equals(type) || Float.class.equals(type)) {
                    result.unblockSuccess(Float.valueOf(n.floatValue()));
                    break block10;
                }
                if (Double.TYPE.equals(type) || Double.class.equals(type)) {
                    result.unblockSuccess(n.doubleValue());
                    break block10;
                }
                if (BigInteger.class.equals(type)) {
                    result.unblockSuccess(n.toBigIntegerExact());
                    break block10;
                }
                if (BigDecimal.class.equals(type)) {
                    result.unblockSuccess(n);
                    break block10;
                }
                throw new Exception("Unknown numeric value type " + type.getName());
            }
            catch (Exception e) {
                result.error(e);
            }
        }
    }

    public static Number convertStringToInteger(Class<?> type, String str, Class<? extends IntegerUnit> targetUnit) throws Exception {
        BigInteger value;
        char c;
        int i;
        int l = str.length();
        for (i = 0; i < l && (c = str.charAt(i)) >= '0' && c <= '9'; ++i) {
        }
        if (i == l) {
            value = new BigInteger(str);
        } else {
            String unitStr = str.substring(i).trim();
            value = new BigInteger(str.substring(0, i));
            if (unitStr.length() > 0) {
                Class<? extends IntegerUnit> unit = IntegerUnit.ParserRegistry.get(unitStr);
                if (unit == null) {
                    throw new Exception("Unknown integer unit: " + unitStr);
                }
                long val = IntegerUnit.ConverterRegistry.convert(value.longValue(), unit, targetUnit);
                value = BigInteger.valueOf(val);
            }
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return value.byteValueExact();
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return value.shortValueExact();
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return value.intValueExact();
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return value.longValueExact();
        }
        if (BigInteger.class.equals(type)) {
            return value;
        }
        throw new Exception("Unknown integer type " + type.getName());
    }

    protected AsyncWork<Character, Exception> deserializeCharacterValue(boolean nullable) {
        AsyncWork<? extends CharSequence, Exception> read = this.deserializeStringValue();
        AsyncWork<Character, Exception> result = new AsyncWork<Character, Exception>();
        read.listenInline(string -> {
            if (string == null || string.length() == 0) {
                if (nullable) {
                    result.unblockSuccess(null);
                } else {
                    result.error(new Exception("Character value expected"));
                }
                return;
            }
            if (string.length() > 1) {
                result.error(new Exception("A single character value is expected, " + string.length() + " characters found"));
                return;
            }
            result.unblockSuccess(Character.valueOf(string.charAt(0)));
        }, result);
        return result;
    }

    protected AsyncWork<Character, Exception> deserializeCharacterAttributeValue(SerializationContext.AttributeContext context, boolean nullable) {
        SerializationClass.Attribute fakeAttr = new SerializationClass.Attribute(context.getAttribute());
        fakeAttr.setType(new TypeDefinition(String.class, new TypeDefinition[0]));
        SerializationContext.AttributeContext fakeContext = new SerializationContext.AttributeContext(context.getParent(), fakeAttr);
        AsyncWork<? extends CharSequence, Exception> read = this.deserializeStringAttributeValue(fakeContext);
        AsyncWork<Character, Exception> result = new AsyncWork<Character, Exception>();
        read.listenInline(string -> {
            if (string == null || string.length() == 0) {
                if (nullable) {
                    result.unblockSuccess(null);
                } else {
                    result.error(new Exception("Character value expected"));
                }
                return;
            }
            if (string.length() > 1) {
                result.error(new Exception("A single character value is expected, " + string.length() + " characters found"));
                return;
            }
            result.unblockSuccess(Character.valueOf(string.charAt(0)));
        }, result);
        return result;
    }

    protected abstract AsyncWork<? extends CharSequence, Exception> deserializeStringValue();

    protected AsyncWork<? extends CharSequence, Exception> deserializeStringAttributeValue(SerializationContext.AttributeContext context) {
        return this.deserializeStringValue();
    }

    protected AsyncWork<Object, Exception> deserializeCollectionValue(SerializationContext context, TypeDefinition type, String path, List<SerializationRule> rules) {
        TypeDefinition elementType;
        Collection col;
        AsyncWork<Boolean, Exception> start = this.startCollectionValue();
        AsyncWork<Object, Exception> result = new AsyncWork<Object, Exception>();
        if (type.getBase().isArray()) {
            col = new LinkedList();
            elementType = new TypeDefinition(type.getBase().getComponentType(), new TypeDefinition[0]);
        } else {
            try {
                col = (Collection)SerializationClass.instantiate(type, context, rules, false);
            }
            catch (Exception e) {
                return new AsyncWork<Object, Exception>(null, e);
            }
            if (type.getParameters().isEmpty()) {
                return new AsyncWork<Object, Exception>(null, new Exception("Cannot deserialize collection without an element type specified"));
            }
            elementType = type.getParameters().get(0);
        }
        SerializationContext.CollectionContext ctx = new SerializationContext.CollectionContext(context, col, type, elementType);
        if (start.isUnblocked()) {
            if (start.hasError()) {
                return new AsyncWork<Object, Exception>(null, start.getError());
            }
            this.deserializeNextCollectionValueElement(ctx, 0, path, rules, result);
        } else {
            start.listenAsync(new DeserializationTask(() -> {
                try {
                    this.deserializeNextCollectionValueElement(ctx, 0, path, rules, result);
                }
                catch (Exception e) {
                    result.error(e);
                }
            }), result);
        }
        return result;
    }

    protected abstract AsyncWork<Boolean, Exception> startCollectionValue();

    protected void deserializeNextCollectionValueElement(SerializationContext.CollectionContext context, int elementIndex, String colPath, List<SerializationRule> rules, AsyncWork<Object, Exception> result) {
        AsyncWork<Pair<Object, Boolean>, Exception> next;
        while ((next = this.deserializeCollectionValueElement(context, elementIndex, colPath, rules)).isUnblocked()) {
            if (next.hasError()) {
                result.error(next.getError());
                return;
            }
            Pair<Object, Boolean> p = next.getResult();
            if (!p.getValue2().booleanValue()) {
                if (Collection.class.isAssignableFrom(context.getCollectionType().getBase())) {
                    result.unblockSuccess(context.getCollection());
                } else {
                    result.unblockSuccess(AbstractDeserializer.toArray(context));
                }
                return;
            }
            Object element = p.getValue1();
            if (element != null && Collection.class.isAssignableFrom(context.getCollectionType().getBase()) && !context.getElementType().getBase().isAssignableFrom(element.getClass())) {
                result.error(new Exception("Invalid collection element type " + element.getClass().getName() + ", expected is " + context.getElementType().getBase().getName()));
                return;
            }
            ((Collection)context.getCollection()).add(element);
            ++elementIndex;
        }
        int currentIndex = elementIndex;
        next.listenInline(() -> {
            if (next.hasError()) {
                result.error((Exception)next.getError());
                return;
            }
            Pair p = (Pair)next.getResult();
            if (!((Boolean)p.getValue2()).booleanValue()) {
                if (Collection.class.isAssignableFrom(context.getCollectionType().getBase())) {
                    result.unblockSuccess(context.getCollection());
                } else {
                    result.unblockSuccess(AbstractDeserializer.toArray(context));
                }
                return;
            }
            new DeserializationTask(() -> {
                Object element = p.getValue1();
                if (element != null && Collection.class.isAssignableFrom(context.getCollectionType().getBase()) && !context.getElementType().getBase().isAssignableFrom(element.getClass())) {
                    result.error(new Exception("Invalid collection element type " + element.getClass().getName() + ", expected is " + context.getElementType().getBase().getName()));
                    return;
                }
                ((Collection)context.getCollection()).add(element);
                this.deserializeNextCollectionValueElement(context, currentIndex + 1, colPath, rules, result);
            }).start();
        });
    }

    protected abstract AsyncWork<Pair<Object, Boolean>, Exception> deserializeCollectionValueElement(SerializationContext.CollectionContext var1, int var2, String var3, List<SerializationRule> var4);

    protected AsyncWork<Object, Exception> deserializeCollectionAttributeValue(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        TypeDefinition elementType;
        Collection col;
        AsyncWork<Boolean, Exception> start = this.startCollectionAttributeValue(context);
        TypeDefinition colType = context.getAttribute().getType();
        if (colType.getBase().isArray()) {
            col = new LinkedList();
            Class<Object> t = colType.getBase().getComponentType();
            if (t.equals(Boolean.TYPE)) {
                t = Boolean.class;
            } else if (t.equals(Byte.TYPE)) {
                t = Byte.class;
            } else if (t.equals(Short.TYPE)) {
                t = Short.class;
            } else if (t.equals(Integer.TYPE)) {
                t = Integer.class;
            } else if (t.equals(Long.TYPE)) {
                t = Long.class;
            } else if (t.equals(Float.TYPE)) {
                t = Float.class;
            } else if (t.equals(Double.TYPE)) {
                t = Double.class;
            } else if (t.equals(Character.TYPE)) {
                t = Character.class;
            }
            elementType = new TypeDefinition(t, new TypeDefinition[0]);
        } else {
            try {
                col = (Collection)SerializationClass.instantiate(colType, context, rules, false);
            }
            catch (Exception e) {
                return new AsyncWork<Object, Exception>(null, e);
            }
            if (colType.getParameters().isEmpty()) {
                return new AsyncWork<Object, Exception>(null, new Exception("Cannot deserialize collection without an element type specified"));
            }
            elementType = colType.getParameters().get(0);
        }
        SerializationContext.CollectionContext ctx = new SerializationContext.CollectionContext(context, col, colType, elementType);
        AsyncWork<Object, Exception> result = new AsyncWork<Object, Exception>();
        if (start.isUnblocked()) {
            if (start.hasError()) {
                return new AsyncWork<Object, Exception>(null, start.getError());
            }
            this.deserializeNextCollectionAttributeValueElement(ctx, 0, path, rules, result);
        } else {
            start.listenAsync(new DeserializationTask(() -> {
                try {
                    this.deserializeNextCollectionAttributeValueElement(ctx, 0, path, rules, result);
                }
                catch (Exception e) {
                    result.error(e);
                }
            }), result);
        }
        return result;
    }

    protected AsyncWork<Boolean, Exception> startCollectionAttributeValue(SerializationContext.AttributeContext context) {
        return this.startCollectionValue();
    }

    protected void deserializeNextCollectionAttributeValueElement(SerializationContext.CollectionContext context, int elementIndex, String colPath, List<SerializationRule> rules, AsyncWork<Object, Exception> result) {
        AsyncWork<Pair<Object, Boolean>, Exception> next;
        while ((next = this.deserializeCollectionAttributeValueElement(context, elementIndex, colPath, rules)).isUnblocked()) {
            if (next.hasError()) {
                result.error(next.getError());
                return;
            }
            Pair<Object, Boolean> p = next.getResult();
            if (!p.getValue2().booleanValue()) {
                if (Collection.class.isAssignableFrom(context.getCollectionType().getBase())) {
                    result.unblockSuccess(context.getCollection());
                } else {
                    result.unblockSuccess(AbstractDeserializer.toArray(context));
                }
                return;
            }
            Object element = p.getValue1();
            if (element != null && Collection.class.isAssignableFrom(context.getCollectionType().getBase()) && !context.getElementType().getBase().isAssignableFrom(element.getClass())) {
                result.error(new Exception("Invalid collection element type " + element.getClass().getName() + ", expected is " + context.getElementType().getBase().getName()));
                return;
            }
            ((Collection)context.getCollection()).add(element);
            ++elementIndex;
        }
        int currentIndex = elementIndex;
        next.listenInline(() -> {
            if (next.hasError()) {
                result.error((Exception)next.getError());
                return;
            }
            Pair p = (Pair)next.getResult();
            if (!((Boolean)p.getValue2()).booleanValue()) {
                if (Collection.class.isAssignableFrom(context.getCollectionType().getBase())) {
                    result.unblockSuccess(context.getCollection());
                } else {
                    result.unblockSuccess(AbstractDeserializer.toArray(context));
                }
                return;
            }
            new DeserializationTask(() -> {
                Object element = p.getValue1();
                if (element != null && Collection.class.isAssignableFrom(context.getCollectionType().getBase()) && !context.getElementType().getBase().isAssignableFrom(element.getClass())) {
                    result.error(new Exception("Invalid collection element type " + element.getClass().getName() + ", expected is " + context.getElementType().getBase().getName()));
                    return;
                }
                ((Collection)context.getCollection()).add(element);
                this.deserializeNextCollectionAttributeValueElement(context, currentIndex + 1, colPath, rules, result);
            }).start();
        });
    }

    protected static Object toArray(SerializationContext.CollectionContext context) {
        Class<?> t = context.getCollectionType().getBase().getComponentType();
        Collection col = (Collection)context.getCollection();
        if (t.equals(Boolean.TYPE)) {
            boolean[] a = new boolean[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = (Boolean)o;
            }
            return a;
        }
        if (t.equals(Byte.TYPE)) {
            byte[] a = new byte[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = (Byte)o;
            }
            return a;
        }
        if (t.equals(Short.TYPE)) {
            short[] a = new short[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = (Short)o;
            }
            return a;
        }
        if (t.equals(Integer.TYPE)) {
            int[] a = new int[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = (Integer)o;
            }
            return a;
        }
        if (t.equals(Long.TYPE)) {
            long[] a = new long[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = (Long)o;
            }
            return a;
        }
        if (t.equals(Float.TYPE)) {
            float[] a = new float[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = ((Float)o).floatValue();
            }
            return a;
        }
        if (t.equals(Double.TYPE)) {
            double[] a = new double[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = (Double)o;
            }
            return a;
        }
        if (t.equals(Character.TYPE)) {
            char[] a = new char[col.size()];
            int i = 0;
            for (Object o : col) {
                a[i++] = ((Character)o).charValue();
            }
            return a;
        }
        return col.toArray((Object[])Array.newInstance(t, col.size()));
    }

    protected AsyncWork<Pair<Object, Boolean>, Exception> deserializeCollectionAttributeValueElement(SerializationContext.CollectionContext context, int elementIndex, String colPath, List<SerializationRule> rules) {
        return this.deserializeCollectionValueElement(context, elementIndex, colPath, rules);
    }

    protected AsyncWork<Map<?, ?>, Exception> deserializeMapValue(SerializationContext context, TypeDefinition typeDef, String path, List<SerializationRule> rules) {
        TypeDefinition type = new TypeDefinition(SerializationUtil.MapEntry.class, typeDef.getParameters());
        type = new TypeDefinition(ArrayList.class, type);
        AsyncWork value = this.deserializeValueType(context, type, path, rules);
        AsyncWork result = new AsyncWork();
        if (value.isUnblocked()) {
            if (value.hasError()) {
                result.error(value.getError());
            } else {
                try {
                    result.unblockSuccess(AbstractDeserializer.getMap((ArrayList)value.getResult(), typeDef, context, rules));
                }
                catch (Exception e) {
                    result.error(e);
                }
            }
            return result;
        }
        value.listenAsync(new DeserializationTask(() -> {
            try {
                result.unblockSuccess(AbstractDeserializer.getMap((ArrayList)value.getResult(), typeDef, context, rules));
            }
            catch (Exception e) {
                result.error(e);
            }
        }), result);
        return result;
    }

    protected AsyncWork<Map<?, ?>, Exception> deserializeMapAttributeValue(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        TypeDefinition type = new TypeDefinition(SerializationUtil.MapEntry.class, context.getAttribute().getType().getParameters());
        type = new TypeDefinition(ArrayList.class, type);
        SerializationClass.Attribute fakeAttribute = new SerializationClass.Attribute(context.getAttribute());
        fakeAttribute.setType(type);
        SerializationContext.AttributeContext ctx = new SerializationContext.AttributeContext(context.getParent(), fakeAttribute);
        AsyncWork<Object, Exception> value = this.deserializeCollectionAttributeValue(ctx, path, rules);
        AsyncWork result = new AsyncWork();
        if (value.isUnblocked()) {
            if (value.hasError()) {
                result.error(value.getError());
            } else {
                try {
                    result.unblockSuccess(AbstractDeserializer.getMap((ArrayList)value.getResult(), context.getAttribute().getType(), context, rules));
                }
                catch (Exception e) {
                    result.error(e);
                }
            }
            return result;
        }
        value.listenAsync(new DeserializationTask(() -> {
            try {
                result.unblockSuccess(AbstractDeserializer.getMap((ArrayList)value.getResult(), context.getAttribute().getType(), context, rules));
            }
            catch (Exception e) {
                result.error(e);
            }
        }), result);
        return result;
    }

    protected static Map<?, ?> getMap(ArrayList<SerializationUtil.MapEntry> entries, TypeDefinition type, SerializationContext context, List<SerializationRule> rules) throws Exception {
        Map map = (Map)SerializationClass.instantiate(type, context, rules, false);
        for (SerializationUtil.MapEntry entry : entries) {
            map.put(entry.key, entry.value);
        }
        return map;
    }

    protected AsyncWork<InputStream, Exception> deserializeInputStreamValue(SerializationContext context, List<SerializationRule> rules) {
        AsyncWork<IO.Readable, Exception> io = this.deserializeIOReadableValue(context, rules);
        if (io.isUnblocked()) {
            if (io.hasError()) {
                return new AsyncWork<Object, Exception>(null, io.getError());
            }
            if (io.getResult() == null) {
                return new AsyncWork<Object, Object>(null, null);
            }
            return new AsyncWork<InputStream, Object>(IOAsInputStream.get(io.getResult()), null);
        }
        AsyncWork<InputStream, Exception> result = new AsyncWork<InputStream, Exception>();
        io.listenInline(inputStream -> result.unblockSuccess(IOAsInputStream.get(inputStream)), result);
        return result;
    }

    protected AsyncWork<InputStream, Exception> deserializeInputStreamAttributeValue(SerializationContext.AttributeContext context, List<SerializationRule> rules) {
        AsyncWork<IO.Readable, Exception> io = this.deserializeIOReadableAttributeValue(context, rules);
        if (io.isUnblocked()) {
            if (io.hasError()) {
                return new AsyncWork<Object, Exception>(null, io.getError());
            }
            if (io.getResult() == null) {
                return new AsyncWork<Object, Object>(null, null);
            }
            return new AsyncWork<InputStream, Object>(IOAsInputStream.get(io.getResult()), null);
        }
        AsyncWork<InputStream, Exception> result = new AsyncWork<InputStream, Exception>();
        io.listenInline(inputStream -> result.unblockSuccess(IOAsInputStream.get(inputStream)), result);
        return result;
    }

    protected abstract AsyncWork<IO.Readable, Exception> deserializeIOReadableValue(SerializationContext var1, List<SerializationRule> var2);

    protected abstract AsyncWork<IO.Readable, Exception> deserializeIOReadableAttributeValue(SerializationContext.AttributeContext var1, List<SerializationRule> var2);

    protected <T> AsyncWork<T, Exception> deserializeObjectValue(SerializationContext context, TypeDefinition type, String path, List<SerializationRule> rules) {
        AsyncWork<Object, Exception> start = this.startObjectValue(context, type, rules);
        if (start.isUnblocked()) {
            if (start.hasError()) {
                return start;
            }
            Object instance2 = start.getResult();
            if (instance2 == null) {
                return start;
            }
            AsyncWork<Object, Exception> result = new AsyncWork<Object, Exception>();
            this.deserializeObjectAttributes(context, instance2, type, path, rules, result);
            return result;
        }
        AsyncWork result = new AsyncWork();
        start.listenInline(instance -> {
            if (instance == null) {
                result.unblockSuccess(null);
            } else {
                new DeserializationTask(() -> this.deserializeObjectAttributes(context, instance, type, path, rules, result)).start();
            }
        }, result);
        return result;
    }

    protected abstract AsyncWork<Object, Exception> startObjectValue(SerializationContext var1, TypeDefinition var2, List<SerializationRule> var3);

    protected void deserializeObjectAttributes(SerializationContext parentContext, Object instance, TypeDefinition typeDef, String path, List<SerializationRule> rules, AsyncWork<Object, Exception> result) {
        SerializationContext.ObjectContext ctx;
        try {
            SerializationClass sc = new SerializationClass(typeDef != null ? TypeDefinition.from(instance.getClass(), typeDef) : new TypeDefinition(instance.getClass(), new TypeDefinition[0]));
            ctx = new SerializationContext.ObjectContext(parentContext, instance, sc, typeDef);
            rules = this.addRulesForType(sc, rules);
            sc.apply(rules, ctx, false);
        }
        catch (Exception e) {
            result.error(e);
            return;
        }
        this.deserializeNextObjectAttribute(ctx, path, rules, result);
    }

    protected void deserializeNextObjectAttribute(SerializationContext.ObjectContext context, String path, List<SerializationRule> rules, AsyncWork<Object, Exception> result) {
        AsyncWork<String, Exception> name;
        while ((name = this.deserializeObjectAttributeName(context)).isUnblocked()) {
            if (name.hasError()) {
                result.error(name.getError());
                return;
            }
            String n2 = name.getResult();
            if (n2 == null) {
                result.unblockSuccess(context.getInstance());
                return;
            }
            SerializationClass.Attribute a = context.getSerializationClass().getAttributeByName(n2);
            if (a == null) {
                result.error(new Exception("Unknown attribute " + n2 + " for type " + context.getInstance().getClass().getName() + " in " + path));
                return;
            }
            if (!a.canSet()) {
                result.error(new Exception("Attribute " + n2 + " cannot be set on type " + context.getInstance().getClass().getName()));
                return;
            }
            ISynchronizationPoint<Exception> val = this.deserializeObjectAttributeValue(context, a, path + '.' + n2, rules);
            if (val.isUnblocked()) {
                if (!val.hasError()) continue;
                result.error(val.getError());
                return;
            }
            val.listenAsync(new DeserializationTask(() -> this.deserializeNextObjectAttribute(context, path, rules, result)), result);
            return;
        }
        name.listenInline(n -> {
            if (n == null) {
                result.unblockSuccess(context.getInstance());
                return;
            }
            SerializationClass.Attribute a = context.getSerializationClass().getAttributeByName((String)n);
            if (a == null) {
                result.error(new Exception("Unknown attribute " + n + " for type " + context.getInstance().getClass().getName()));
                return;
            }
            if (!a.canSet()) {
                result.error(new Exception("Attribute " + n + " cannot be set on type " + context.getInstance().getClass().getName()));
                return;
            }
            new DeserializationTask(() -> {
                ISynchronizationPoint<Exception> val = this.deserializeObjectAttributeValue(context, a, path + '.' + n, rules);
                if (val.isUnblocked()) {
                    if (val.hasError()) {
                        result.error(val.getError());
                        return;
                    }
                    this.deserializeNextObjectAttribute(context, path, rules, result);
                    return;
                }
                val.listenAsync(new DeserializationTask(() -> this.deserializeNextObjectAttribute(context, path, rules, result)), result);
            }).start();
        }, result);
    }

    protected abstract AsyncWork<String, Exception> deserializeObjectAttributeName(SerializationContext.ObjectContext var1);

    protected ISynchronizationPoint<Exception> deserializeObjectAttributeValue(SerializationContext.ObjectContext context, SerializationClass.Attribute a, String path, List<SerializationRule> rules) {
        SerializationContext.AttributeContext ctx = new SerializationContext.AttributeContext(context, a);
        AsyncWork<?, Exception> value = this.deserializeObjectAttributeValue(ctx, path, rules);
        if (value.isUnblocked()) {
            if (value.hasError()) {
                return value;
            }
            Object val2 = value.getResult();
            if (!a.ignore()) {
                try {
                    a.setValue(context.getInstance(), val2);
                }
                catch (Exception e) {
                    return new SynchronizationPoint<Exception>(e);
                }
            }
            return value;
        }
        SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        value.listenInline(val -> new DeserializationTask(() -> {
            if (!a.ignore()) {
                try {
                    a.setValue(context.getInstance(), val);
                }
                catch (Exception e) {
                    sp.error(e);
                    return;
                }
            }
            sp.unblock();
        }).start(), sp);
        return sp;
    }

    protected AsyncWork<?, Exception> deserializeObjectAttributeValue(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        SerializationClass.Attribute a = context.getAttribute();
        TypeDefinition type = a.getType();
        Class<?> c = type.getBase();
        rules = this.addRulesForAttribute(a, rules);
        if (c.isArray()) {
            return this.deserializeCollectionAttributeValue(context, path, rules);
        }
        if (Boolean.TYPE.equals(c)) {
            return this.deserializeBooleanAttributeValue(context, false);
        }
        if (Boolean.class.equals(c)) {
            return this.deserializeBooleanAttributeValue(context, true);
        }
        if (Byte.TYPE.equals(c) || Short.TYPE.equals(c) || Integer.TYPE.equals(c) || Long.TYPE.equals(c) || Float.TYPE.equals(c) || Double.TYPE.equals(c)) {
            return this.deserializeNumericAttributeValue(context, false);
        }
        if (Number.class.isAssignableFrom(c)) {
            return this.deserializeNumericAttributeValue(context, true);
        }
        if (Character.TYPE.equals(c)) {
            return this.deserializeCharacterAttributeValue(context, false);
        }
        if (Character.class.equals(c)) {
            return this.deserializeCharacterAttributeValue(context, true);
        }
        if (CharSequence.class.isAssignableFrom(c)) {
            AsyncWork<? extends CharSequence, Exception> str = this.deserializeStringAttributeValue(context);
            AsyncWork result = new AsyncWork();
            str.listenInline(string -> {
                if (string == null) {
                    result.unblockSuccess(null);
                    return;
                }
                if (c.isAssignableFrom(string.getClass())) {
                    result.unblockSuccess(string);
                    return;
                }
                for (Constructor<?> ctor : c.getConstructors()) {
                    Class<?>[] params = ctor.getParameterTypes();
                    if (params.length != 1) continue;
                    if (params[0].isAssignableFrom(string.getClass())) {
                        try {
                            result.unblockSuccess(ctor.newInstance(string));
                        }
                        catch (Throwable t) {
                            result.error(new Exception("Error instantiating type " + c.getName(), t));
                        }
                        return;
                    }
                    if (!params[0].isAssignableFrom(String.class)) continue;
                    try {
                        result.unblockSuccess(ctor.newInstance(string.toString()));
                    }
                    catch (Throwable t) {
                        result.error(new Exception("Error instantiating type " + c.getName(), t));
                    }
                    return;
                }
                result.error(new Exception("Type " + c.getName() + " does not have a compatible constructor with parameter type " + string.getClass() + " or String"));
            }, result);
            return result;
        }
        if (c.isEnum()) {
            AsyncWork<? extends CharSequence, Exception> str = this.deserializeStringAttributeValue(context);
            AsyncWork result = new AsyncWork();
            str.listenInline(string -> {
                if (string == null) {
                    result.unblockSuccess(null);
                    return;
                }
                try {
                    result.unblockSuccess(Enum.valueOf(c, string.toString()));
                }
                catch (IllegalArgumentException e) {
                    result.error(new Exception("Unknown enum value '" + string + "' for " + c.getName()));
                }
            }, result);
            return result;
        }
        if (Collection.class.isAssignableFrom(c)) {
            return this.deserializeCollectionAttributeValue(context, path, rules);
        }
        if (Map.class.isAssignableFrom(c)) {
            return this.deserializeMapAttributeValue(context, path, rules);
        }
        if (InputStream.class.isAssignableFrom(c)) {
            return this.deserializeInputStreamAttributeValue(context, rules);
        }
        if (IO.Readable.class.isAssignableFrom(c)) {
            return this.deserializeIOReadableAttributeValue(context, rules);
        }
        return this.deserializeObjectAttributeObjectValue(context, path, rules);
    }

    protected AsyncWork<Object, Exception> deserializeObjectAttributeObjectValue(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        return this.deserializeObjectValue(context, context.getAttribute().getType(), path, rules);
    }

    protected class DeserializationTask
    extends Task.Cpu<Void, NoException> {
        private Runnable run;

        public DeserializationTask(Runnable run) {
            super("Deserialization using " + AbstractDeserializer.this.getClass().getName(), AbstractDeserializer.this.priority);
            this.run = run;
        }

        @Override
        public Void run() throws CancelException {
            try {
                this.run.run();
            }
            catch (Throwable t) {
                throw new CancelException("Error thrown in deserialization", t);
            }
            return null;
        }
    }
}

