/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization;

import java.util.List;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationSpecWriter;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnAttribute;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnType;
import net.lecousin.framework.io.serialization.annotations.TypeAnnotationToRule;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

public abstract class AbstractSerializationSpecWriter
implements SerializationSpecWriter {
    protected byte priority;

    protected abstract ISynchronizationPoint<? extends Exception> initializeSpecWriter(IO.Writable var1);

    protected abstract ISynchronizationPoint<? extends Exception> finalizeSpecWriter();

    @Override
    public ISynchronizationPoint<Exception> writeSpecification(Class<?> type, IO.Writable output, List<SerializationRule> rules) {
        this.priority = output.getPriority();
        ISynchronizationPoint<? extends Exception> init = this.initializeSpecWriter(output);
        SynchronizationPoint<Exception> result = new SynchronizationPoint<Exception>();
        init.listenAsyncSP(new SpecTask(() -> {
            ISynchronizationPoint<? extends Exception> sp = type != null ? this.specifyValue(null, new TypeDefinition(type, new TypeDefinition[0]), rules) : this.specifyAnyValue(null);
            sp.listenInlineSP(() -> this.finalizeSpecWriter().listenInlineSP(result), result);
        }), result);
        return result;
    }

    protected List<SerializationRule> addRulesForType(SerializationClass type, List<SerializationRule> currentList) {
        currentList = TypeAnnotationToRule.addRules(type.getType().getBase(), currentList);
        currentList = AttributeAnnotationToRuleOnType.addRules(type, true, currentList);
        return currentList;
    }

    protected List<SerializationRule> addRulesForAttribute(SerializationClass.Attribute a, List<SerializationRule> currentList) {
        return AttributeAnnotationToRuleOnAttribute.addRules(a, true, currentList);
    }

    protected abstract ISynchronizationPoint<? extends Exception> specifyAnyValue(SerializationContext var1);

    protected ISynchronizationPoint<? extends Exception> specifyValue(SerializationContext context, TypeDefinition typeDef, List<SerializationRule> rules) {
        Class<?> type = typeDef.getBase();
        if (Boolean.TYPE.equals(type)) {
            return this.specifyBooleanValue(false);
        }
        if (Boolean.class.equals(type)) {
            return this.specifyBooleanValue(true);
        }
        if (Byte.TYPE.equals(type)) {
            return this.specifyNumericValue(Byte.class, false, (byte)-128, (byte)127);
        }
        if (Byte.class.equals(type)) {
            return this.specifyNumericValue(Byte.class, true, (byte)-128, (byte)127);
        }
        if (Short.TYPE.equals(type)) {
            return this.specifyNumericValue(Short.class, false, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
        }
        if (Short.class.equals(type)) {
            return this.specifyNumericValue(Short.class, true, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
        }
        if (Integer.TYPE.equals(type)) {
            return this.specifyNumericValue(Integer.class, false, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (Integer.class.equals(type)) {
            return this.specifyNumericValue(Integer.class, true, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (Long.TYPE.equals(type)) {
            return this.specifyNumericValue(Long.class, false, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        if (Long.class.equals(type)) {
            return this.specifyNumericValue(Long.class, true, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return this.specifyStringValue(context, typeDef);
        }
        return this.specifyObjectValue(context, typeDef, rules);
    }

    protected abstract ISynchronizationPoint<? extends Exception> specifyBooleanValue(boolean var1);

    protected abstract ISynchronizationPoint<? extends Exception> specifyNumericValue(Class<?> var1, boolean var2, Number var3, Number var4);

    protected abstract ISynchronizationPoint<? extends Exception> specifyStringValue(SerializationContext var1, TypeDefinition var2);

    protected ISynchronizationPoint<? extends Exception> specifyObjectValue(SerializationContext context, TypeDefinition typeDef, List<SerializationRule> rules) {
        SerializationContext.ObjectContext ctx;
        try {
            Class<?> type = typeDef.getBase();
            SerializationClass sc = new SerializationClass(TypeDefinition.from(type, typeDef));
            ctx = new SerializationContext.ObjectContext(context, null, sc, typeDef);
            rules = this.addRulesForType(sc, rules);
            sc.apply(rules, ctx, true);
        }
        catch (Exception e) {
            return new SynchronizationPoint<Exception>(e);
        }
        return this.specifyTypedValue(ctx, rules);
    }

    protected abstract ISynchronizationPoint<? extends Exception> specifyTypedValue(SerializationContext.ObjectContext var1, List<SerializationRule> var2);

    protected ISynchronizationPoint<? extends Exception> specifyTypeContent(SerializationContext.ObjectContext context, List<SerializationRule> rules) {
        List<SerializationClass.Attribute> attributes = this.sortAttributes(context.getSerializationClass().getAttributes());
        SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        this.specifyTypeAttribute(context, attributes, 0, rules, sp);
        return sp;
    }

    protected List<SerializationClass.Attribute> sortAttributes(List<SerializationClass.Attribute> attributes) {
        return attributes;
    }

    protected void specifyTypeAttribute(SerializationContext.ObjectContext context, List<SerializationClass.Attribute> attributes, int index, List<SerializationRule> rules, SynchronizationPoint<Exception> sp) {
        if (index == attributes.size()) {
            sp.unblock();
            return;
        }
        SerializationClass.Attribute attr = attributes.get(index);
        SerializationContext.AttributeContext ctx = new SerializationContext.AttributeContext(context, attr);
        ISynchronizationPoint<? extends Exception> s = this.specifyTypeAttribute(ctx, rules);
        if (s.isUnblocked()) {
            if (s.hasError()) {
                sp.error(s.getError());
            } else {
                this.specifyTypeAttribute(context, attributes, index + 1, rules, sp);
            }
            return;
        }
        s.listenAsyncSP(new SpecTask(() -> this.specifyTypeAttribute(context, attributes, index + 1, rules, sp)), sp);
    }

    protected abstract ISynchronizationPoint<? extends Exception> specifyTypeAttribute(SerializationContext.AttributeContext var1, List<SerializationRule> var2);

    protected class SpecTask
    extends Task.Cpu<Void, NoException> {
        private Runnable r;

        public SpecTask(Runnable r) {
            super("Write Specification", AbstractSerializationSpecWriter.this.priority);
            this.r = r;
        }

        @Override
        public Void run() {
            this.r.run();
            return null;
        }
    }
}

