/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization;

import java.util.Collection;
import java.util.Iterator;
import net.lecousin.framework.collections.ArrayIterator;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.TypeDefinition;

public abstract class SerializationContext {
    protected SerializationContext parent;

    public SerializationContext(SerializationContext parent) {
        this.parent = parent;
    }

    public SerializationContext getParent() {
        return this.parent;
    }

    public abstract ObjectContext getContainerObjectContext();

    public static class CollectionContext
    extends SerializationContext {
        private Object col;
        private TypeDefinition colType;
        private TypeDefinition elementType;

        public CollectionContext(SerializationContext parent, Object col, TypeDefinition colType, TypeDefinition elementType) {
            super(parent);
            this.col = col;
            this.colType = colType;
            this.elementType = elementType;
        }

        public Object getCollection() {
            return this.col;
        }

        public Iterator<?> getIterator() {
            if (Collection.class.isAssignableFrom(this.col.getClass())) {
                return ((Collection)this.col).iterator();
            }
            return new ArrayIterator.Generic(this.col);
        }

        public TypeDefinition getCollectionType() {
            return this.colType;
        }

        public TypeDefinition getElementType() {
            return this.elementType;
        }

        @Override
        public ObjectContext getContainerObjectContext() {
            return this.getParent().getContainerObjectContext();
        }
    }

    public static class AttributeContext
    extends SerializationContext {
        private SerializationClass.Attribute attribute;

        public AttributeContext(ObjectContext parent, SerializationClass.Attribute attribute) {
            super(parent);
            this.attribute = attribute;
        }

        @Override
        public ObjectContext getParent() {
            return (ObjectContext)super.getParent();
        }

        public SerializationClass.Attribute getAttribute() {
            return this.attribute;
        }

        @Override
        public ObjectContext getContainerObjectContext() {
            return this.getParent();
        }
    }

    public static class ObjectContext
    extends SerializationContext {
        private Object instance;
        private SerializationClass clazz;
        private TypeDefinition originalType;

        public ObjectContext(SerializationContext parent, Object instance, SerializationClass clazz, TypeDefinition originalType) {
            super(parent);
            this.instance = instance;
            this.clazz = clazz;
            this.originalType = originalType;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void setInstance(Object instance) {
            this.instance = instance;
        }

        public SerializationClass getSerializationClass() {
            return this.clazz;
        }

        public void setSerializationClass(SerializationClass clazz) {
            this.clazz = clazz;
        }

        public TypeDefinition getOriginalType() {
            return this.originalType;
        }

        public void setOriginalType(TypeDefinition originalType) {
            this.originalType = originalType;
        }

        @Override
        public ObjectContext getContainerObjectContext() {
            return this;
        }
    }
}

