/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization;

import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;

public interface SerializationContextPattern {
    public boolean matches(SerializationClass var1, SerializationContext var2);

    public boolean matches(SerializationClass var1, SerializationContext var2, SerializationClass.Attribute var3);

    public boolean matches(SerializationContext var1);

    public boolean isEquivalent(SerializationContextPattern var1);

    public static class OnClassAttribute
    extends OnClass {
        private String attributeName;

        public OnClassAttribute(Class<?> clazz, String attributeName) {
            super(clazz);
            this.attributeName = attributeName;
        }

        public String getAttributeOriginalName() {
            return this.attributeName;
        }

        public SerializationClass.Attribute getAttribute(SerializationClass type, SerializationContext context) {
            if (!this.matches(type, context)) {
                return null;
            }
            SerializationClass.Attribute a = type.getAttributeByOriginalName(this.attributeName);
            if (a == null) {
                return null;
            }
            if (!this.matches(type, context, a)) {
                return null;
            }
            return a;
        }

        @Override
        public boolean matches(SerializationClass type, SerializationContext context, SerializationClass.Attribute attribute) {
            if (!super.matches(type, context, attribute)) {
                return false;
            }
            return attribute.getOriginalName().equals(this.attributeName);
        }

        @Override
        public boolean matches(SerializationContext context) {
            if (context == null) {
                return false;
            }
            if (context instanceof SerializationContext.CollectionContext) {
                return this.matches(((SerializationContext.CollectionContext)context).getParent());
            }
            if (context instanceof SerializationContext.AttributeContext) {
                SerializationClass.Attribute a = ((SerializationContext.AttributeContext)context).getAttribute();
                return a.getDeclaringClass().equals(this.clazz) && a.getOriginalName().equals(this.attributeName);
            }
            return false;
        }

        @Override
        public boolean isEquivalent(SerializationContextPattern p) {
            if (!(p instanceof OnClassAttribute)) {
                return false;
            }
            OnClassAttribute o = (OnClassAttribute)p;
            return this.clazz.equals(o.clazz) && this.attributeName.equals(o.attributeName);
        }
    }

    public static class OnClass
    implements SerializationContextPattern {
        protected Class<?> clazz;

        public OnClass(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getTargetClass() {
            return this.clazz;
        }

        @Override
        public boolean matches(SerializationClass type, SerializationContext context) {
            return this.clazz.isAssignableFrom(type.getType().getBase());
        }

        @Override
        public boolean matches(SerializationClass type, SerializationContext context, SerializationClass.Attribute attribute) {
            return this.clazz.equals(attribute.getDeclaringClass());
        }

        @Override
        public boolean matches(SerializationContext context) {
            if (context == null) {
                return false;
            }
            if (context instanceof SerializationContext.CollectionContext) {
                return this.matches(((SerializationContext.CollectionContext)context).getParent());
            }
            if (context instanceof SerializationContext.AttributeContext) {
                return ((SerializationContext.AttributeContext)context).getAttribute().getDeclaringClass().equals(this.clazz);
            }
            if (context instanceof SerializationContext.ObjectContext) {
                return this.clazz.isAssignableFrom(((SerializationContext.ObjectContext)context).getSerializationClass().getType().getBase());
            }
            return false;
        }

        @Override
        public boolean isEquivalent(SerializationContextPattern p) {
            if (!(p instanceof OnClass)) {
                return false;
            }
            OnClass o = (OnClass)p;
            return this.clazz.equals(o.clazz);
        }
    }
}

