/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.io.serialization.CustomSerializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnType;
import net.lecousin.framework.io.serialization.rules.CustomAttributeSerializer;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface TypeSerializationMethod {
    public String value();

    public static class ToRule
    implements AttributeAnnotationToRuleOnType<TypeSerializationMethod> {
        @Override
        public SerializationRule createRule(TypeSerializationMethod annotation, SerializationClass.Attribute attribute) {
            try {
                final TypeDefinition sourceType = attribute.getOriginalType();
                final Method method = sourceType.getBase().getMethod(annotation.value(), new Class[0]);
                final TypeDefinition targetType = new TypeDefinition(sourceType, method.getGenericReturnType());
                final Constructor<?> ctor = sourceType.getBase().getConstructor(targetType.getBase());
                return new CustomAttributeSerializer(attribute.getDeclaringClass(), attribute.getOriginalName(), new CustomSerializer(){

                    @Override
                    public TypeDefinition sourceType() {
                        return sourceType;
                    }

                    @Override
                    public TypeDefinition targetType() {
                        return targetType;
                    }

                    @Override
                    public Object serialize(Object src, Object containerInstance) {
                        if (src == null) {
                            return null;
                        }
                        try {
                            return method.invoke(src, new Object[0]);
                        }
                        catch (Throwable t) {
                            LCCore.getApplication().getDefaultLogger().error("Error calling method " + method.getName() + " on class " + method.getDeclaringClass().getName(), t);
                            return null;
                        }
                    }

                    @Override
                    public Object deserialize(Object src, Object containerInstance) {
                        if (src == null) {
                            return null;
                        }
                        try {
                            return ctor.newInstance(src);
                        }
                        catch (Throwable t) {
                            LCCore.getApplication().getDefaultLogger().error("Error instantiating type " + sourceType.getBase().getName(), t);
                            return null;
                        }
                    }
                });
            }
            catch (Throwable t) {
                LCCore.getApplication().getDefaultLogger().error("Error creating CustomAttributeSerializer from annotation TypeSerializationMethod", t);
                return null;
            }
        }
    }
}

