/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.rules;

import java.util.List;
import net.lecousin.framework.io.serialization.CustomSerializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationContextPattern;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

public class CustomAttributeSerializer
implements SerializationRule {
    private SerializationContextPattern.OnClassAttribute pattern;
    private CustomSerializer serializer;

    public CustomAttributeSerializer(SerializationContextPattern.OnClassAttribute pattern, CustomSerializer serializer) {
        this.pattern = pattern;
        this.serializer = serializer;
    }

    public CustomAttributeSerializer(Class<?> type, String name, CustomSerializer serializer) {
        this(new SerializationContextPattern.OnClassAttribute(type, name), serializer);
    }

    @Override
    public boolean apply(SerializationClass type, SerializationContext context, List<SerializationRule> rules, boolean serializing) {
        SerializationClass.Attribute a = this.pattern.getAttribute(type, context);
        if (a == null) {
            return false;
        }
        if (a instanceof CustomAttribute && ((CustomAttribute)a).getCustomSerializer().getClass().equals(this.serializer.getClass())) {
            return false;
        }
        CustomAttribute ca = new CustomAttribute(a, this.serializer);
        type.replaceAttribute(a, ca);
        return false;
    }

    @Override
    public boolean isEquivalent(SerializationRule rule) {
        if (!(rule instanceof CustomAttributeSerializer)) {
            return false;
        }
        CustomAttributeSerializer r = (CustomAttributeSerializer)rule;
        return r.pattern.isEquivalent(this.pattern) && r.serializer.getClass().equals(this.serializer.getClass());
    }

    public static class CustomAttribute
    extends SerializationClass.Attribute {
        private CustomSerializer serializer;

        public CustomAttribute(SerializationClass.Attribute a, CustomSerializer serializer) {
            super(a);
            this.serializer = serializer;
            this.setType(serializer.targetType());
        }

        public CustomSerializer getCustomSerializer() {
            return this.serializer;
        }

        @Override
        public Object getValue(Object instance) throws Exception {
            Object source = super.getValue(instance);
            return this.serializer.serialize(source, instance);
        }

        @Override
        public void setValue(Object instance, Object value) throws Exception {
            super.setValue(instance, this.serializer.deserialize(value, instance));
        }
    }
}

