/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.rules;

import java.util.List;
import java.util.ListIterator;
import net.lecousin.framework.io.serialization.CustomSerializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationContextPattern;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.rules.CustomAttributeSerializer;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

public class CustomTypeSerializer
implements SerializationRule {
    private CustomSerializer serializer;
    private SerializationContextPattern context;

    public CustomTypeSerializer(CustomSerializer serializer, SerializationContextPattern context) {
        this.serializer = serializer;
        this.context = context;
    }

    @Override
    public boolean apply(SerializationClass type, SerializationContext context, List<SerializationRule> rules, boolean serializing) {
        if (this.context != null && !this.context.matches(type, context)) {
            return false;
        }
        ListIterator<SerializationClass.Attribute> it = type.getAttributes().listIterator();
        while (it.hasNext()) {
            SerializationClass.Attribute a = it.next();
            if (this.context != null && !this.context.matches(type, context, a) || !a.getType().equals(this.serializer.sourceType()) || a instanceof CustomAttributeSerializer.CustomAttribute && ((CustomAttributeSerializer.CustomAttribute)a).getCustomSerializer().getClass().equals(this.serializer.getClass())) continue;
            it.set(new CustomAttributeSerializer.CustomAttribute(a, this.serializer));
        }
        return false;
    }

    @Override
    public Object convertSerializationValue(Object value, TypeDefinition type, SerializationContext context) {
        if (!type.equals(this.serializer.sourceType())) {
            return value;
        }
        if (this.context != null && !this.context.matches(context)) {
            return value;
        }
        return this.serializer.serialize(value, context.getContainerObjectContext().getInstance());
    }

    @Override
    public TypeDefinition getDeserializationType(TypeDefinition type, SerializationContext context) {
        if (!type.equals(this.serializer.sourceType())) {
            return type;
        }
        if (this.context != null && !this.context.matches(context)) {
            return type;
        }
        return this.serializer.targetType();
    }

    @Override
    public Object getDeserializationValue(Object value, TypeDefinition type, SerializationContext context) {
        if (!type.equals(this.serializer.sourceType())) {
            return value;
        }
        if (this.context != null && !this.context.matches(context)) {
            return value;
        }
        return this.serializer.deserialize(value, context.getContainerObjectContext().getInstance());
    }

    @Override
    public boolean isEquivalent(SerializationRule rule) {
        if (!(rule instanceof CustomTypeSerializer)) {
            return false;
        }
        CustomTypeSerializer r = (CustomTypeSerializer)rule;
        return r.serializer.getClass().equals(this.serializer.getClass());
    }
}

