/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.rules;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationContextPattern;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.annotations.AttributeAnnotationToRuleOnType;
import net.lecousin.framework.io.serialization.annotations.TypeAnnotationToRule;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.util.ClassUtil;

public class MergeTypeAttributes
implements SerializationRule {
    private SerializationContextPattern contextPattern;
    private Class<?> type;
    private String targetAttributeName;

    public MergeTypeAttributes(SerializationContextPattern contextPattern, Class<?> type, String targetAttributeName) {
        this.contextPattern = contextPattern;
        this.type = type;
        this.targetAttributeName = targetAttributeName;
    }

    @Override
    public boolean apply(SerializationClass type, SerializationContext context, List<SerializationRule> rules, boolean serializing) throws Exception {
        if (context instanceof SerializationContext.ObjectContext) {
            TypeDefinition targetType;
            Field f;
            SerializationContext.ObjectContext octx = (SerializationContext.ObjectContext)context;
            if (octx.getParent() instanceof SerializationContext.AttributeContext) {
                SerializationContext.AttributeContext actx = (SerializationContext.AttributeContext)octx.getParent();
                if (actx.getAttribute() instanceof MergeTargetAttribute) {
                    MergeTargetAttribute ma = (MergeTargetAttribute)actx.getAttribute();
                    if (serializing) {
                        Object targetInstance;
                        Object containerObject = octx.getInstance();
                        Method getter = ClassUtil.getGetter(containerObject.getClass(), this.targetAttributeName);
                        if (getter != null) {
                            targetInstance = getter.invoke(containerObject, new Object[0]);
                        } else {
                            f = ClassUtil.getField(containerObject.getClass(), this.targetAttributeName);
                            if (f != null) {
                                targetInstance = f.get(containerObject);
                            } else {
                                throw new Exception("Cannot find attribute " + this.targetAttributeName + " on class " + containerObject.getClass().getName());
                            }
                        }
                        octx.setInstance(targetInstance);
                        SerializationClass containerClass = octx.getSerializationClass();
                        SerializationClass sc = new SerializationClass(TypeDefinition.from(targetInstance.getClass(), ma.targetType));
                        octx.setSerializationClass(sc);
                        octx.setOriginalType(ma.targetType);
                        for (SerializationClass.Attribute attribute : containerClass.getAttributes()) {
                            if (attribute.getOriginalName().equals(this.targetAttributeName)) continue;
                            sc.getAttributes().add(new MergedAttribute(attribute, sc, containerObject));
                        }
                    } else {
                        Object mergedInstance = SerializationClass.instantiate(ma.targetType.getBase());
                        Method setter = ClassUtil.getSetter(this.type, this.targetAttributeName);
                        if (setter != null) {
                            setter.invoke(octx.getInstance(), mergedInstance);
                        } else {
                            Field f2 = ClassUtil.getField(this.type, this.targetAttributeName);
                            if (f2 != null) {
                                f2.set(octx.getInstance(), mergedInstance);
                            } else {
                                throw new Exception("Cannot find attribute " + this.targetAttributeName + " on class " + this.type.getName());
                            }
                        }
                        Iterator<SerializationClass.Attribute> it = octx.getSerializationClass().getAttributes().iterator();
                        while (it.hasNext()) {
                            if (!it.next().getOriginalName().equals(this.targetAttributeName)) continue;
                            it.remove();
                            break;
                        }
                        SerializationClass sc = new SerializationClass(ma.targetType);
                        for (SerializationClass.Attribute a : sc.getAttributes()) {
                            octx.getSerializationClass().getAttributes().add(new MergedAttribute(a, octx.getSerializationClass(), mergedInstance));
                        }
                    }
                }
            } else if (this.type.isAssignableFrom(octx.getSerializationClass().getType().getBase())) {
                if (octx.getParent() instanceof SerializationContext.CollectionContext) {
                    TypeDefinition targetType2;
                    SerializationContext.AttributeContext actx;
                    SerializationContext.CollectionContext cctx = (SerializationContext.CollectionContext)octx.getParent();
                    while (cctx.getParent() instanceof SerializationContext.CollectionContext) {
                        cctx = (SerializationContext.CollectionContext)cctx.getParent();
                    }
                    if (cctx.getParent() instanceof SerializationContext.AttributeContext && this.contextPattern.matches(actx = (SerializationContext.AttributeContext)cctx.getParent()) && (targetType2 = SerializationClass.searchAttributeType(octx.getOriginalType(), this.targetAttributeName)) != null) {
                        if (serializing) {
                            Object targetInstance;
                            Object containerObject = octx.getInstance();
                            Method getter = ClassUtil.getGetter(containerObject.getClass(), this.targetAttributeName);
                            if (getter != null) {
                                targetInstance = getter.invoke(containerObject, new Object[0]);
                            } else {
                                Field f3 = ClassUtil.getField(containerObject.getClass(), this.targetAttributeName);
                                if (f3 != null) {
                                    targetInstance = f3.get(containerObject);
                                } else {
                                    throw new Exception("Cannot find attribute " + this.targetAttributeName + " on class " + containerObject.getClass().getName());
                                }
                            }
                            octx.setInstance(targetInstance);
                            SerializationClass containerClass = octx.getSerializationClass();
                            SerializationClass sc = new SerializationClass(TypeDefinition.from(targetInstance.getClass(), targetType2));
                            octx.setSerializationClass(sc);
                            octx.setOriginalType(targetType2);
                            for (SerializationClass.Attribute a : containerClass.getAttributes()) {
                                if (a.getOriginalName().equals(this.targetAttributeName)) continue;
                                sc.getAttributes().add(new MergedAttribute(a, sc, containerObject));
                            }
                        } else {
                            Object mergedInstance = SerializationClass.instantiate(targetType2.getBase());
                            Method setter = ClassUtil.getSetter(this.type, this.targetAttributeName);
                            if (setter != null) {
                                setter.invoke(octx.getInstance(), mergedInstance);
                            } else {
                                f = ClassUtil.getField(this.type, this.targetAttributeName);
                                if (f != null) {
                                    f.set(octx.getInstance(), mergedInstance);
                                } else {
                                    throw new Exception("Cannot find attribute " + this.targetAttributeName + " on class " + this.type.getName());
                                }
                            }
                            Iterator<SerializationClass.Attribute> it = octx.getSerializationClass().getAttributes().iterator();
                            while (it.hasNext()) {
                                if (!it.next().getOriginalName().equals(this.targetAttributeName)) continue;
                                it.remove();
                                break;
                            }
                            SerializationClass sc = new SerializationClass(targetType2);
                            for (SerializationClass.Attribute a : sc.getAttributes()) {
                                octx.getSerializationClass().getAttributes().add(new MergedAttribute(a, octx.getSerializationClass(), mergedInstance));
                            }
                        }
                    }
                }
            } else if (!serializing && this.type.isAssignableFrom(octx.getOriginalType().getBase()) && (targetType = SerializationClass.searchAttributeType(octx.getOriginalType(), this.targetAttributeName)) != null) {
                Object mergedInstance = octx.getInstance();
                Object containerInstance = SerializationClass.instantiate(octx.getOriginalType().getBase());
                Method setter = ClassUtil.getSetter(this.type, this.targetAttributeName);
                if (setter != null) {
                    setter.invoke(containerInstance, mergedInstance);
                } else {
                    Field f4 = ClassUtil.getField(this.type, this.targetAttributeName);
                    if (f4 != null) {
                        f4.set(containerInstance, mergedInstance);
                    } else {
                        throw new Exception("Cannot find attribute " + this.targetAttributeName + " on class " + this.type.getName());
                    }
                }
                octx.setInstance(containerInstance);
                SerializationClass containerClass = new SerializationClass(octx.getOriginalType());
                SerializationClass targetClass = octx.getSerializationClass();
                octx.setSerializationClass(containerClass);
                Iterator<SerializationClass.Attribute> it = containerClass.getAttributes().iterator();
                while (it.hasNext()) {
                    if (!it.next().getOriginalName().equals(this.targetAttributeName)) continue;
                    it.remove();
                    break;
                }
                List<SerializationRule> subRules = rules.subList(rules.indexOf(this) + 1, rules.size());
                targetClass.apply(subRules, context, serializing);
                for (SerializationClass.Attribute attribute : targetClass.getAttributes()) {
                    containerClass.getAttributes().add(new MergedAttribute(attribute, containerClass, mergedInstance));
                }
                List<SerializationRule> newRules = TypeAnnotationToRule.addRules(containerClass.getType().getBase(), rules);
                newRules = AttributeAnnotationToRuleOnType.addRules(containerClass, false, newRules);
                newRules.remove(this);
                containerClass.apply(newRules, context, serializing);
                return true;
            }
        }
        if (!this.contextPattern.matches(type, context)) {
            return false;
        }
        ListIterator<SerializationClass.Attribute> it = type.getAttributes().listIterator();
        while (it.hasNext()) {
            TypeDefinition t;
            SerializationClass.Attribute a = it.next();
            if (!a.getOriginalType().getBase().equals(this.type) || (t = SerializationClass.searchAttributeType(a.getOriginalType(), this.targetAttributeName)) == null) continue;
            it.set(new MergeTargetAttribute(a, t));
        }
        return false;
    }

    @Override
    public boolean isEquivalent(SerializationRule rule) {
        if (!(rule instanceof MergeTypeAttributes)) {
            return false;
        }
        MergeTypeAttributes r = (MergeTypeAttributes)rule;
        return r.type.equals(this.type) && r.targetAttributeName.equals(this.targetAttributeName);
    }

    private static class MergedAttribute
    extends SerializationClass.Attribute {
        private Object containerInstance;

        public MergedAttribute(SerializationClass.Attribute original, SerializationClass newParent, Object containerInstance) {
            super(original);
            this.parent = newParent;
            this.containerInstance = containerInstance;
        }

        @Override
        public Object getValue(Object instance) throws Exception {
            return super.getValue(this.containerInstance);
        }

        @Override
        public void setValue(Object instance, Object value) throws Exception {
            super.setValue(this.containerInstance, value);
        }
    }

    private class MergeTargetAttribute
    extends SerializationClass.Attribute {
        private TypeDefinition targetType;

        public MergeTargetAttribute(SerializationClass.Attribute originalAttribute, TypeDefinition targetType) {
            super(originalAttribute);
            this.targetType = targetType;
        }
    }
}

