/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.util.ConcurrentCloseable;

public class BufferedReadableCharacterStream
extends ConcurrentCloseable
implements ICharacterStream.Readable.Buffered {
    private IO.Readable input;
    private CharsetDecoder decoder;
    private int bufferSize;
    private TurnArray<CharBuffer> ready;
    private ByteBuffer bytes;
    private CharBuffer chars;
    private boolean endReached = false;
    private int back = -1;
    private SynchronizationPoint<IOException> nextReady = new SynchronizationPoint();

    public BufferedReadableCharacterStream(IO.Readable input, Charset charset, int bufferSize, int maxBuffers) {
        this(input, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), bufferSize, maxBuffers);
    }

    public BufferedReadableCharacterStream(IO.Readable input, CharsetDecoder decoder, int bufferSize, int maxBuffers) {
        this(input, decoder, bufferSize, maxBuffers, null, null);
    }

    public BufferedReadableCharacterStream(IO.Readable input, Charset charset, int bufferSize, int maxBuffers, ByteBuffer initBytes, CharBuffer initChars) {
        this(input, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), bufferSize, maxBuffers, initBytes, initChars);
    }

    public BufferedReadableCharacterStream(IO.Readable input, CharsetDecoder decoder, int bufferSize, int maxBuffers, ByteBuffer initBytes, CharBuffer initChars) {
        this.input = input;
        this.decoder = decoder;
        if (bufferSize < 64) {
            bufferSize = 64;
        }
        this.bufferSize = bufferSize;
        this.ready = new TurnArray(maxBuffers);
        this.bytes = ByteBuffer.allocate(bufferSize);
        if (initBytes == null) {
            this.bytes.limit(0);
        } else {
            this.bytes.put(initBytes);
            this.bytes.flip();
        }
        this.chars = initChars;
        if (input instanceof IO.Readable.Buffered) {
            ((IO.Readable.Buffered)input).canStartReading().listenInline(new Runnable(){

                @Override
                public void run() {
                    BufferedReadableCharacterStream.this.bufferize();
                }
            });
        } else {
            this.bufferize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizationPoint<IOException> canStartReading() {
        TurnArray<CharBuffer> turnArray = this.ready;
        synchronized (turnArray) {
            if (this.ready.isEmpty()) {
                return this.nextReady;
            }
            return new SynchronizationPoint<boolean>(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        TurnArray<CharBuffer> turnArray = this.ready;
        synchronized (turnArray) {
            this.nextReady.cancel(new CancelException("Closed"));
        }
        return this.input.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.bytes = null;
        this.chars = null;
        this.decoder = null;
        this.ready = null;
        this.input = null;
        ondone.unblock();
    }

    @Override
    public String getDescription() {
        return this.input.getSourceDescription();
    }

    @Override
    public Charset getEncoding() {
        return this.decoder.charset();
    }

    @Override
    public byte getPriority() {
        return this.input.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.input.setPriority(priority);
    }

    private void bufferize() {
        this.bytes.compact();
        final int remaining = this.bytes.remaining();
        final AsyncWork<Integer, IOException> readTask = this.input.readFullyAsync(this.bytes);
        Task.Cpu<Void, NoException> decode = new Task.Cpu<Void, NoException>("Decode character stream", this.input.getPriority()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                if (BufferedReadableCharacterStream.this.nextReady.isCancelled()) {
                    return null;
                }
                if (readTask.isCancelled()) {
                    if (BufferedReadableCharacterStream.this.bytes == null) {
                        return null;
                    }
                    TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
                    synchronized (turnArray) {
                        BufferedReadableCharacterStream.this.nextReady.cancel(readTask.getCancelEvent());
                    }
                    return null;
                }
                if (readTask.hasError()) {
                    TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
                    synchronized (turnArray) {
                        BufferedReadableCharacterStream.this.nextReady.error(readTask.getError());
                    }
                    return null;
                }
                if (BufferedReadableCharacterStream.this.nextReady.isCancelled()) {
                    return null;
                }
                try {
                    SynchronizationPoint sp;
                    boolean full;
                    boolean end;
                    int nb = (Integer)readTask.getResult();
                    BufferedReadableCharacterStream.this.bytes.flip();
                    if (nb < remaining) {
                        BufferedReadableCharacterStream.this.input.closeAsync();
                        if (!BufferedReadableCharacterStream.this.bytes.hasRemaining()) {
                            TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
                            synchronized (turnArray) {
                                BufferedReadableCharacterStream.this.endReached = true;
                                BufferedReadableCharacterStream.this.nextReady.unblock();
                            }
                            return null;
                        }
                        end = true;
                    } else {
                        end = false;
                    }
                    if (BufferedReadableCharacterStream.this.nextReady.isCancelled()) {
                        return null;
                    }
                    CharBuffer buf = CharBuffer.allocate(BufferedReadableCharacterStream.this.bufferSize);
                    CoderResult cr = BufferedReadableCharacterStream.this.decoder.decode(BufferedReadableCharacterStream.this.bytes, buf, BufferedReadableCharacterStream.this.endReached);
                    if (cr.isOverflow() && buf.position() == 0) {
                        cr.throwException();
                    }
                    if (BufferedReadableCharacterStream.this.nextReady.isCancelled()) {
                        return null;
                    }
                    if (buf.position() == 0) {
                        if (end) {
                            TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
                            synchronized (turnArray) {
                                BufferedReadableCharacterStream.this.endReached = true;
                                BufferedReadableCharacterStream.this.nextReady.unblock();
                            }
                            return null;
                        }
                        throw new EOFException();
                    }
                    buf.flip();
                    TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
                    synchronized (turnArray) {
                        BufferedReadableCharacterStream.this.ready.addLast(buf);
                        full = BufferedReadableCharacterStream.this.ready.isFull();
                        sp = BufferedReadableCharacterStream.this.nextReady;
                        if (end) {
                            BufferedReadableCharacterStream.this.nextReady = new SynchronizationPoint<boolean>(true);
                        } else {
                            BufferedReadableCharacterStream.this.nextReady = new SynchronizationPoint();
                        }
                        BufferedReadableCharacterStream.this.endReached = end;
                    }
                    sp.unblock();
                    if (!full && !BufferedReadableCharacterStream.this.endReached) {
                        BufferedReadableCharacterStream.this.bufferize();
                    }
                    return null;
                }
                catch (IOException e) {
                    if (!BufferedReadableCharacterStream.this.nextReady.isUnblocked()) {
                        TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
                        synchronized (turnArray) {
                            BufferedReadableCharacterStream.this.nextReady.error(e);
                        }
                    }
                    return null;
                }
                catch (NullPointerException e) {
                    return null;
                }
                catch (Throwable t) {
                    if (!BufferedReadableCharacterStream.this.nextReady.isUnblocked()) {
                        TurnArray turnArray = BufferedReadableCharacterStream.this.ready;
                        synchronized (turnArray) {
                            BufferedReadableCharacterStream.this.nextReady.error(IO.error(t));
                        }
                    }
                    LCCore.getApplication().getDefaultLogger().error("Error while buffering", t);
                    return null;
                }
            }
        };
        ((Task.Cpu)this.operation(decode)).startOn(readTask, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean endReached() {
        if (this.endReached && this.chars == null) {
            TurnArray<CharBuffer> turnArray = this.ready;
            synchronized (turnArray) {
                if (this.endReached && this.chars == null && this.ready.isEmpty()) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void back(char c) {
        this.back = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char read() throws EOFException, IOException {
        TurnArray<CharBuffer> turnArray;
        if (this.back != -1) {
            char c = (char)this.back;
            this.back = -1;
            return c;
        }
        while (this.chars == null) {
            SynchronizationPoint<IOException> sp;
            boolean full;
            turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.chars = this.ready.pollFirst();
                if (this.chars == null && this.endReached) {
                    throw new EOFException();
                }
                if (this.nextReady.hasError()) {
                    throw this.nextReady.getError();
                }
                sp = this.nextReady;
            }
            if (full && !this.endReached) {
                this.bufferize();
            }
            if (this.chars != null) break;
            sp.block(0L);
        }
        char c = this.chars.get();
        if (!this.chars.hasRemaining()) {
            boolean full;
            turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.chars = this.ready.pollFirst();
            }
            if (full && !this.endReached) {
                this.bufferize();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readSync(char[] buf, int offset, int length) throws IOException {
        int len;
        TurnArray<CharBuffer> turnArray;
        if (length <= 0) {
            return 0;
        }
        int done = 0;
        if (this.back != -1) {
            buf[offset++] = (char)this.back;
            this.back = -1;
            if (--length == 0) {
                return 1;
            }
            done = 1;
        }
        while (this.chars == null) {
            SynchronizationPoint<IOException> sp;
            boolean full;
            turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.chars = this.ready.pollFirst();
                sp = this.nextReady;
                if (this.chars == null && this.endReached) {
                    if (done > 0) {
                        return done;
                    }
                    return -1;
                }
            }
            if (full && !this.endReached) {
                this.bufferize();
            }
            if (this.chars != null) break;
            sp.block(0L);
            if (sp.hasError()) {
                throw sp.getError();
            }
            if (!sp.isCancelled()) continue;
            throw IO.error(sp.getCancelEvent());
        }
        if ((len = length) > this.chars.remaining()) {
            len = this.chars.remaining();
        }
        this.chars.get(buf, offset, len);
        if (!this.chars.hasRemaining()) {
            boolean full;
            turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.chars = this.ready.pollFirst();
            }
            if (full && !this.endReached) {
                this.bufferize();
            }
        }
        return len + done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readAsync() throws IOException {
        if (this.back != -1) {
            char c = (char)this.back;
            this.back = -1;
            return c;
        }
        if (this.chars == null) {
            boolean full;
            TurnArray<CharBuffer> turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.chars = this.ready.pollFirst();
                if (this.chars == null && this.endReached) {
                    return -1;
                }
                if (this.nextReady.hasError()) {
                    throw this.nextReady.getError();
                }
            }
            if (full && !this.endReached) {
                this.bufferize();
            }
            if (this.chars == null) {
                return -2;
            }
        }
        char c = this.chars.get();
        if (!this.chars.hasRemaining()) {
            boolean full;
            TurnArray<CharBuffer> turnArray = this.ready;
            synchronized (turnArray) {
                full = this.ready.isFull();
                this.chars = this.ready.pollFirst();
            }
            if (full && !this.endReached) {
                this.bufferize();
            }
        }
        return c;
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(final char[] buf, final int off, final int len) {
        if (len <= 0) {
            return new AsyncWork<Integer, Object>(0, null);
        }
        final AsyncWork<Integer, IOException> result = new AsyncWork<Integer, IOException>();
        this.operation(new Task.Cpu<Void, NoException>("BufferedReadableCharacterStream.readAsync", this.input.getPriority()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                int len2;
                TurnArray turnArray;
                int done = 0;
                int offset = off;
                int length = len;
                if (BufferedReadableCharacterStream.this.back != -1) {
                    buf[offset++] = (char)BufferedReadableCharacterStream.this.back;
                    BufferedReadableCharacterStream.this.back = -1;
                    if (--length == 0) {
                        result.unblockSuccess(1);
                        return null;
                    }
                    done = 1;
                }
                if (BufferedReadableCharacterStream.this.chars == null) {
                    SynchronizationPoint sp;
                    boolean full;
                    turnArray = BufferedReadableCharacterStream.this.ready;
                    synchronized (turnArray) {
                        full = BufferedReadableCharacterStream.this.ready.isFull();
                        BufferedReadableCharacterStream.this.chars = (CharBuffer)BufferedReadableCharacterStream.this.ready.pollFirst();
                        sp = BufferedReadableCharacterStream.this.nextReady;
                        if (BufferedReadableCharacterStream.this.chars == null && BufferedReadableCharacterStream.this.endReached) {
                            if (done > 0) {
                                result.unblockSuccess(done);
                            } else {
                                result.unblockSuccess(-1);
                            }
                            return null;
                        }
                    }
                    if (full && !BufferedReadableCharacterStream.this.endReached) {
                        BufferedReadableCharacterStream.this.bufferize();
                    }
                    if (BufferedReadableCharacterStream.this.chars == null) {
                        int don = done;
                        BufferedReadableCharacterStream.this.readAsync(buf, offset + done, length - done).listenInline(nb -> result.unblockSuccess(don + nb), (ISynchronizationPoint<IOException>)result);
                        return null;
                    }
                    if (sp.hasError()) {
                        result.error(sp.getError());
                        return null;
                    }
                    if (sp.isCancelled()) {
                        result.cancel(sp.getCancelEvent());
                        return null;
                    }
                }
                if ((len2 = length) > BufferedReadableCharacterStream.this.chars.remaining()) {
                    len2 = BufferedReadableCharacterStream.this.chars.remaining();
                }
                BufferedReadableCharacterStream.this.chars.get(buf, offset, len2);
                if (!BufferedReadableCharacterStream.this.chars.hasRemaining()) {
                    boolean full;
                    turnArray = BufferedReadableCharacterStream.this.ready;
                    synchronized (turnArray) {
                        full = BufferedReadableCharacterStream.this.ready.isFull();
                        BufferedReadableCharacterStream.this.chars = (CharBuffer)BufferedReadableCharacterStream.this.ready.pollFirst();
                    }
                    if (full && !BufferedReadableCharacterStream.this.endReached) {
                        BufferedReadableCharacterStream.this.bufferize();
                    }
                }
                result.unblockSuccess(len2 + done);
                return null;
            }
        }).startOn(this.canStartReading(), true);
        return result;
    }
}

