/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.util.ConcurrentCloseable;

public class BufferedWritableCharacterStream
extends ConcurrentCloseable
implements ICharacterStream.Writable.Buffered {
    private IO.Writable output;
    private CharsetEncoder encoder;
    private char[] buffer;
    private char[] buffer2;
    private CharBuffer cb;
    private CharBuffer cb2;
    private ByteBuffer encodedBuffer;
    private int pos = 0;
    private SynchronizationPoint<IOException> flushing = null;

    public BufferedWritableCharacterStream(IO.Writable output, Charset charset, int bufferSize) {
        this(output, charset.newEncoder(), bufferSize);
    }

    public BufferedWritableCharacterStream(IO.Writable output, CharsetEncoder encoder, int bufferSize) {
        this.output = output;
        this.encoder = encoder;
        this.buffer = new char[bufferSize];
        this.buffer2 = new char[bufferSize];
        this.cb = CharBuffer.wrap(this.buffer);
        this.cb2 = CharBuffer.wrap(this.buffer2);
        this.encodedBuffer = ByteBuffer.allocate(bufferSize * 2);
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return this.output.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.output = null;
        this.encoder = null;
        this.buffer = null;
        this.buffer2 = null;
        this.cb = null;
        this.cb2 = null;
        this.encodedBuffer = null;
        ondone.unblock();
    }

    @Override
    public byte getPriority() {
        return this.output.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.output.setPriority(priority);
    }

    @Override
    public String getDescription() {
        return this.output.getSourceDescription();
    }

    @Override
    public Charset getEncoding() {
        return this.encoder.charset();
    }

    private void encodeAndWrite() {
        new Task.Cpu<Void, NoException>("Encoding characters", this.output.getPriority()){

            @Override
            public Void run() {
                BufferedWritableCharacterStream.this.encodedBuffer.clear();
                final CoderResult result = BufferedWritableCharacterStream.this.encoder.encode(BufferedWritableCharacterStream.this.cb2, BufferedWritableCharacterStream.this.encodedBuffer, false);
                if (result.isError()) {
                    BufferedWritableCharacterStream.this.flushing.error(new IOException("Encoding error"));
                    return null;
                }
                BufferedWritableCharacterStream.this.encodedBuffer.flip();
                final AsyncWork<Integer, IOException> writing = BufferedWritableCharacterStream.this.output.writeAsync(BufferedWritableCharacterStream.this.encodedBuffer);
                writing.listenInline(new Runnable(){

                    @Override
                    public void run() {
                        if (!writing.isSuccessful()) {
                            BufferedWritableCharacterStream.this.flushing.error(writing.getError());
                        } else if (result.isOverflow()) {
                            BufferedWritableCharacterStream.this.encodeAndWrite();
                        } else {
                            BufferedWritableCharacterStream.this.cb2.clear();
                            BufferedWritableCharacterStream.this.flushing.unblock();
                        }
                    }
                });
                return null;
            }
        }.start();
        this.operation(this.flushing);
    }

    private ISynchronizationPoint<IOException> finalFlush(SynchronizationPoint<IOException> sp, boolean flushOnly) {
        CoderResult result;
        this.encodedBuffer.clear();
        if (!flushOnly) {
            this.cb2.limit(this.pos);
            result = this.encoder.encode(this.cb2, this.encodedBuffer, true);
            if (!result.isOverflow()) {
                flushOnly = true;
                result = this.encoder.flush(this.encodedBuffer);
            }
        } else {
            result = this.encoder.flush(this.encodedBuffer);
        }
        this.encodedBuffer.flip();
        final AsyncWork<Integer, IOException> writing = this.encodedBuffer.hasRemaining() ? this.output.writeAsync(this.encodedBuffer) : new AsyncWork<Integer, Object>(0, null);
        if (!result.isOverflow()) {
            if (sp == null) {
                return writing;
            }
            writing.listenInline(sp);
            return this.operation(sp);
        }
        if (sp == null) {
            sp = new SynchronizationPoint();
        }
        final SynchronizationPoint<IOException> spp = sp;
        final boolean fo = flushOnly;
        writing.listenInline(new Runnable(){

            @Override
            public void run() {
                if (!writing.isSuccessful()) {
                    spp.error(writing.getError());
                } else {
                    BufferedWritableCharacterStream.this.finalFlush(spp, fo);
                }
            }
        });
        return this.operation(sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        while (true) {
            SynchronizationPoint<IOException> sp;
            IO.Writable writable = this.output;
            synchronized (writable) {
                if (this.flushing != null && this.flushing.isUnblocked()) {
                    if (this.flushing.hasError()) {
                        throw this.flushing.getError();
                    }
                    this.flushing = null;
                }
                if (this.flushing == null) {
                    char[] tmp1 = this.buffer2;
                    this.buffer2 = this.buffer;
                    this.buffer = tmp1;
                    CharBuffer tmp2 = this.cb2;
                    this.cb2 = this.cb;
                    this.cb = tmp2;
                    this.cb.clear();
                    this.flushing = new SynchronizationPoint();
                    this.cb2.limit(this.pos);
                    this.encodeAndWrite();
                    this.pos = 0;
                    return;
                }
                sp = this.flushing;
            }
            sp.block(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SynchronizationPoint<IOException> flushBufferAsync() {
        SynchronizationPoint<IOException> sp;
        IO.Writable writable = this.output;
        synchronized (writable) {
            if (this.flushing != null && this.flushing.isUnblocked()) {
                if (this.flushing.hasError()) {
                    return new SynchronizationPoint<IOException>(this.flushing.getError());
                }
                this.flushing = null;
            }
            if (this.flushing == null) {
                char[] tmp1 = this.buffer2;
                this.buffer2 = this.buffer;
                this.buffer = tmp1;
                CharBuffer tmp2 = this.cb2;
                this.cb2 = this.cb;
                this.cb = tmp2;
                this.cb.clear();
                this.flushing = new SynchronizationPoint();
                this.cb2.limit(this.pos);
                this.encodeAndWrite();
                this.pos = 0;
                return new SynchronizationPoint<boolean>(true);
            }
            sp = this.flushing;
        }
        SynchronizationPoint<IOException> result = new SynchronizationPoint<IOException>();
        sp.listenInline(() -> this.flushBufferAsync().listenInline(result), result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISynchronizationPoint<IOException> flush() {
        SynchronizationPoint<IOException> sp;
        IO.Writable writable = this.output;
        synchronized (writable) {
            if (this.flushing == null || this.flushing.isUnblocked()) {
                if (this.pos == 0) {
                    return this.finalFlush(null, false);
                }
                try {
                    this.flushBuffer();
                }
                catch (IOException e) {
                    return new SynchronizationPoint<IOException>(e);
                }
            }
            sp = this.flushing;
        }
        final SynchronizationPoint<IOException> sp2 = new SynchronizationPoint<IOException>();
        sp.listenInline(new Runnable(){

            @Override
            public void run() {
                if (sp.hasError()) {
                    sp2.error(sp.getError());
                } else {
                    BufferedWritableCharacterStream.this.flush().listenInline(sp2);
                }
            }
        });
        return sp2;
    }

    @Override
    public void writeSync(char c) throws IOException {
        this.buffer[this.pos++] = c;
        if (this.pos == this.buffer.length) {
            this.flushBuffer();
        }
    }

    @Override
    public void writeSync(char[] c, int off, int len) throws IOException {
        while (len > 0) {
            int l = len > this.buffer.length - this.pos ? this.buffer.length - this.pos : len;
            System.arraycopy(c, off, this.buffer, this.pos, l);
            this.pos += l;
            if (this.pos == this.buffer.length) {
                this.flushBuffer();
            }
            off += l;
            len -= l;
        }
    }

    @Override
    public ISynchronizationPoint<IOException> writeAsync(char c) {
        this.buffer[this.pos++] = c;
        if (this.pos == this.buffer.length) {
            return this.flushBufferAsync();
        }
        return new SynchronizationPoint<boolean>(true);
    }

    @Override
    public ISynchronizationPoint<IOException> writeAsync(char[] c, int off, int len) {
        SynchronizationPoint<IOException> result = new SynchronizationPoint<IOException>();
        this.writeAsync(c, off, len, result);
        return this.operation(result);
    }

    private void writeAsync(final char[] c, final int off, final int len, final SynchronizationPoint<IOException> result) {
        new Task.Cpu<Void, NoException>("BufferedWritableCharacterStream.writeAsync", this.output.getPriority()){

            @Override
            public Void run() {
                int l = len > BufferedWritableCharacterStream.this.buffer.length - BufferedWritableCharacterStream.this.pos ? BufferedWritableCharacterStream.this.buffer.length - BufferedWritableCharacterStream.this.pos : len;
                System.arraycopy(c, off, BufferedWritableCharacterStream.this.buffer, BufferedWritableCharacterStream.this.pos, l);
                BufferedWritableCharacterStream.this.pos = BufferedWritableCharacterStream.this.pos + l;
                if (l == len) {
                    if (BufferedWritableCharacterStream.this.pos == BufferedWritableCharacterStream.this.buffer.length) {
                        BufferedWritableCharacterStream.this.flushBufferAsync().listenInline(result);
                    } else {
                        result.unblock();
                    }
                    return null;
                }
                BufferedWritableCharacterStream.this.flushBufferAsync().listenInline(() -> BufferedWritableCharacterStream.this.writeAsync(c, off + l, len - l, result), result);
                return null;
            }
        }.start();
    }
}

