/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.EOFException;
import java.io.IOException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.util.UnprotectedStringBuffer;

public abstract class FullReadLines<T>
extends Task.Cpu<T, IOException> {
    private ICharacterStream.Readable.Buffered stream;
    private IO.OperationType closeStreamAtEnd;

    public FullReadLines(String description, ICharacterStream.Readable.Buffered stream, byte priority, IO.OperationType closeStreamAtEnd) {
        super(description, priority);
        this.stream = stream;
        this.closeStreamAtEnd = closeStreamAtEnd;
    }

    public String getSourceDescription() {
        return this.stream.getDescription();
    }

    @Override
    public final T run() throws IOException {
        try {
            while (true) {
                UnprotectedStringBuffer line = new UnprotectedStringBuffer();
                try {
                    while (true) {
                        char c;
                        if ((c = this.stream.read()) == '\r') {
                            continue;
                        }
                        if (c != '\n') {
                            line.append(c);
                            continue;
                        }
                        break;
                    }
                }
                catch (EOFException e) {
                    if (line.length() <= 0) break;
                    this.processLine(line);
                    break;
                }
                this.processLine(line);
            }
            T t = this.generateResult();
            return t;
        }
        finally {
            if (this.closeStreamAtEnd != null) {
                if (IO.OperationType.SYNCHRONOUS.equals((Object)this.closeStreamAtEnd)) {
                    try {
                        this.stream.close();
                    }
                    catch (Exception exception) {}
                } else {
                    this.stream.closeAsync();
                }
            }
        }
    }

    protected abstract void processLine(UnprotectedStringBuffer var1) throws IOException;

    protected abstract T generateResult() throws IOException;
}

