/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.mutable.MutableInteger;
import net.lecousin.framework.util.IConcurrentCloseable;

public interface ICharacterStream
extends IConcurrentCloseable {
    public byte getPriority();

    public void setPriority(byte var1);

    public String getDescription();

    public Charset getEncoding();

    public static interface Writable
    extends ICharacterStream,
    WriterAsync {
        public void writeSync(char[] var1, int var2, int var3) throws IOException;

        default public void writeSync(char[] c) throws IOException {
            this.writeSync(c, 0, c.length);
        }

        default public void writeSync(String s) throws IOException {
            this.writeSync(s.toCharArray());
        }

        public static interface Buffered
        extends Writable {
            public void writeSync(char var1) throws IOException;

            public ISynchronizationPoint<IOException> writeAsync(char var1);

            public ISynchronizationPoint<IOException> flush();
        }
    }

    public static interface WriterAsync {
        public ISynchronizationPoint<IOException> writeAsync(char[] var1, int var2, int var3);

        default public ISynchronizationPoint<IOException> writeAsync(char[] c) {
            return this.writeAsync(c, 0, c.length);
        }

        default public ISynchronizationPoint<IOException> writeAsync(String s) {
            return this.writeAsync(s.toCharArray());
        }
    }

    public static interface Readable
    extends ICharacterStream {
        public int readSync(char[] var1, int var2, int var3) throws IOException;

        public AsyncWork<Integer, IOException> readAsync(char[] var1, int var2, int var3);

        public boolean endReached();

        default public int readFullySync(char[] buf, int offset, int length) throws IOException {
            int done = 0;
            int nb;
            while ((nb = this.readSync(buf, offset, length)) > 0) {
                done += nb;
                if (length == nb) {
                    return done;
                }
                length -= nb;
                offset += nb;
            }
            return done;
        }

        default public AsyncWork<Integer, IOException> readFullyAsync(final char[] buf, final int offset, final int length) {
            final MutableInteger done = new MutableInteger(0);
            final AsyncWork<Integer, IOException> result = new AsyncWork<Integer, IOException>();
            Runnable next = new Runnable(){

                @Override
                public void run() {
                    1 that = this;
                    AsyncWork<Integer, IOException> read = this.readAsync(buf, offset + done.get(), length - done.get());
                    read.listenInline(() -> {
                        int nb = (Integer)read.getResult();
                        if (nb <= 0) {
                            result.unblockSuccess(done.get());
                            return;
                        }
                        if (done.add(nb) == length) {
                            result.unblockSuccess(done.get());
                            return;
                        }
                        that.run();
                    }, (ISynchronizationPoint<IOException>)result);
                }
            };
            next.run();
            return result;
        }

        public static interface Buffered
        extends Readable {
            public char read() throws EOFException, IOException;

            public int readAsync() throws IOException;

            public void back(char var1);

            public ISynchronizationPoint<IOException> canStartReading();
        }
    }
}

