/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.util.Buffers;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class LimitWriteOperationsReuseBuffers {
    private IO.Writable io;
    private Buffers buffers;
    private TurnArray<Pair<ByteBuffer, AsyncWork<Integer, IOException>>> waiting;
    private SynchronizationPoint<NoException> lock = null;

    public LimitWriteOperationsReuseBuffers(IO.Writable io, int bufferSize, int maxOperations) {
        this.io = io;
        this.buffers = new Buffers(bufferSize, maxOperations);
        this.waiting = new TurnArray(maxOperations);
    }

    public ByteBuffer getBuffer() {
        return this.buffers.getBuffer();
    }

    public void freeBuffer(ByteBuffer buffer) {
        this.buffers.freeBuffer(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncWork<Integer, IOException> write(final ByteBuffer buffer) throws IOException {
        while (true) {
            TurnArray<Pair<ByteBuffer, AsyncWork<Integer, IOException>>> turnArray = this.waiting;
            synchronized (turnArray) {
                if (this.waiting.isEmpty()) {
                    return this.io.writeAsync(buffer, new RunnableWithParameter<Pair<Integer, IOException>>(){

                        @Override
                        public void run(Pair<Integer, IOException> param) {
                            LimitWriteOperationsReuseBuffers.this.writeDone(buffer);
                        }
                    });
                }
                if (!this.waiting.isFull()) {
                    AsyncWork<Integer, IOException> res = new AsyncWork<Integer, IOException>();
                    this.waiting.addLast(new Pair(buffer, res));
                    return res;
                }
                if (this.lock != null) {
                    throw new IOException("Concurrent write");
                }
                this.lock = new SynchronizationPoint();
            }
            this.lock.block(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDone(ByteBuffer buffer) {
        this.buffers.freeBuffer(buffer);
        SynchronizationPoint<NoException> sp = null;
        TurnArray<Pair<ByteBuffer, AsyncWork<Integer, IOException>>> turnArray = this.waiting;
        synchronized (turnArray) {
            final Pair<ByteBuffer, AsyncWork<Integer, IOException>> b = this.waiting.pollFirst();
            if (b != null) {
                this.io.writeAsync(b.getValue1(), new RunnableWithParameter<Pair<Integer, IOException>>(){

                    @Override
                    public void run(Pair<Integer, IOException> param) {
                        LimitWriteOperationsReuseBuffers.this.writeDone((ByteBuffer)b.getValue1());
                    }
                }).listenInline(b.getValue2());
                if (this.lock != null) {
                    sp = this.lock;
                    this.lock = null;
                }
            }
        }
        if (sp != null) {
            sp.unblock();
        }
    }

    public AsyncWork<Integer, IOException> getLastPendingOperation() {
        Pair<ByteBuffer, AsyncWork<Integer, IOException>> b = this.waiting.pollLast();
        if (b == null) {
            return null;
        }
        return b.getValue2();
    }
}

