/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class NonBufferedReadableIOAsBuffered
extends ConcurrentCloseable
implements IO.Readable.Buffered {
    private IO.Readable io;
    private byte[] b1 = new byte[1];
    private ByteBuffer bb1 = ByteBuffer.wrap(this.b1);

    public NonBufferedReadableIOAsBuffered(IO.Readable io) {
        this.io = io;
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.io = null;
        ondone.unblock();
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public byte getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.io.setPriority(priority);
    }

    @Override
    public TaskManager getTaskManager() {
        return this.io.getTaskManager();
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        return this.io.readSync(buffer);
    }

    @Override
    public int readAsync() throws IOException {
        return this.read();
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.io.readAsync(buffer, ondone);
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return this.io.readFullySync(buffer);
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.io.readFullyAsync(buffer, ondone);
    }

    @Override
    public long skipSync(long n) throws IOException {
        return this.io.skipSync(n);
    }

    @Override
    public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        return this.io.skipAsync(n, ondone);
    }

    @Override
    public int read() throws IOException {
        int nb = this.io.readSync(this.bb1);
        if (nb <= 0) {
            return -1;
        }
        return this.b1[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        return this.io.readSync(ByteBuffer.wrap(buffer, offset, len));
    }

    @Override
    public ISynchronizationPoint<IOException> canStartReading() {
        return new SynchronizationPoint<boolean>(true);
    }

    @Override
    public int readFully(byte[] buffer) throws IOException {
        return this.io.readFullySync(ByteBuffer.wrap(buffer));
    }

    @Override
    public int skip(int skip) throws IOException {
        return (int)this.io.skipSync(skip);
    }

    @Override
    public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(final RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
        final AsyncWork<ByteBuffer, IOException> result = new AsyncWork<ByteBuffer, IOException>();
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Read next buffer", this.getPriority()){

            @Override
            public Void run() {
                final ByteBuffer buf = ByteBuffer.allocate(4096);
                final AsyncWork<Integer, IOException> read = NonBufferedReadableIOAsBuffered.this.readAsync(buf);
                read.listenInline(new Runnable(){

                    @Override
                    public void run() {
                        if (read.hasError()) {
                            if (ondone != null) {
                                ondone.run(new Pair(null, read.getError()));
                            }
                            result.unblockError(read.getError());
                            return;
                        }
                        int nb = (Integer)read.getResult();
                        if (nb <= 0) {
                            if (ondone != null) {
                                ondone.run(new Pair<Object, Object>(null, null));
                            }
                            result.unblockSuccess(null);
                            return;
                        }
                        buf.flip();
                        result.unblockSuccess(buf);
                    }
                });
                return null;
            }
        };
        ((Task.Cpu)this.operation(task)).start();
        return result;
    }
}

