/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.locale;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.collections.ArrayUtil;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOFromInputStream;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.buffering.SimpleBufferedReadable;
import net.lecousin.framework.io.provider.IOProviderFromName;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.io.text.PropertiesReader;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.memory.IMemoryManageable;
import net.lecousin.framework.memory.MemoryManager;
import net.lecousin.framework.util.ClassUtil;
import net.lecousin.framework.util.ObjectUtil;
import net.lecousin.framework.util.UnprotectedString;
import net.lecousin.framework.util.UnprotectedStringBuffer;
import net.lecousin.framework.xml.XMLException;

public class LocalizedProperties
implements IMemoryManageable {
    private Logger logger;
    private Map<String, Namespace> namespaces = new HashMap<String, Namespace>();

    public LocalizedProperties(Application application) {
        this.logger = application.getLoggerFactory().getLogger(LocalizedProperties.class);
        MemoryManager.register(this);
        this.registerNamespaceFrom(LocalizedProperties.class, "b", "b");
        this.registerNamespaceFrom(LocalizedProperties.class, "languages", "languages");
        this.registerNamespaceFrom(XMLException.class, "lc.xml.error", "error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISynchronizationPoint<Exception> registerNamespace(String namespace, String path, ClassLoader classLoader) {
        AutoCloseable in;
        IO.Readable input;
        Namespace ns;
        SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        Map<String, Namespace> map = this.namespaces;
        synchronized (map) {
            ns = this.namespaces.get(namespace);
            if (ns == null) {
                ns = new Namespace();
                ns.loading = sp;
                this.namespaces.put(namespace, ns);
            } else {
                ns.loading.cancel(new CancelException("Namespace overriden"));
                ns.loading = sp;
                Namespace.access$202(ns, null);
            }
        }
        ns.classLoader = classLoader;
        ns.path = path;
        if (classLoader instanceof IOProviderFromName.Readable) {
            try {
                input = ((IOProviderFromName.Readable)((Object)classLoader)).provideReadableIO(path + ".languages", (byte)3);
            }
            catch (IOException e) {
                sp.error(new Exception("Localized properties for namespace " + namespace + " cannot be loaded because the file " + path + ".languages does not exist", e));
                this.logger.error(((Throwable)sp.getError()).getMessage());
                return sp;
            }
        } else {
            in = classLoader.getResourceAsStream(path + ".languages");
            if (in == null) {
                sp.error(new Exception("Localized properties for namespace " + namespace + " cannot be loaded because the file " + path + ".languages does not exist"));
                this.logger.error(sp.getError().getMessage());
                return sp;
            }
            input = new IOFromInputStream((InputStream)in, path + ".languages", Threading.getUnmanagedTaskManager(), 3);
        }
        if (!(input instanceof IO.Readable.Buffered)) {
            input = new SimpleBufferedReadable(input, 4096);
        }
        in = (IO.Readable.Buffered)input;
        Namespace toLoad = ns;
        new Task.Cpu<Void, NoException>("Read localized properties namespace file", 3, (IO.Readable.Buffered)in, sp, path, toLoad, namespace){
            final /* synthetic */ IO.Readable.Buffered val$in;
            final /* synthetic */ SynchronizationPoint val$sp;
            final /* synthetic */ String val$path;
            final /* synthetic */ Namespace val$toLoad;
            final /* synthetic */ String val$namespace;
            {
                this.val$in = buffered;
                this.val$sp = synchronizationPoint;
                this.val$path = string;
                this.val$toLoad = namespace;
                this.val$namespace = string2;
                super(description, priority);
            }

            @Override
            public Void run() {
                LinkedList<Namespace.Language> languages = new LinkedList<Namespace.Language>();
                UnprotectedString s = new UnprotectedString(20);
                while (true) {
                    int c;
                    try {
                        c = this.val$in.read();
                    }
                    catch (IOException e) {
                        this.val$sp.error(new Exception("Error reading localized properties namespace file " + this.val$path + ".languages", e));
                        this.val$in.closeAsync();
                        LocalizedProperties.this.logger.error(((Throwable)this.val$sp.getError()).getMessage());
                        return null;
                    }
                    if (c < 0) break;
                    if (c == 44) {
                        s.trim().toLowerCase();
                        if (s.length() == 0) continue;
                        Namespace.Language l = new Namespace.Language();
                        List<UnprotectedString> list = s.split('-');
                        Namespace.Language.access$702(l, new String[list.size()]);
                        int i = 0;
                        for (UnprotectedString us : list) {
                            ((Namespace.Language)l).tag[i++] = us.asString();
                        }
                        languages.add(l);
                        s.reset();
                        continue;
                    }
                    s.append((char)c);
                }
                s.trim();
                if (s.length() > 0) {
                    Namespace.Language l = new Namespace.Language();
                    s.toLowerCase();
                    List<UnprotectedString> list = s.split('-');
                    Namespace.Language.access$702(l, new String[list.size()]);
                    int i = 0;
                    for (UnprotectedString us : list) {
                        ((Namespace.Language)l).tag[i++] = us.asString();
                    }
                    languages.add(l);
                }
                languages.sort(new Comparator<Namespace.Language>(){

                    @Override
                    public int compare(Namespace.Language l1, Namespace.Language l2) {
                        int i = 0;
                        while (i != l1.tag.length) {
                            if (i == l2.tag.length) {
                                return -1;
                            }
                            int c = l1.tag[i].compareTo(l2.tag[i]);
                            if (c != 0) {
                                return c;
                            }
                            ++i;
                        }
                        return 1;
                    }
                });
                Namespace.access$202(this.val$toLoad, languages.toArray(new Namespace.Language[languages.size()]));
                block5: for (int i = 0; i < this.val$toLoad.languages.length; ++i) {
                    int nbI = this.val$toLoad.languages[i].tag.length;
                    for (int j = i + 1; j < this.val$toLoad.languages.length; ++j) {
                        int nbJ = this.val$toLoad.languages[j].tag.length;
                        if (nbJ >= nbI) continue;
                        if (!ArrayUtil.equals(this.val$toLoad.languages[i].tag, 0, this.val$toLoad.languages[j].tag, 0, nbJ)) continue block5;
                        this.val$toLoad.languages[i].parent = this.val$toLoad.languages[j];
                        continue block5;
                    }
                }
                this.val$sp.unblock();
                this.val$in.closeAsync();
                LocalizedProperties.this.logger.info("Namespace " + this.val$namespace + " loaded with " + languages.size() + " languages from " + this.val$path);
                return null;
            }
        }.startOn(input.canStartReading(), true);
        return sp;
    }

    public ISynchronizationPoint<Exception> registerNamespaceFrom(Class<?> cl, String namespace, String subPath) {
        return this.registerNamespace(namespace, ClassUtil.getPackageName(cl).replace('.', '/') + '/' + subPath, cl.getClassLoader());
    }

    private void load(Namespace ns, final Namespace.Language lang) {
        AutoCloseable in;
        IO.Readable input;
        String path = ns.path + '.' + String.join((CharSequence)"-", lang.tag);
        if (ns.classLoader instanceof IOProviderFromName.Readable) {
            try {
                input = ((IOProviderFromName.Readable)((Object)ns.classLoader)).provideReadableIO(path, (byte)3);
            }
            catch (IOException e) {
                lang.loading.error(new Exception("Localized properties file " + path + " does not exist", e));
                this.logger.error(((Throwable)lang.loading.getError()).getMessage());
                return;
            }
        } else {
            in = ns.classLoader.getResourceAsStream(path);
            if (in == null) {
                lang.loading.error(new Exception("Localized properties file " + path + " does not exist"));
                this.logger.error(((Throwable)lang.loading.getError()).getMessage());
                return;
            }
            input = new IOFromInputStream((InputStream)in, path + ".languages", Threading.getUnmanagedTaskManager(), 3);
        }
        if (!(input instanceof IO.Readable.Buffered)) {
            input = new PreBufferedReadable(input, 4096, 3, 4096, 3, 16);
        }
        in = (IO.Readable.Buffered)input;
        BufferedReadableCharacterStream cs = new BufferedReadableCharacterStream((IO.Readable)in, StandardCharsets.UTF_8, 3000, 16);
        lang.properties = new HashMap();
        PropertiesReader<Map<String, String>> reader = new PropertiesReader<Map<String, String>>("Localized properties " + path, (ICharacterStream.Readable.Buffered)cs, 3, IO.OperationType.ASYNCHRONOUS){

            @Override
            protected void processProperty(UnprotectedStringBuffer key, UnprotectedStringBuffer value) {
                lang.properties.put(key.asString(), value.asString());
            }

            @Override
            protected Map<String, String> generateResult() {
                return lang.properties;
            }
        };
        reader.startOn(cs.canStartReading(), false);
        reader.getOutput().listenInlineSP(lang.loading);
    }

    public String localizeSync(String[] languageTag, String namespace, String key, Object ... values) {
        try {
            return this.localize(languageTag, namespace, key, values).blockResult(0L);
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncWork<String, NoException> localize(final String[] languageTag, final String namespace, final String key, final Object ... values) {
        Namespace ns;
        final AsyncWork<String, NoException> result = new AsyncWork<String, NoException>();
        Map<String, Namespace> map = this.namespaces;
        synchronized (map) {
            ns = this.namespaces.get(namespace);
        }
        if (ns == null) {
            result.unblockSuccess("!! unknown namespace " + namespace + " !!");
            return result;
        }
        ns.loading.listenInline(new Runnable(){

            @Override
            public void run() {
                if (ns.loading.hasError()) {
                    result.unblockSuccess("!! error loading namespace " + namespace + " !!");
                    return;
                }
                if (!ns.loading.isUnblocked()) {
                    ns.loading.listenInline(this);
                    return;
                }
                for (Namespace.Language l : ns.languages) {
                    if (!LocalizedProperties.languageTagCompatible(l.tag, languageTag)) continue;
                    LocalizedProperties.this.localize(ns, l, key, values, result);
                    return;
                }
                result.unblockSuccess("!! no compatible language in namespace " + namespace + "!!");
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localize(final Namespace ns, final Namespace.Language lang, final String key, final Object[] values, final AsyncWork<String, NoException> result) {
        boolean needsLoading = false;
        Namespace.Language language = lang;
        synchronized (language) {
            if (lang.loading == null) {
                lang.loading = new SynchronizationPoint();
                needsLoading = true;
            }
        }
        lang.loading.listenInline(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Namespace.Language language = lang;
                synchronized (language) {
                    String content = null;
                    if (!lang.loading.hasError()) {
                        content = (String)lang.properties.get(key.toLowerCase());
                    }
                    if (content != null) {
                        LocalizedProperties.localize(key, content, values, result);
                        lang.lastUsage = System.currentTimeMillis();
                        return;
                    }
                }
                if (lang.parent != null) {
                    LocalizedProperties.this.localize(ns, lang.parent, key, values, result);
                } else {
                    result.unblockSuccess("!! missing key " + key + " !!");
                }
            }
        });
        if (needsLoading) {
            this.load(ns, lang);
        }
    }

    private static void localize(String key, String content, Object[] values, AsyncWork<String, NoException> result) {
        result.unblockSuccess(LocalizedProperties.setCase(LocalizedProperties.replaceValues(content, values), key));
    }

    private static String replaceValues(String s, Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            s = s.replace("{" + i + "}", ObjectUtil.toString(values[i]));
        }
        return s;
    }

    private static String setCase(String text, String key) {
        if (Character.isUpperCase(key.charAt(0))) {
            text = Character.toUpperCase(text.charAt(0)) + text.substring(1);
        }
        return text;
    }

    private static boolean languageTagCompatible(String[] tag, String[] requested) {
        if (tag.length > requested.length) {
            return false;
        }
        return ArrayUtil.equals(tag, 0, requested, 0, tag.length);
    }

    @Override
    public String getDescription() {
        return "Localized properties";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getItemsDescription() {
        ArrayList<String> items = new ArrayList<String>(this.namespaces.size());
        Map<String, Namespace> map = this.namespaces;
        synchronized (map) {
            for (String ns : this.namespaces.keySet()) {
                items.add("Localized properties for namespace " + ns);
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeMemory(IMemoryManageable.FreeMemoryLevel level) {
        long maxIdle;
        switch (level) {
            default: {
                maxIdle = 600000L;
                break;
            }
            case LOW: {
                maxIdle = 120000L;
                break;
            }
            case MEDIUM: {
                maxIdle = 45000L;
                break;
            }
            case URGENT: {
                maxIdle = 5000L;
            }
        }
        Map<String, Namespace> map = this.namespaces;
        synchronized (map) {
            for (Namespace ns : this.namespaces.values()) {
                Namespace.Language[] languageArray = ns.languages;
                int n = languageArray.length;
                for (int i = 0; i < n; ++i) {
                    Namespace.Language lang;
                    Namespace.Language language = lang = languageArray[i];
                    synchronized (language) {
                        if (lang.loading == null) {
                            continue;
                        }
                        if (!lang.loading.isUnblocked()) {
                            continue;
                        }
                        if (lang.properties != null && System.currentTimeMillis() - lang.lastUsage > maxIdle) {
                            lang.loading = null;
                            lang.properties = null;
                            lang.lastUsage = 0L;
                        }
                        continue;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAvailableLanguageCodes() {
        LinkedList<String> avail = new LinkedList<String>();
        boolean first = true;
        Map<String, Namespace> map = this.namespaces;
        synchronized (map) {
            for (Namespace ns : this.namespaces.values()) {
                LinkedList<String> found = new LinkedList<String>();
                for (Namespace.Language l : ns.languages) {
                    String tag = String.join((CharSequence)"-", l.tag);
                    if (first) {
                        avail.add(tag);
                        continue;
                    }
                    found.add(tag);
                }
                if (first) {
                    first = false;
                    continue;
                }
                Iterator it = avail.iterator();
                while (it.hasNext()) {
                    if (found.contains(it.next())) continue;
                    it.remove();
                }
            }
        }
        return avail;
    }

    private static class Namespace {
        private ClassLoader classLoader;
        private String path;
        private ISynchronizationPoint<Exception> loading;
        private Language[] languages;

        private Namespace() {
        }

        static /* synthetic */ Language[] access$202(Namespace x0, Language[] x1) {
            x0.languages = x1;
            return x1;
        }

        private static class Language {
            private String[] tag;
            private Language parent = null;
            private Map<String, String> properties = null;
            private SynchronizationPoint<Exception> loading = null;
            private long lastUsage = 0L;

            private Language() {
            }

            static /* synthetic */ String[] access$702(Language x0, String[] x1) {
                x0.tag = x1;
                return x1;
            }
        }
    }
}

