/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.locale.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import net.lecousin.framework.locale.FixedLocalizedString;
import net.lecousin.framework.locale.ILocalizableString;
import net.lecousin.framework.locale.LocalizableString;
import net.lecousin.framework.locale.annotations.LocalizableNamespace;
import net.lecousin.framework.locale.annotations.LocalizableProperty;
import net.lecousin.framework.properties.Property;

public final class LocalizableAnnotations {
    private LocalizableAnnotations() {
    }

    public static ILocalizableString get(AnnotatedElement element, String name) {
        for (LocalizableProperty localizableProperty : (LocalizableProperty[])element.getAnnotationsByType(LocalizableProperty.class)) {
            if (!localizableProperty.name().equals(name)) continue;
            String ns = localizableProperty.namespace();
            if (ns.length() == 0) {
                LocalizableNamespace lns = element.getAnnotation(LocalizableNamespace.class);
                if (lns == null && element instanceof Member) {
                    lns = ((Member)((Object)element)).getDeclaringClass().getAnnotation(LocalizableNamespace.class);
                }
                if (lns != null) {
                    ns = lns.value();
                }
            }
            String[] values = localizableProperty.values();
            Object[] v = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                v[i] = values[i];
            }
            return new LocalizableString(ns, localizableProperty.key(), v);
        }
        for (Annotation annotation : (Property[])element.getAnnotationsByType(Property.class)) {
            if (!annotation.name().equals(name)) continue;
            return new FixedLocalizedString(annotation.value());
        }
        return null;
    }
}

