/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.util.DebugUtil;

public class LogPattern {
    private Section[] parts;
    private boolean needsThreadName = false;
    private boolean needsLocation = false;

    public LogPattern(String pattern) {
        LinkedList<Section> sections = new LinkedList<Section>();
        int pos = 0;
        int len = pattern.length();
        while (pos < len) {
            int i = pattern.indexOf(37, pos);
            if (i > pos) {
                sections.add(new StringSection(pattern.substring(pos, i)));
                pos = i;
            } else if (i < 0) {
                sections.add(new StringSection(pattern.substring(pos)));
                break;
            }
            if (pos == len - 1) {
                sections.add(new StringSection("%"));
                break;
            }
            char c = pattern.charAt(pos + 1);
            if (c == 'd') {
                if (pos + 3 >= len || pattern.charAt(pos + 2) != '{') {
                    sections.add(new StringSection(pattern.substring(pos, pos + 2)));
                    pos += 2;
                    continue;
                }
                i = pattern.indexOf(125, pos + 3);
                if (i < 0) {
                    sections.add(new StringSection(pattern.substring(pos, pos + 2)));
                    pos += 2;
                    continue;
                }
                String format = pattern.substring(pos + 3, i);
                sections.add(new DateSection(format));
                pos = i + 1;
                continue;
            }
            if (c == 't') {
                sections.add(new ThreadNameSection());
                this.needsThreadName = true;
                pos += 2;
                continue;
            }
            if (c == '%') {
                sections.add(new StringSection("%"));
                pos += 2;
                continue;
            }
            if (c == 'l') {
                if (pos + 5 >= len) {
                    sections.add(new StringSection(pattern.substring(pos, pos + 2)));
                    pos += 2;
                    continue;
                }
                c = pattern.charAt(pos + 2);
                if (c == 'e') {
                    if (pattern.charAt(pos + 3) == 'v' && pattern.charAt(pos + 4) == 'e' && pattern.charAt(pos + 5) == 'l') {
                        sections.add(new LevelSection());
                        pos += 6;
                        continue;
                    }
                    sections.add(new StringSection(pattern.substring(pos, pos + 2)));
                    pos += 2;
                    continue;
                }
                if (c == 'o') {
                    if (pos < len - 7 && pattern.charAt(pos + 3) == 'g' && pattern.charAt(pos + 4) == 'g' && pattern.charAt(pos + 5) == 'e' && pattern.charAt(pos + 6) == 'r') {
                        if (pos < len - 8 && pattern.charAt(pos + 7) == '{') {
                            i = pattern.indexOf(125, pos + 8);
                            if (i < 0) {
                                sections.add(new LoggerSection(-1));
                                pos += 7;
                                continue;
                            }
                            int size = -1;
                            try {
                                size = Integer.parseInt(pattern.substring(pos + 8, i));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            sections.add(new LoggerSection(size));
                            pos = i + 1;
                            continue;
                        }
                        sections.add(new LoggerSection(-1));
                        pos += 7;
                        continue;
                    }
                    sections.add(new StringSection(pattern.substring(pos, pos + 2)));
                    pos += 2;
                    continue;
                }
                sections.add(new StringSection(pattern.substring(pos, pos + 2)));
                pos += 2;
                continue;
            }
            if (c == 'm') {
                sections.add(new MessageSection());
                pos += 2;
                continue;
            }
            if (c == 'C') {
                sections.add(new ClassNameSection());
                this.needsLocation = true;
                pos += 2;
                continue;
            }
            if (c == 'M') {
                sections.add(new MethodNameSection());
                this.needsLocation = true;
                pos += 2;
                continue;
            }
            if (c == 'L') {
                sections.add(new LineSection());
                this.needsLocation = true;
                pos += 2;
                continue;
            }
            if (c == 'f') {
                sections.add(new FileNameSection());
                this.needsLocation = true;
                pos += 2;
                continue;
            }
            sections.add(new StringSection(pattern.substring(pos, pos + 2)));
            pos += 2;
        }
        this.parts = sections.toArray(new Section[sections.size()]);
    }

    public boolean needsThreadName() {
        return this.needsThreadName;
    }

    public boolean needsLocation() {
        return this.needsLocation;
    }

    public StringBuilder generate(Log log) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].append(s, log);
        }
        if (log.trace != null) {
            LogPattern.appendStack(s, log.trace);
        }
        return s;
    }

    private static void appendStack(StringBuilder s, Throwable t) {
        s.append('\n');
        DebugUtil.createStackTrace(s, t, true);
    }

    private static class LoggerSection
    implements Section {
        private int fixedSize;

        private LoggerSection(int fixedSize) {
            if (fixedSize > 0 && fixedSize < 3) {
                fixedSize = 3;
            }
            this.fixedSize = fixedSize;
        }

        @Override
        public void append(StringBuilder s, Log log) {
            int len = log.loggerName.length();
            if (len == this.fixedSize || this.fixedSize <= 0) {
                s.append(log.loggerName);
            } else if (len < this.fixedSize) {
                s.append(log.loggerName);
                for (int i = len; i < this.fixedSize; ++i) {
                    s.append(' ');
                }
            } else {
                s.append("..").append(log.loggerName.substring(len - this.fixedSize + 2));
            }
        }
    }

    private static class LevelSection
    implements Section {
        private LevelSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            String name = log.level.name();
            s.append(name);
            for (int i = name.length(); i < 5; ++i) {
                s.append(' ');
            }
        }
    }

    private static class FileNameSection
    implements Section {
        private FileNameSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(log.location.getFileName());
        }
    }

    private static class LineSection
    implements Section {
        private LineSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(log.location.getLineNumber());
        }
    }

    private static class MethodNameSection
    implements Section {
        private MethodNameSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(log.location.getMethodName());
        }
    }

    private static class ClassNameSection
    implements Section {
        private ClassNameSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(log.location.getClassName());
        }
    }

    private static class DateSection
    implements Section {
        private SimpleDateFormat format;

        public DateSection(String format) {
            this.format = new SimpleDateFormat(format);
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(this.format.format(new Date(log.timestamp)));
        }
    }

    private static class ThreadNameSection
    implements Section {
        private ThreadNameSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(log.threadName);
        }
    }

    private static class MessageSection
    implements Section {
        private MessageSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(log.message);
        }
    }

    private static class StringSection
    implements Section {
        private String str;

        public StringSection(String str) {
            this.str = str;
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(this.str);
        }
    }

    private static interface Section {
        public void append(StringBuilder var1, Log var2);
    }

    public static class Log {
        public Logger.Level level;
        public String message;
        public Throwable trace;
        public String loggerName;
        public long timestamp;
        public String threadName;
        public StackTraceElement location;
    }
}

