/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log;

import net.lecousin.framework.log.LogPattern;
import net.lecousin.framework.log.LoggerFactory;
import net.lecousin.framework.log.appenders.Appender;

public class Logger {
    private LoggerFactory factory;
    private String name;
    Appender appender;
    private int level;

    Logger(LoggerFactory factory, String name, Appender appender, Level level) {
        this.factory = factory;
        this.name = name;
        this.appender = appender;
        this.level = level != null ? level.ordinal() : -1;
    }

    public void setLevel(Level level) {
        this.level = level != null ? level.ordinal() : -1;
    }

    private void logMessage(Level level, String message, Throwable t) {
        StackTraceElement[] stack;
        LogPattern.Log log = new LogPattern.Log();
        log.timestamp = System.currentTimeMillis();
        log.loggerName = this.name;
        log.level = level;
        log.message = message;
        log.trace = t;
        if (this.appender.needsThreadName()) {
            log.threadName = Thread.currentThread().getName();
        }
        if (this.appender.needsLocation() && (stack = new Exception().getStackTrace()) != null && stack.length > 1) {
            log.location = stack[1];
        }
        this.factory.thread.log(this.appender, log);
    }

    private int getLevel() {
        if (this.level == -1) {
            return this.appender.level();
        }
        return this.level;
    }

    public void log(Level level, String message) {
        if (level.ordinal() < this.getLevel()) {
            return;
        }
        this.logMessage(level, message, null);
    }

    public void log(Level level, String message, Throwable t) {
        if (level.ordinal() < this.getLevel()) {
            return;
        }
        this.logMessage(level, message, t);
    }

    public boolean trace() {
        return this.getLevel() <= Level.TRACE.ordinal();
    }

    public void trace(String message) {
        if (this.getLevel() > Level.TRACE.ordinal()) {
            return;
        }
        this.logMessage(Level.TRACE, message, null);
    }

    public void trace(String message, Throwable t) {
        if (this.getLevel() > Level.TRACE.ordinal()) {
            return;
        }
        this.logMessage(Level.TRACE, message, t);
    }

    public boolean debug() {
        return this.getLevel() <= Level.DEBUG.ordinal();
    }

    public void debug(String message) {
        if (this.getLevel() > Level.DEBUG.ordinal()) {
            return;
        }
        this.logMessage(Level.DEBUG, message, null);
    }

    public void debug(String message, Throwable t) {
        if (this.getLevel() > Level.DEBUG.ordinal()) {
            return;
        }
        this.logMessage(Level.DEBUG, message, t);
    }

    public boolean info() {
        return this.getLevel() <= Level.INFO.ordinal();
    }

    public void info(String message) {
        if (this.getLevel() > Level.INFO.ordinal()) {
            return;
        }
        this.logMessage(Level.INFO, message, null);
    }

    public void info(String message, Throwable t) {
        if (this.getLevel() > Level.INFO.ordinal()) {
            return;
        }
        this.logMessage(Level.INFO, message, t);
    }

    public boolean warn() {
        return this.getLevel() <= Level.WARN.ordinal();
    }

    public void warn(String message) {
        if (this.getLevel() > Level.WARN.ordinal()) {
            return;
        }
        this.logMessage(Level.WARN, message, null);
    }

    public void warn(String message, Throwable t) {
        if (this.getLevel() > Level.WARN.ordinal()) {
            return;
        }
        this.logMessage(Level.WARN, message, t);
    }

    public boolean error() {
        return this.getLevel() <= Level.ERROR.ordinal();
    }

    public void error(String message) {
        if (this.getLevel() > Level.ERROR.ordinal()) {
            return;
        }
        this.logMessage(Level.ERROR, message, null);
    }

    public void error(String message, Throwable t) {
        if (this.getLevel() > Level.ERROR.ordinal()) {
            return;
        }
        this.logMessage(Level.ERROR, message, t);
    }

    public boolean fatal() {
        return this.getLevel() <= Level.FATAL.ordinal();
    }

    public void fatal(String message) {
        if (this.getLevel() > Level.FATAL.ordinal()) {
            return;
        }
        this.logMessage(Level.FATAL, message, null);
    }

    public void fatal(String message, Throwable t) {
        if (this.getLevel() > Level.FATAL.ordinal()) {
            return;
        }
        this.logMessage(Level.FATAL, message, t);
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL,
        OFF;

    }
}

