/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.log.LogPattern;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.log.LoggerThread;
import net.lecousin.framework.log.appenders.Appender;
import net.lecousin.framework.log.appenders.ConsoleAppender;

public class LoggerFactory {
    Application application;
    LoggerThread thread;
    private Appender defaultAppender;
    private Map<String, Logger> loggers = new HashMap<String, Logger>(50);
    private Logger defaultLogger;

    public LoggerFactory(Application app) {
        this.application = app;
        this.thread = new LoggerThread(app);
        this.defaultAppender = new ConsoleAppender(this, app.isReleaseMode() ? Logger.Level.INFO : Logger.Level.DEBUG, new LogPattern("%d{HH:mm:ss.SSS} [%level] <%logger{20}> %m"));
        this.defaultLogger = new Logger(this, "default", this.defaultAppender, null);
        this.loggers.put("default", this.defaultLogger);
        String url = app.getProperty("net.lecousin.logging.configuration.url");
        if (url != null) {
            this.configure(url);
        }
    }

    public Application getApplication() {
        return this.application;
    }

    @SuppressFBWarnings(value={"UG_SYNC_SET_UNSYNC_GET"})
    public Logger getDefault() {
        return this.defaultLogger;
    }

    public Logger getLogger(Class<?> cl) {
        return this.getLogger(cl.getName());
    }

    public synchronized Logger getLogger(String name) {
        Logger l = this.loggers.get(name);
        if (l != null) {
            return l;
        }
        l = new Logger(this, name, this.defaultAppender, null);
        this.loggers.put(name, l);
        return l;
    }

    public synchronized void setDefault(Appender appender) {
        for (Logger l : this.loggers.values()) {
            if (l.appender != this.defaultAppender) continue;
            l.appender = appender;
        }
        this.defaultAppender = appender;
    }

    public synchronized void configure(String name, Appender appender, Logger.Level level) {
        Logger l = this.loggers.get(name);
        if (l != null) {
            l.appender = appender;
            l.setLevel(level);
            return;
        }
        l = new Logger(this, name, appender, level);
        this.loggers.put(name, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(String url) {
        this.application.getConsole().out("Configuring logging " + url);
        InputStream input = null;
        try {
            input = new URL(url).openStream();
            this.configure(input);
        }
        catch (Exception e) {
            this.application.getConsole().err("Error configuring logging system from " + url + ": " + e.getMessage());
            this.application.getConsole().err(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public synchronized void configure(InputStream input) throws Exception {
        this.configure(XMLInputFactory.newFactory().createXMLStreamReader(new PropertiesStream(this.application, input)));
    }

    public synchronized void configure(XMLStreamReader reader) throws Exception {
        while (reader.hasNext()) {
            reader.next();
            if (reader.getEventType() != 1) continue;
            if (!"LoggingConfiguration".equals(reader.getLocalName())) {
                throw new Exception("Root element must be LoggingConfiguration");
            }
            this.readLoggingConfiguration(reader);
            return;
        }
        throw new Exception("No root element found in logging configuration file");
    }

    private void readLoggingConfiguration(XMLStreamReader reader) throws Exception {
        HashMap<String, Appender> appenders = new HashMap<String, Appender>();
        reader.next();
        while (reader.hasNext()) {
            if (reader.getEventType() == 1) {
                if ("Appender".equals(reader.getLocalName())) {
                    try {
                        this.readAppender(reader, appenders);
                    }
                    catch (Exception e) {
                        throw new Exception("Invalid appender definition in logging configuration file", e);
                    }
                } else if ("Logger".equals(reader.getLocalName())) {
                    try {
                        this.readLogger(reader, appenders);
                    }
                    catch (Exception e) {
                        throw new Exception("Invalid logger definition in logging configuration file", e);
                    }
                } else if ("Default".equals(reader.getLocalName())) {
                    try {
                        this.readDefault(reader, appenders);
                    }
                    catch (Exception e) {
                        throw new Exception("Invalid logger definition in logging configuration file", e);
                    }
                } else {
                    throw new Exception("Unknown element " + reader.getLocalName() + " in logging configuration file");
                }
            }
            reader.next();
        }
    }

    private void readAppender(XMLStreamReader reader, Map<String, Appender> appenders) throws Exception {
        Appender appender;
        Constructor<?> ctor;
        String name = null;
        Class<?> cl = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrValue = reader.getAttributeValue(i);
            if ("name".equals(attrName)) {
                name = attrValue;
                continue;
            }
            if (!"class".equals(attrName)) continue;
            try {
                cl = Class.forName(attrValue);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Unknown class " + attrValue);
            }
        }
        if (name == null) {
            throw new Exception("Missing attribute name on Appender");
        }
        if (cl == null) {
            throw new Exception("Missing attribute class on Appender");
        }
        if (!Appender.class.isAssignableFrom(cl)) {
            throw new Exception("Class " + cl.getName() + " is not an Appender");
        }
        try {
            ctor = cl.getConstructor(LoggerFactory.class, XMLStreamReader.class, Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new Exception("Class " + cl.getName() + " must have a constructor (LoggerFactory,XMLStreamReader,Map<String,Appender>)");
        }
        try {
            appender = (Appender)ctor.newInstance(this, reader, appenders);
        }
        catch (InvocationTargetException e) {
            Throwable ex = e.getTargetException();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof Exception) {
                throw (Exception)ex;
            }
            throw new Exception("Class constructor " + cl.getName() + " thrown an exception", ex);
        }
        appenders.put(name, appender);
    }

    private void readLogger(XMLStreamReader reader, Map<String, Appender> appenders) throws Exception {
        String name = null;
        String appenderName = null;
        Logger.Level level = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrValue = reader.getAttributeValue(i);
            if ("name".equals(attrName)) {
                name = attrValue;
                continue;
            }
            if ("appender".equals(attrName)) {
                appenderName = attrValue;
                continue;
            }
            if ("level".equals(attrName)) {
                try {
                    level = Logger.Level.valueOf(attrValue);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Invalid Logger level: " + attrValue);
                }
            }
            throw new Exception("Unknown attribute " + attrName);
        }
        if (name == null) {
            throw new Exception("Missing attribute name on Logger");
        }
        if (appenderName == null) {
            throw new Exception("Missing attribute appender on Logger");
        }
        Appender appender = appenders.get(appenderName);
        if (appender == null) {
            throw new Exception("Unknown appender name " + appenderName + " for logger " + name);
        }
        this.configure(name, appender, level);
        reader.next();
        while (reader.getEventType() != 2) {
            if (reader.getEventType() == 1) {
                throw new Exception("Unexpected inner element " + reader.getLocalName());
            }
            reader.next();
            if (reader.hasNext()) continue;
        }
    }

    private void readDefault(XMLStreamReader reader, Map<String, Appender> appenders) throws Exception {
        String appenderName = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrValue = reader.getAttributeValue(i);
            if (!"appender".equals(attrName)) {
                throw new Exception("Unknown attribute " + attrName);
            }
            appenderName = attrValue;
        }
        if (appenderName == null) {
            throw new Exception("Missing attribute appender on Default");
        }
        Appender appender = appenders.get(appenderName);
        if (appender == null) {
            throw new Exception("Unknown appender name " + appenderName + " for default logger");
        }
        this.setDefault(appender);
        reader.next();
        while (reader.getEventType() != 2) {
            if (reader.getEventType() == 1) {
                throw new Exception("Unexpected inner element " + reader.getLocalName());
            }
            reader.next();
            if (reader.hasNext()) continue;
        }
    }

    private static class PropertiesStream
    extends InputStream {
        private Application app;
        private InputStream input;
        private byte[] buffer = new byte[4096];
        private int pos;
        private int nb;
        private boolean eof = false;
        private LinkedList<Integer> back = new LinkedList();

        public PropertiesStream(Application app, InputStream input) throws IOException {
            this.app = app;
            this.input = input;
            this.pos = 0;
            this.nb = input.read(this.buffer);
            if (this.nb <= 0) {
                this.nb = 0;
                this.eof = true;
            }
        }

        private int next() throws IOException {
            if (!this.back.isEmpty()) {
                return this.back.removeFirst();
            }
            if (this.pos == this.nb) {
                if (this.eof) {
                    return -1;
                }
                this.pos = 0;
                this.nb = this.input.read(this.buffer);
                if (this.nb <= 0) {
                    this.eof = true;
                    this.nb = 0;
                    return -1;
                }
            }
            return this.buffer[this.pos++] & 0xFF;
        }

        @Override
        public int read() throws IOException {
            int c1 = this.next();
            if (c1 < 0) {
                return -1;
            }
            if (c1 != 36) {
                return c1;
            }
            int c2 = this.next();
            if (c2 < 0) {
                return c1;
            }
            if (c2 != 123) {
                this.back.add(c2);
                return c1;
            }
            StringBuilder s = new StringBuilder();
            while (true) {
                int c;
                if ((c = this.next()) < 0) {
                    throw new IOException("Property starts with ${ but ending } is missing");
                }
                if (c == 125) {
                    String prop = this.app.getProperty(s.toString());
                    if (prop == null) {
                        this.app.getConsole().err("Unknown property " + s.toString() + " used in Logging configuration file");
                        return this.read();
                    }
                    byte[] bytes = prop.getBytes(StandardCharsets.ISO_8859_1);
                    for (int i = 0; i < bytes.length; ++i) {
                        this.back.add(bytes[i] & 0xFF);
                    }
                    return this.read();
                }
                s.append((char)c);
            }
        }
    }
}

