/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log.appenders;

import java.io.IOException;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import net.lecousin.framework.log.LogPattern;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.log.LoggerFactory;
import net.lecousin.framework.log.appenders.Appender;

public class ConsoleAppender
implements Appender {
    private LoggerFactory factory;
    private Logger.Level level;
    private LogPattern pattern;

    public ConsoleAppender(LoggerFactory factory, Logger.Level level, LogPattern pattern) {
        this.factory = factory;
        this.level = level;
        this.pattern = pattern;
    }

    public ConsoleAppender(LoggerFactory factory, XMLStreamReader reader, Map<String, Appender> appenders) throws Exception, IOException {
        this.factory = factory;
        String level = null;
        String pattern = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrValue = reader.getAttributeValue(i);
            if ("level".equals(attrName)) {
                level = attrValue;
                continue;
            }
            if ("pattern".equals(attrName)) {
                pattern = attrValue;
                continue;
            }
            if ("name".equals(attrName) || "class".equals(attrName)) continue;
            throw new Exception("Unknown attribute " + attrName);
        }
        if (level == null) {
            throw new Exception("Missing attribute level on console Appender");
        }
        try {
            this.level = Logger.Level.valueOf(level);
        }
        catch (Throwable t) {
            throw new Exception("Invalid level " + level);
        }
        if (pattern == null) {
            throw new Exception("Missing attribute pattern on console Appender");
        }
        this.pattern = new LogPattern(pattern);
        reader.next();
        while (reader.getEventType() != 2) {
            if (reader.getEventType() == 1) {
                throw new Exception("Unexpected inner element " + reader.getLocalName());
            }
            reader.next();
            if (reader.hasNext()) continue;
        }
    }

    @Override
    public void append(LogPattern.Log log) {
        String s = this.pattern.generate(log).toString();
        if (log.level.ordinal() >= Logger.Level.ERROR.ordinal()) {
            this.factory.getApplication().getConsole().err(s);
        } else {
            this.factory.getApplication().getConsole().out(s);
        }
    }

    @Override
    public int level() {
        return this.level.ordinal();
    }

    @Override
    public boolean needsThreadName() {
        return this.pattern.needsThreadName();
    }

    @Override
    public boolean needsLocation() {
        return this.pattern.needsLocation();
    }
}

