/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log.appenders;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import net.lecousin.framework.log.LogPattern;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.log.LoggerFactory;
import net.lecousin.framework.log.appenders.Appender;

public class MultipleAppender
implements Appender {
    private Appender[] appenders;
    private int level;
    private boolean threadName = false;
    private boolean location = false;

    public MultipleAppender(LoggerFactory factory, Appender ... appenders) {
        this.appenders = appenders;
        this.level = Logger.Level.OFF.ordinal();
        for (Appender a : appenders) {
            if (a.level() < this.level) {
                this.level = a.level();
            }
            if (!this.threadName) {
                this.threadName = a.needsThreadName();
            }
            if (this.location) continue;
            this.location = a.needsLocation();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MultipleAppender(LoggerFactory factory, XMLStreamReader reader, Map<String, Appender> appenders) throws Exception {
        this.level = Logger.Level.OFF.ordinal();
        ArrayList<Appender> list = new ArrayList<Appender>();
        reader.next();
        while (reader.hasNext()) {
            if (reader.getEventType() == 1) {
                if (!"AppenderRef".equals(reader.getLocalName())) throw new Exception("Unknown element " + reader.getLocalName() + " in MultipleAppender, only AppenderRef elements are expected");
                String name = null;
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    String attrName = reader.getAttributeLocalName(i);
                    String attrValue = reader.getAttributeValue(i);
                    if (!"name".equals(attrName)) {
                        throw new Exception("Unknown attribute " + attrName + " in AppenderRef");
                    }
                    name = attrValue;
                }
                if (name == null) {
                    throw new Exception("Missing attribute name on AppenderRef");
                }
                Appender appender = appenders.get(name);
                if (appender == null) {
                    throw new Exception("Unknown appender " + name + " in AppenderRef");
                }
                list.add(appender);
                if (appender.level() < this.level) {
                    this.level = appender.level();
                }
                if (!this.threadName) {
                    this.threadName = appender.needsThreadName();
                }
                if (!this.location) {
                    this.location = appender.needsLocation();
                }
                reader.next();
                while (reader.getEventType() != 2) {
                    if (reader.getEventType() == 1) {
                        throw new Exception("Unexpected element " + reader.getLocalName() + " in AppenderRef");
                    }
                    reader.next();
                    if (reader.hasNext()) continue;
                    break;
                }
            } else if (reader.getEventType() == 2) break;
            reader.next();
        }
        this.appenders = list.toArray(new Appender[list.size()]);
    }

    @Override
    public void append(LogPattern.Log log) {
        for (Appender a : this.appenders) {
            if (a.level() > log.level.ordinal()) continue;
            a.append(log);
        }
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public boolean needsThreadName() {
        return this.threadName;
    }

    @Override
    public boolean needsLocation() {
        return this.location;
    }
}

