/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.math;

public class RangeInteger {
    public int min;
    public int max;

    public RangeInteger(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public RangeInteger(RangeInteger copy) {
        this.min = copy.min;
        this.max = copy.max;
    }

    public RangeInteger copy() {
        return new RangeInteger(this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RangeInteger)) {
            return false;
        }
        RangeInteger r = (RangeInteger)obj;
        return r.min == this.min && r.max == this.max;
    }

    public int hashCode() {
        return this.min + this.max;
    }

    public boolean contains(int value) {
        return value >= this.min && value <= this.max;
    }

    public RangeInteger intersect(RangeInteger r) {
        if (this.min > r.max) {
            return null;
        }
        if (this.max < r.min) {
            return null;
        }
        return new RangeInteger(Math.max(this.min, r.min), Math.min(this.max, r.max));
    }

    public int getLength() {
        return this.max - this.min + 1;
    }
}

