/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.memory;

import java.util.Collection;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.memory.IMemoryManageable;

public interface CacheManager
extends IMemoryManageable {
    public Collection<? extends CachedData> getCachedData();

    public boolean free(CachedData var1);

    default public long getDefaultCachedDataExpiration() {
        return 900000L;
    }

    default public long getCachedDataExpiration(CachedData data) {
        if (data instanceof CachedDataCustomExpiration) {
            return ((CachedDataCustomExpiration)data).cachedDataExpirationTime();
        }
        return this.getDefaultCachedDataExpiration();
    }

    @Override
    default public void freeMemory(IMemoryManageable.FreeMemoryLevel level) {
        long maxIdle;
        if (IMemoryManageable.FreeMemoryLevel.EXPIRED_ONLY.equals((Object)level)) {
            LinkedArrayList<CachedData> toFree = new LinkedArrayList<CachedData>(10);
            long now = System.currentTimeMillis();
            for (CachedData cachedData : this.getCachedData()) {
                long expiration;
                if (cachedData.cachedDataCurrentUsage() > 0 || now < (expiration = cachedData.cachedDataLastUsage() + this.getCachedDataExpiration(cachedData))) continue;
                toFree.add(cachedData);
            }
            for (CachedData cachedData : toFree) {
                this.free(cachedData);
            }
            return;
        }
        switch (level) {
            default: {
                maxIdle = 300000L;
                break;
            }
            case MEDIUM: {
                maxIdle = 60000L;
                break;
            }
            case URGENT: {
                maxIdle = 0L;
            }
        }
        LinkedArrayList<CachedData> toFree = new LinkedArrayList<CachedData>(15);
        long now = System.currentTimeMillis();
        for (CachedData cachedData : this.getCachedData()) {
            if (cachedData.cachedDataCurrentUsage() != 0 || cachedData.cachedDataLastUsage() - now > maxIdle) continue;
            toFree.add(cachedData);
        }
        for (CachedData cachedData : toFree) {
            this.free(cachedData);
        }
    }

    public static interface CachedDataCustomExpiration
    extends CachedData {
        public long cachedDataExpirationTime();
    }

    public static interface CachedData {
        public int cachedDataCurrentUsage();

        public long cachedDataLastUsage();
    }
}

