/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.progress;

import net.lecousin.framework.progress.WorkProgress;
import net.lecousin.framework.progress.WorkProgressImpl;

public class SubWorkProgress
extends WorkProgressImpl {
    private WorkProgress parent;
    private long parentProgress = 0L;
    private long parentWork;

    public SubWorkProgress(WorkProgress parent, long parentWork, long amount, String text, String subText) {
        super(amount, text, subText);
        this.parent = parent;
        this.parentWork = parentWork;
    }

    public SubWorkProgress(WorkProgress parent, long parentWork, long amount, String text) {
        this(parent, parentWork, amount, text, "");
    }

    public SubWorkProgress(WorkProgress parent, long parentWork, long amount) {
        this(parent, parentWork, amount, "", "");
    }

    private void updateParent() {
        long newProgress = this.getPosition() * this.parentWork / this.getAmount();
        if (newProgress != this.parentProgress) {
            this.parent.progress(newProgress - this.parentProgress);
            this.parentProgress = newProgress;
        }
    }

    @Override
    public void setAmount(long work) {
        super.setAmount(work);
        this.updateParent();
    }

    @Override
    public void progress(long amountDone) {
        super.progress(amountDone);
        this.updateParent();
    }

    @Override
    public void setPosition(long position) {
        super.setPosition(position);
        this.updateParent();
    }

    @Override
    public void done() {
        super.done();
        this.updateParent();
    }
}

