/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.progress;

import java.util.List;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.mutable.MutableLong;

public interface WorkProgress {
    public void setAmount(long var1);

    public long getAmount();

    public void setPosition(long var1);

    public long getPosition();

    public long getRemainingWork();

    public void progress(long var1);

    public void done();

    public void error(Exception var1);

    public void cancel(CancelException var1);

    public ISynchronizationPoint<Exception> getSynch();

    public void listen(Runnable var1);

    public void unlisten(Runnable var1);

    public String getText();

    public void setText(String var1);

    public String getSubText();

    public void setSubText(String var1);

    public static void linkTo(final WorkProgress progress, final ISynchronizationPoint<?> sp) {
        sp.listenInline(new Runnable(){

            @Override
            public void run() {
                if (sp.hasError()) {
                    progress.error((Exception)sp.getError());
                } else if (sp.isCancelled()) {
                    progress.cancel(sp.getCancelEvent());
                } else {
                    progress.done();
                }
            }
        });
    }

    public static void linkTo(WorkProgress progress, Task<?, ?> task) {
        WorkProgress.linkTo(progress, task.getOutput());
    }

    public static void link(final WorkProgress subTask, final WorkProgress progress, final long work) {
        final MutableLong sent = new MutableLong(0L);
        subTask.getSynch().listenInline(new Runnable(){

            @Override
            public void run() {
                progress.progress(work - sent.get());
            }
        });
        subTask.listen(new Runnable(){

            @Override
            public void run() {
                long done = subTask.getPosition() * work / subTask.getAmount();
                if (sent.get() < done) {
                    progress.progress(done - sent.get());
                    sent.set(done);
                }
            }
        });
    }

    public static interface MultiTask {
        public List<? extends WorkProgress> getTasks();
    }
}

