/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.io.File;
import java.io.IOException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.exception.NoException;

public class DirectoryWalker<T> {
    private File root;

    public DirectoryWalker(File root) {
        this.root = root;
    }

    public ISynchronizationPoint<IOException> start(byte priority) {
        JoinPoint<IOException> jp = new JoinPoint<IOException>();
        jp.addToJoin(1);
        new DirectoryReader(Threading.getDrivesTaskManager().getTaskManager(this.root), null, this.root, jp, priority).start();
        jp.start();
        return jp;
    }

    protected boolean startDirectory(File dir, T dirObj) {
        return true;
    }

    protected void endDirectory(File dir, T dirObj) {
    }

    protected void accessDenied(File dir) {
    }

    protected T directoryFound(T parent, File dir) {
        return null;
    }

    protected void fileFound(T parent, File file) {
    }

    private class DirectoryReader
    extends Task.OnFile<Void, NoException> {
        private T object;
        private File dir;
        private JoinPoint<IOException> jp;

        public DirectoryReader(TaskManager manager, T object, File dir, JoinPoint<IOException> jp, byte priority) {
            super(manager, "Read directory content", priority);
            this.object = object;
            this.dir = dir;
            this.jp = jp;
        }

        @Override
        public Void run() {
            if (!DirectoryWalker.this.startDirectory(this.dir, this.object)) {
                this.jp.joined();
                return null;
            }
            File[] list = this.dir.listFiles();
            if (list == null) {
                DirectoryWalker.this.accessDenied(this.dir);
                this.jp.joined();
                return null;
            }
            if (list.length == 0) {
                this.jp.joined();
                return null;
            }
            for (File f : list) {
                if (f.isDirectory()) {
                    Object o = DirectoryWalker.this.directoryFound(this.object, f);
                    this.jp.addToJoin(1);
                    new DirectoryReader(this.getTaskManager(), o, f, this.jp, this.getPriority()).start();
                    continue;
                }
                DirectoryWalker.this.fileFound(this.object, f);
            }
            DirectoryWalker.this.endDirectory(this.dir, this.object);
            this.jp.joined();
            return null;
        }
    }
}

