/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.nio.charset.StandardCharsets;
import net.lecousin.framework.io.encoding.IBytesEncoding;
import net.lecousin.framework.io.util.DataUtil;
import net.lecousin.framework.math.FragmentedRangeLong;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.util.IDManager;

public class IDManagerLong
implements IDManager {
    private IBytesEncoding encoder;
    private FragmentedRangeLong free = new FragmentedRangeLong(new RangeLong(1L, Long.MAX_VALUE));

    public IDManagerLong(IBytesEncoding encoder) {
        this.encoder = encoder;
    }

    @Override
    public String allocate() {
        Long id = this.free.removeFirstValue();
        return new String(this.encoder.encode(DataUtil.getBytesLittleEndian(id)), StandardCharsets.ISO_8859_1);
    }

    @Override
    public void free(String id) {
        long l = DataUtil.readLongLittleEndian(this.encoder.decode(id.getBytes(StandardCharsets.ISO_8859_1)), 0);
        this.free.addValue(l);
    }
}

