/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.encoding.DecimalNumber;
import net.lecousin.framework.io.encoding.HexadecimalNumber;
import net.lecousin.framework.io.encoding.INumberEncoding;
import net.lecousin.framework.io.text.BufferedReadableCharacterStreamLocation;
import net.lecousin.framework.locale.LocalizableString;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.UnprotectedString;
import net.lecousin.framework.util.UnprotectedStringBuffer;
import net.lecousin.framework.xml.XMLException;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamEventsSync;

public class XMLStreamReader
extends XMLStreamEventsSync {
    private Charset defaultEncoding;
    private int charactersBuffersSize;
    private IO.Readable.Buffered io;
    private BufferedReadableCharacterStreamLocation stream;
    private static char[] CDATA = new char[]{'C', 'D', 'A', 'T', 'A', '['};
    private static char[] OCTYPE = new char[]{'O', 'C', 'T', 'Y', 'P', 'E'};
    private static char[] YSTEM = new char[]{'Y', 'S', 'T', 'E', 'M'};
    private static char[] UBLIC = new char[]{'U', 'B', 'L', 'I', 'C'};

    public XMLStreamReader(IO.Readable io, Charset defaultEncoding, int charactersBuffersSize) {
        this.io = io instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)io : new PreBufferedReadable(io, 1024, io.getPriority(), charactersBuffersSize, (byte)(io.getPriority() - 1), 4);
        this.defaultEncoding = defaultEncoding;
        this.charactersBuffersSize = charactersBuffersSize;
    }

    public XMLStreamReader(IO.Readable io, int charactersBuffersSize) {
        this(io, null, charactersBuffersSize);
    }

    public static AsyncWork<XMLStreamReader, Exception> start(final IO.Readable.Buffered io, final int charactersBufferSize) {
        final AsyncWork<XMLStreamReader, Exception> result = new AsyncWork<XMLStreamReader, Exception>();
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Start reading XML " + io.getSourceDescription(), io.getPriority()){

            @Override
            public Void run() {
                XMLStreamReader reader = new XMLStreamReader(io, charactersBufferSize);
                try {
                    reader.start();
                    result.unblockSuccess(reader);
                }
                catch (Exception e) {
                    result.unblockError(e);
                }
                return null;
            }
        };
        task.startOn(io.canStartReading(), true);
        return result;
    }

    @Override
    public void start() throws XMLException, IOException {
        XMLStreamEvents.Starter start = new XMLStreamEvents.Starter(this.io, this.defaultEncoding, this.charactersBuffersSize);
        this.stream = start.start();
        this.next();
    }

    @Override
    public void next() throws XMLException, IOException {
        this.reset();
        char c = this.stream.read();
        if (c == '<') {
            this.readTag();
        } else {
            this.readChars(c);
        }
    }

    @Override
    public Pair<Integer, Integer> getPosition() {
        return new Pair<Integer, Integer>(this.stream.getLine(), this.stream.getPositionInLine());
    }

    public void startRootElement() throws XMLException, IOException {
        this.start();
        while (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
            this.next();
        }
    }

    private void readTag() throws XMLException, IOException {
        block6: {
            try {
                char c = this.stream.read();
                if (c == '!') {
                    this.readTagExclamation();
                    break block6;
                }
                if (c == '?') {
                    this.readProcessingInstruction();
                    break block6;
                }
                if (c == '/') {
                    this.readEndTag();
                    break block6;
                }
                if (XMLStreamReader.isNameStartChar(c)) {
                    this.readStartTag(c);
                    break block6;
                }
                throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
            }
            catch (EOFException e) {
                throw new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0]));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readTagExclamation() throws XMLException, IOException {
        char c = this.stream.read();
        if (c == '-') {
            c = this.stream.read();
            if (c != '-') throw new XMLException(this.getPosition(), "Invalid XML", new Object[0]);
            this.readComment();
            return;
        } else if (c == '[') {
            if (!this.readExpectedChars(CDATA)) {
                throw new XMLException(this.getPosition(), "Invalid XML", new Object[0]);
            }
            this.readCData();
            return;
        } else {
            if (c != 'D') throw new XMLException(this.getPosition(), "Invalid XML", new Object[0]);
            if (!this.readExpectedChars(OCTYPE)) {
                throw new XMLException(this.getPosition(), "Invalid XML", new Object[0]);
            }
            this.readDocType();
        }
    }

    private void readDocType() throws XMLException, IOException {
        char c;
        this.event.type = XMLStreamEvents.Event.Type.DOCTYPE;
        this.event.text = new UnprotectedStringBuffer();
        this.readSpace();
        this.readName(this.event.text);
        while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
        }
        if (c == 'S') {
            if (!this.readExpectedChars(YSTEM)) {
                throw new XMLException(this.getPosition(), "Invalid XML", new Object[0]);
            }
            this.readSpace();
            this.event.system = this.readSystemLiteral();
            c = this.stream.read();
            while (XMLStreamReader.isSpaceChar(c)) {
                c = this.stream.read();
            }
        } else if (c == 'P') {
            if (!this.readExpectedChars(UBLIC)) {
                throw new XMLException(this.getPosition(), "Invalid XML", new Object[0]);
            }
            this.readSpace();
            this.event.publicId = this.readPublicIDLiteral();
            this.readSpace();
            this.event.system = this.readSystemLiteral();
            c = this.stream.read();
            while (XMLStreamReader.isSpaceChar(c)) {
                c = this.stream.read();
            }
        }
        if (c == '[') {
            this.readIntSubset();
            c = this.stream.read();
            while (XMLStreamReader.isSpaceChar(c)) {
                c = this.stream.read();
            }
        }
        if (c != '>') {
            throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
        }
    }

    private void readComment() throws XMLException, IOException {
        this.event.type = XMLStreamEvents.Event.Type.COMMENT;
        this.event.text = new UnprotectedStringBuffer();
        while (true) {
            char c;
            try {
                c = this.stream.read();
            }
            catch (EOFException e) {
                throw new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "inside comment", new Object[0]));
            }
            if (c == '-') {
                try {
                    c = this.stream.read();
                }
                catch (EOFException e) {
                    throw new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "inside comment", new Object[0]));
                }
                if (c != '-') {
                    this.event.text.append('-');
                    this.event.text.append(c);
                    continue;
                }
                while (true) {
                    try {
                        c = this.stream.read();
                    }
                    catch (EOFException e) {
                        throw new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "inside comment", new Object[0]));
                    }
                    if (c == '>') {
                        return;
                    }
                    if (c != '-') break;
                    this.event.text.append('-');
                }
                this.event.text.append('-');
                this.event.text.append('-');
                continue;
            }
            this.event.text.append(c);
        }
    }

    private boolean readExpectedChars(char[] expected) throws IOException {
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == this.stream.read()) continue;
            return false;
        }
        return true;
    }

    private void readCData() throws XMLException, IOException {
        this.event.type = XMLStreamEvents.Event.Type.CDATA;
        this.event.text = new UnprotectedStringBuffer();
        while (true) {
            char c;
            try {
                c = this.stream.read();
            }
            catch (EOFException e) {
                throw new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "inside CDATA", new Object[0]));
            }
            if (c == ']') {
                try {
                    c = this.stream.read();
                }
                catch (EOFException e) {
                    throw new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "inside CDATA", new Object[0]));
                }
                if (c != ']') {
                    this.event.text.append(']');
                    this.event.text.append(c);
                    continue;
                }
                while (true) {
                    try {
                        c = this.stream.read();
                    }
                    catch (EOFException e) {
                        throw new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "inside CDATA", new Object[0]));
                    }
                    if (c == '>') {
                        return;
                    }
                    if (c != ']') break;
                    this.event.text.append(']');
                }
                this.event.text.append(']');
                this.event.text.append(']');
                this.event.text.append(c);
                continue;
            }
            this.event.text.append(c);
        }
    }

    private void readStartTag(char c) throws XMLException, IOException {
        this.event.type = XMLStreamEvents.Event.Type.START_ELEMENT;
        this.event.attributes = new LinkedList();
        this.event.text = new UnprotectedStringBuffer();
        this.event.text.append(c);
        this.continueReadName(this.event.text);
        while (true) {
            if (XMLStreamReader.isSpaceChar(c = this.stream.read())) continue;
            if (c == '>') break;
            if (c == '/') {
                if (this.stream.read() != '>') {
                    throw new XMLException(this.getPosition(), "Invalid XML", new Object[0]);
                }
                this.event.isClosed = true;
                break;
            }
            if (!XMLStreamReader.isNameStartChar(c)) {
                throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
            }
            XMLStreamEvents.Attribute a = new XMLStreamEvents.Attribute();
            a.text = new UnprotectedStringBuffer();
            a.text.append(c);
            this.continueReadName(a.text);
            int i = a.text.indexOf(':');
            if (i < 0) {
                a.namespacePrefix = new UnprotectedStringBuffer();
                a.localName = a.text;
            } else {
                a.namespacePrefix = a.text.substring(0, i);
                a.localName = a.text.substring(i + 1);
            }
            while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
            }
            if (c != '=') {
                throw new XMLException(this.getPosition(), "Expected character", Character.valueOf(c), Character.valueOf('='));
            }
            while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
            }
            a.value = new UnprotectedStringBuffer();
            if (c != '\"' && c != '\'') {
                throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
            }
            this.readAttrValue(a.value, c);
            this.event.attributes.add(a);
        }
        this.onStartElement();
    }

    private void readProcessingInstruction() throws XMLException, IOException {
        this.event.type = XMLStreamEvents.Event.Type.PROCESSING_INSTRUCTION;
        this.event.attributes = new LinkedList();
        this.event.text = new UnprotectedStringBuffer();
        this.readName(this.event.text);
        while (true) {
            char c;
            if (XMLStreamReader.isSpaceChar(c = this.stream.read())) continue;
            if (c == '?') {
                c = this.stream.read();
                if (c == '>') {
                    this.event.isClosed = true;
                    return;
                }
                this.stream.back(c);
                continue;
            }
            if (!XMLStreamReader.isNameStartChar(c)) continue;
            XMLStreamEvents.Attribute a = new XMLStreamEvents.Attribute();
            a.text = new UnprotectedStringBuffer();
            a.text.append(c);
            this.continueReadName(a.text);
            int i = a.text.indexOf(':');
            if (i < 0) {
                a.namespacePrefix = new UnprotectedStringBuffer();
                a.localName = a.text;
            } else {
                a.namespacePrefix = a.text.substring(0, i);
                a.localName = a.text.substring(i + 1);
            }
            while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
            }
            if (c != '=') {
                this.event.attributes.add(a);
                this.stream.back(c);
                continue;
            }
            while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
            }
            a.value = new UnprotectedStringBuffer();
            if (c != '\"' && c != '\'') {
                throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
            }
            this.readAttrValue(a.value, c);
            this.event.attributes.add(a);
        }
    }

    private void readAttrValue(UnprotectedStringBuffer value, char quote) throws XMLException, IOException {
        char c;
        while ((c = this.stream.read()) != quote) {
            if (c == '<') {
                throw new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected character", Character.valueOf(c)), new LocalizableString("lc.xml.error", "in attribute value", new Object[0]));
            }
            if (c == '&') {
                value.append(this.readReference());
                continue;
            }
            if (c == '\n') {
                value.append(' ');
                continue;
            }
            if (c == '\r') continue;
            value.append(c);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readChars(char c) throws XMLException, IOException {
        this.event.type = XMLStreamEvents.Event.Type.TEXT;
        this.event.text = new UnprotectedStringBuffer();
        while (true) {
            block11: {
                if (c == '&') {
                    this.event.text.append(this.readReference());
                } else {
                    if (c == '<') {
                        this.stream.back(c);
                        return;
                    }
                    if (c == '\r') {
                        try {
                            c = this.stream.read();
                        }
                        catch (EOFException e) {
                            this.event.text.append(c);
                            return;
                        }
                        if (c == '\n') {
                            this.event.text.append(c);
                            break block11;
                        } else {
                            this.event.text.append('\r');
                            continue;
                        }
                    }
                    this.event.text.append(c);
                }
            }
            try {
                c = this.stream.read();
            }
            catch (EOFException e) {
                return;
            }
        }
    }

    private CharSequence readReference() throws XMLException, IOException {
        char c = this.stream.read();
        if (c == '#') {
            return new UnprotectedString(this.readCharRef());
        }
        UnprotectedStringBuffer name = new UnprotectedStringBuffer();
        name.append(c);
        this.continueReadName(name);
        c = this.stream.read();
        if (c != ';') {
            throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
        }
        return XMLStreamReader.resolveEntityRef(name);
    }

    private char[] readCharRef() throws XMLException, IOException {
        INumberEncoding n;
        char c = this.stream.read();
        if (c == 'x') {
            n = new HexadecimalNumber();
        } else {
            n = new DecimalNumber();
            if (!n.addChar(c)) {
                throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
            }
        }
        while ((c = this.stream.read()) != ';') {
            if (n.addChar(c)) continue;
            throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
        }
        return Character.toChars((int)n.getNumber());
    }

    private static CharSequence resolveEntityRef(UnprotectedStringBuffer name) {
        int l = name.length();
        if (l < 2) {
            UnprotectedStringBuffer s = new UnprotectedStringBuffer();
            s.append('&');
            s.append(name);
            s.append(';');
            return s;
        }
        char c = name.charAt(0);
        if (c == 'a') {
            if (l == 3) {
                if (name.charAt(1) == 'm' && name.charAt(2) == 'p') {
                    return new UnprotectedString('&');
                }
            } else if (l == 4 && name.charAt(1) == 'p' && name.charAt(2) == 'o' && name.charAt(3) == 's') {
                return new UnprotectedString('\'');
            }
        } else if (c == 'l') {
            if (l == 2 && name.charAt(1) == 't') {
                return new UnprotectedString('<');
            }
        } else if (c == 'g') {
            if (l == 2 && name.charAt(1) == 't') {
                return new UnprotectedString('>');
            }
        } else if (c == 'q' && l == 4 && name.charAt(1) == 'u' && name.charAt(2) == 'o' && name.charAt(3) == 't') {
            return new UnprotectedString('\"');
        }
        UnprotectedStringBuffer s = new UnprotectedStringBuffer();
        s.append('&');
        s.append(name);
        s.append(';');
        return s;
    }

    private UnprotectedStringBuffer readSystemLiteral() throws XMLException, IOException {
        char c = this.stream.read();
        if (c != '\"' && c != '\'') {
            throw new XMLException(this.getPosition(), "Expected character", Character.valueOf(c), "simple or double quote");
        }
        UnprotectedStringBuffer literal = new UnprotectedStringBuffer();
        char quote = c;
        while ((c = this.stream.read()) != quote) {
            literal.append(c);
        }
        return literal;
    }

    private UnprotectedStringBuffer readPublicIDLiteral() throws XMLException, IOException {
        char c;
        char quote = this.stream.read();
        if (quote != '\"' && quote != '\'') {
            throw new XMLException(this.getPosition(), "Expected character", Character.valueOf(quote), "\",'");
        }
        UnprotectedStringBuffer literal = new UnprotectedStringBuffer();
        while ((c = this.stream.read()) != quote) {
            literal.append(c);
        }
        return literal;
    }

    private void readEndTag() throws XMLException, IOException {
        char c;
        this.event.type = XMLStreamEvents.Event.Type.END_ELEMENT;
        this.event.text = new UnprotectedStringBuffer();
        this.readName(this.event.text);
        while ((c = this.stream.read()) != '>') {
            if (XMLStreamReader.isSpaceChar(c)) continue;
            throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
        }
        XMLStreamEvents.ElementContext ctx = this.event.context.peekFirst();
        if (ctx == null) {
            throw new XMLException(this.getPosition(), "Unexpected end element", this.event.text.asString());
        }
        if (!ctx.text.equals(this.event.text)) {
            throw new XMLException(this.getPosition(), "Unexpected end element expected is", this.event.text.asString(), ctx.text.asString());
        }
        int i = this.event.text.indexOf(':');
        if (i < 0) {
            this.event.namespacePrefix = new UnprotectedStringBuffer();
            this.event.localName = this.event.text;
        } else {
            this.event.namespacePrefix = this.event.text.substring(0, i);
            this.event.localName = this.event.text.substring(i + 1);
        }
        this.event.namespaceURI = this.getNamespaceURI(this.event.namespacePrefix);
    }

    private void readIntSubset() throws XMLException, IOException {
        XMLStreamEvents.Event save = this.event.copy();
        while (true) {
            char c;
            try {
                c = this.stream.read();
            }
            catch (EOFException e) {
                throw new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in internal subset declaration", new Object[0]));
            }
            if (XMLStreamReader.isSpaceChar(c)) continue;
            if (c == ']') break;
            if (c == '%') {
                this.readIntSubsetPEReference();
                continue;
            }
            if (c != '<') {
                throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
            }
            this.readIntSubsetTag();
        }
        this.event = save;
    }

    private void readIntSubsetPEReference() throws XMLException, IOException {
        UnprotectedStringBuffer name = new UnprotectedStringBuffer();
        this.readName(name);
        try {
            char c;
            while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
            }
            if (c != ';') {
                throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
            }
        }
        catch (EOFException e) {
            throw new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in internal subset declaration", new Object[0]));
        }
    }

    private void readIntSubsetTag() throws XMLException, IOException {
        block4: {
            try {
                char c = this.stream.read();
                if (c == '!') {
                    this.readIntSubsetTagExclamation();
                    break block4;
                }
                if (c == '?') {
                    this.readProcessingInstruction();
                    break block4;
                }
                throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
            }
            catch (EOFException e) {
                throw new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0]));
            }
        }
    }

    private void readIntSubsetTagExclamation() throws XMLException, IOException {
        char c = this.stream.read();
        if (c == '-') {
            c = this.stream.read();
            if (c == '-') {
                this.readComment();
                return;
            }
            throw new XMLException(this.getPosition(), "Invalid XML", new Object[0]);
        }
        if (c == 'E') {
            c = this.stream.read();
            if (c == 'L') {
                if (this.stream.read() == 'E' && this.stream.read() == 'M' && this.stream.read() == 'E' && this.stream.read() == 'N' && this.stream.read() == 'T' && XMLStreamReader.isSpaceChar(this.stream.read())) {
                    this.readElementDeclaration();
                    return;
                }
            } else if (c == 'N' && this.stream.read() == 'T' && this.stream.read() == 'I' && this.stream.read() == 'T' && this.stream.read() == 'Y' && XMLStreamReader.isSpaceChar(this.stream.read())) {
                this.readEntityDeclaration();
                return;
            }
        } else if (c == 'A') {
            if (this.stream.read() == 'T' && this.stream.read() == 'T' && this.stream.read() == 'L' && this.stream.read() == 'I' && this.stream.read() == 'S' && this.stream.read() == 'T' && XMLStreamReader.isSpaceChar(this.stream.read())) {
                this.readAttListDeclaration();
                return;
            }
        } else if (c == 'N' && this.stream.read() == 'O' && this.stream.read() == 'T' && this.stream.read() == 'A' && this.stream.read() == 'T' && this.stream.read() == 'I' && this.stream.read() == 'O' && this.stream.read() == 'N' && XMLStreamReader.isSpaceChar(this.stream.read())) {
            this.readNotationDeclaration();
            return;
        }
        throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
    }

    private void readElementDeclaration() throws XMLException, IOException {
        char c = this.stream.read();
        while (XMLStreamReader.isSpaceChar(c)) {
            c = this.stream.read();
        }
        this.stream.back(c);
        UnprotectedStringBuffer name = new UnprotectedStringBuffer();
        this.readName(name);
        c = this.stream.read();
        while (c != '>') {
            c = this.stream.read();
        }
    }

    private void readEntityDeclaration() throws IOException {
        char c = this.stream.read();
        while (XMLStreamReader.isSpaceChar(c)) {
            c = this.stream.read();
        }
        boolean inString = false;
        while (true) {
            c = this.stream.read();
            if (inString) {
                if (c != '\"') continue;
                inString = false;
                continue;
            }
            if (c == '\"') {
                inString = true;
                continue;
            }
            if (c == '>') break;
        }
    }

    private void readAttListDeclaration() throws XMLException, IOException {
        char c = this.stream.read();
        while (XMLStreamReader.isSpaceChar(c)) {
            c = this.stream.read();
        }
        this.stream.back(c);
        UnprotectedStringBuffer name = new UnprotectedStringBuffer();
        this.readName(name);
        c = this.stream.read();
        while (c != '>') {
            c = this.stream.read();
        }
    }

    private void readNotationDeclaration() throws XMLException, IOException {
        char c = this.stream.read();
        while (XMLStreamReader.isSpaceChar(c)) {
            c = this.stream.read();
        }
        this.stream.back(c);
        UnprotectedStringBuffer name = new UnprotectedStringBuffer();
        this.readName(name);
        c = this.stream.read();
        while (c != '>') {
            c = this.stream.read();
        }
    }

    private void readName(UnprotectedStringBuffer name) throws XMLException, IOException {
        char c = this.stream.read();
        if (!XMLStreamReader.isNameStartChar(c)) {
            throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
        }
        name.append(c);
        this.continueReadName(name);
    }

    private void continueReadName(UnprotectedStringBuffer name) throws IOException {
        while (true) {
            char c;
            if (!XMLStreamReader.isNameChar(c = this.stream.read())) {
                this.stream.back(c);
                return;
            }
            name.append(c);
        }
    }

    private void readSpace() throws XMLException, IOException {
        char c = this.stream.read();
        if (!XMLStreamReader.isSpaceChar(c)) {
            throw new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c));
        }
        while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
        }
        this.stream.back(c);
    }

    private static boolean isNameStartChar(char c) {
        if (c < '\u00f8') {
            if (c < ':') {
                return false;
            }
            if (c < '\u00c0') {
                if (c == ':' || c == '_') {
                    return true;
                }
                if (c >= 'a' && c <= 'z') {
                    return true;
                }
                return c >= 'A' && c <= 'Z';
            }
            if (c == '\u00d7') {
                return false;
            }
            return c != '\u00f7';
        }
        if (c < '\u2000') {
            if (c >= '\u0300' && c <= '\u036f') {
                return false;
            }
            return c != '\u037e';
        }
        if (c < '\ud800') {
            if (c <= '\u3000') {
                if (c < '\u2070') {
                    return c != '\u200c' && c != '\u200d';
                }
                if (c < '\u2190') {
                    return true;
                }
                if (c < '\u2c00') {
                    return false;
                }
                if (c > '\u2fef') {
                    return false;
                }
            }
            return true;
        }
        if (c >= '\ue000') {
            if (c < '\uf900') {
                return false;
            }
            if (c <= '\ufdcf') {
                return true;
            }
            if (c < '\ufdf0') {
                return false;
            }
            return c <= '\ufffd';
        }
        return c < '\udc00';
    }

    private static boolean isNameChar(char c) {
        if (c < '\u00f8') {
            if (c < ':') {
                if (c < '-') {
                    return false;
                }
                return c != '/';
            }
            if (c < '\u00c0') {
                if (c == ':' || c == '_') {
                    return true;
                }
                if (c >= 'a' && c <= 'z') {
                    return true;
                }
                if (c >= 'A' && c <= 'Z') {
                    return true;
                }
                return c == '\u00b7';
            }
            if (c == '\u00d7') {
                return false;
            }
            return c != '\u00f7';
        }
        if (c < '\u2000') {
            return c != '\u037e';
        }
        if (c < '\ud800') {
            if (c <= '\u3000') {
                if (c < '\u2070') {
                    return c != '\u200c' && c != '\u200d' && c != '\u203f' && c != '\u2040';
                }
                if (c < '\u2190') {
                    return true;
                }
                if (c < '\u2c00') {
                    return false;
                }
                if (c > '\u2fef') {
                    return false;
                }
            }
            return true;
        }
        if (c >= '\ue000') {
            if (c < '\uf900') {
                return false;
            }
            if (c <= '\ufdcf') {
                return true;
            }
            if (c < '\ufdf0') {
                return false;
            }
            return c <= '\ufffd';
        }
        return true;
    }
}

