/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.encoding.DecimalNumber;
import net.lecousin.framework.io.encoding.HexadecimalNumber;
import net.lecousin.framework.io.encoding.INumberEncoding;
import net.lecousin.framework.io.text.BufferedReadableCharacterStreamLocation;
import net.lecousin.framework.locale.ILocalizableString;
import net.lecousin.framework.locale.LocalizableString;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.UnprotectedStringBuffer;
import net.lecousin.framework.xml.XMLException;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamEventsAsync;

public class XMLStreamReaderAsync
extends XMLStreamEventsAsync {
    private Charset defaultEncoding;
    private int charactersBuffersSize;
    private int maxTextSize = -1;
    private int maxCDataSize = -1;
    private IO.Readable.Buffered io;
    private BufferedReadableCharacterStreamLocation stream;
    private State state;
    private int statePos = 0;

    public XMLStreamReaderAsync(IO.Readable io, Charset defaultEncoding, int charactersBuffersSize) {
        this.io = io instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)io : new PreBufferedReadable(io, 1024, io.getPriority(), charactersBuffersSize, (byte)(io.getPriority() - 1), 4);
        this.defaultEncoding = defaultEncoding;
        this.charactersBuffersSize = charactersBuffersSize;
    }

    public XMLStreamReaderAsync(IO.Readable io, int charactersBuffersSize) {
        this(io, null, charactersBuffersSize);
    }

    public int getMaximumTextSize() {
        return this.maxTextSize;
    }

    public void setMaximumTextSize(int max) {
        this.maxTextSize = max;
    }

    public int getMaximumCDataSize() {
        return this.maxCDataSize;
    }

    public void setMaximumCDataSize(int max) {
        this.maxCDataSize = max;
    }

    @Override
    public ISynchronizationPoint<Exception> start() {
        SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        this.io.canStartReading().listenAsync(new Task.Cpu.FromRunnable(() -> {
            try {
                XMLStreamEvents.Starter start = new XMLStreamEvents.Starter(this.io, this.defaultEncoding, this.charactersBuffersSize);
                this.stream = start.start();
                this.next().listenInline(sp);
            }
            catch (Exception e) {
                sp.error(e);
            }
        }, "Start parsing XML", this.io.getPriority()), true);
        return sp;
    }

    @Override
    public SynchronizationPoint<Exception> next() {
        SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        this.reset();
        this.state = State.START;
        this.nextChar(sp);
        return sp;
    }

    @Override
    public byte getPriority() {
        return this.io.getPriority();
    }

    public Pair<Integer, Integer> getPosition() {
        return new Pair<Integer, Integer>(this.stream.getLine(), this.stream.getPositionInLine());
    }

    public ISynchronizationPoint<Exception> startRootElement() {
        ISynchronizationPoint<Exception> start = this.start();
        if (start.isUnblocked()) {
            if (start.hasError()) {
                return start;
            }
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                return start;
            }
            return this.nextStartElement();
        }
        SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        start.listenAsync(new XMLStreamEventsAsync.Next(sp){

            @Override
            protected void onNext() {
                if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)XMLStreamReaderAsync.this.event.type)) {
                    this.sp.unblock();
                } else {
                    XMLStreamReaderAsync.this.nextStartElement().listenInline(this.sp);
                }
            }
        }, sp);
        return sp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nextChar(SynchronizationPoint<Exception> sp) {
        block32: while (true) {
            int c;
            try {
                c = this.stream.readAsync();
            }
            catch (IOException e) {
                sp.error(e);
                return;
            }
            if (c == -2) {
                this.stream.canStartReading().listenAsync(new XMLStreamEventsAsync.ParsingTask(this, () -> this.nextChar(sp)), true);
                return;
            }
            switch (this.state) {
                case START: {
                    if (c == -1) {
                        sp.error(new EOFException());
                        return;
                    }
                    if (c == 60) {
                        this.state = State.TAG;
                        continue block32;
                    }
                    this.state = State.CHARS;
                    this.event.type = XMLStreamEvents.Event.Type.TEXT;
                    this.event.text = new UnprotectedStringBuffer();
                    if (this.readChars(c, sp)) continue block32;
                    return;
                }
                case TAG: {
                    if (this.readTag(c, sp)) continue block32;
                    return;
                }
                case TAG_EXCLAMATION: {
                    if (this.readTagExclamation(c, sp)) continue block32;
                    return;
                }
                case PROCESSING_INSTRUCTION: {
                    if (this.readProcessingInstruction(c, sp)) continue block32;
                    return;
                }
                case PROCESSING_INSTRUCTION_CLOSED: {
                    if (this.readProcessingInstructionClosed(c, sp)) continue block32;
                    return;
                }
                case END_ELEMENT_NAME: {
                    if (this.readEndElementName(c, sp)) continue block32;
                    return;
                }
                case START_ELEMENT_NAME: {
                    if (this.readStartElementName(c, sp)) continue block32;
                    return;
                }
                case START_ELEMENT_SPACE: {
                    if (this.readStartElementSpace(c, sp)) continue block32;
                    return;
                }
                case START_ELEMENT_CLOSED: {
                    if (this.readStartElementClosed(c, sp)) continue block32;
                    return;
                }
                case ATTRIBUTE_NAME: {
                    if (this.readAttributeName(c, sp)) continue block32;
                    return;
                }
                case ATTRIBUTE_NAME_SPACE: {
                    if (this.readAttributeNameSpace(c, sp)) continue block32;
                    return;
                }
                case ATTRIBUTE_VALUE_SPACE: {
                    if (this.readAttributeValueSpace(c, sp)) continue block32;
                    return;
                }
                case ATTRIBUTE_VALUE: {
                    if (this.readAttributeValue(c, sp)) continue block32;
                    return;
                }
                case COMMENT: {
                    if (this.readComment(c, sp)) continue block32;
                    return;
                }
                case CDATA: {
                    if (this.readCData(c, sp)) continue block32;
                    return;
                }
                case DOCTYPE: {
                    if (this.readDocType(c, sp)) continue block32;
                    return;
                }
                case DOCTYPE_NAME: {
                    if (this.readDocTypeName(c, sp)) continue block32;
                    return;
                }
                case DOCTYPE_SPACE: {
                    if (this.readDocTypeSpace(c, sp)) continue block32;
                    return;
                }
                case DOCTYPE_PUBLIC_NAME: {
                    if (this.readDocTypePublicName(c, sp)) continue block32;
                    return;
                }
                case DOCTYPE_PUBLIC_SPACE: {
                    if (this.readDocTypePublicSpace(c, sp)) continue block32;
                    return;
                }
                case DOCTYPE_PUBLIC_ID: {
                    if (this.readDocTypePublicId(c, sp)) continue block32;
                    return;
                }
                case DOCTYPE_SYSTEM_NAME: {
                    if (this.readDocTypeSystemName(c, sp)) continue block32;
                    return;
                }
                case DOCTYPE_SYSTEM_SPACE: {
                    if (this.readDocTypeSystemSpace(c, sp)) continue block32;
                    return;
                }
                case DOCTYPE_SYSTEM_VALUE: {
                    if (this.readDocTypeSystemValue(c, sp)) continue block32;
                    return;
                }
                case DOCTYPE_INTERNAL_SUBSET: {
                    if (this.readInternalSubset(c, sp)) continue block32;
                    return;
                }
                case DOCTYPE_INTERNAL_SUBSET_PEREFERENCE: {
                    if (this.readInternalSubsetPEReference(c, sp)) continue block32;
                    return;
                }
                case DOCTYPE_INTERNAL_SUBSET_TAG: {
                    if (this.readInternalSubsetTag(c, sp)) continue block32;
                    return;
                }
                case CHARS: {
                    if (!this.readChars(c, sp)) return;
                    continue block32;
                }
            }
            break;
        }
        sp.error(new Exception("Unexpected state " + (Object)((Object)this.state)));
    }

    private boolean readTag(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (c == 33) {
            this.state = State.TAG_EXCLAMATION;
            this.event.text = new UnprotectedStringBuffer();
            return true;
        }
        if (c == 63) {
            this.state = State.PROCESSING_INSTRUCTION;
            this.event.text = new UnprotectedStringBuffer();
            this.event.attributes = new LinkedList();
            this.event.type = XMLStreamEvents.Event.Type.PROCESSING_INSTRUCTION;
            return true;
        }
        if (c == 47) {
            this.state = State.END_ELEMENT_NAME;
            this.event.type = XMLStreamEvents.Event.Type.END_ELEMENT;
            this.event.text = new UnprotectedStringBuffer();
            return true;
        }
        if (XMLStreamReaderAsync.isNameStartChar((char)c)) {
            this.state = State.START_ELEMENT_NAME;
            this.event.type = XMLStreamEvents.Event.Type.START_ELEMENT;
            this.event.attributes = new LinkedList();
            this.event.text = new UnprotectedStringBuffer();
            this.event.text.append((char)c);
            return true;
        }
        sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf((char)c)));
        return false;
    }

    private boolean readTagExclamation(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (this.event.text.length() == 0) {
            if (c == 45) {
                this.event.text.append((char)c);
                return true;
            }
            if (c == 91) {
                this.event.text.append((char)c);
                return true;
            }
            if (c == 68) {
                this.event.text.append((char)c);
                return true;
            }
            sp.error(new XMLException(this.getPosition(), "Invalid XML", new Object[0]));
            return false;
        }
        char c1 = this.event.text.charAt(0);
        if (c1 == '-') {
            if (c == 45) {
                this.state = State.COMMENT;
                this.event.type = XMLStreamEvents.Event.Type.COMMENT;
                this.event.text = new UnprotectedStringBuffer();
                return true;
            }
            sp.error(new XMLException(this.getPosition(), "Invalid XML", new Object[0]));
            return false;
        }
        if (c1 == '[') {
            this.event.text.append((char)c);
            if (this.event.text.length() < 7) {
                if (this.event.text.isStartOf("[CDATA[")) {
                    return true;
                }
                sp.error(new XMLException(this.getPosition(), "Invalid XML", new Object[0]));
                return false;
            }
            if (!this.event.text.equals("[CDATA[")) {
                sp.error(new XMLException(this.getPosition(), "Invalid XML", new Object[0]));
                return false;
            }
            this.state = State.CDATA;
            this.event.type = XMLStreamEvents.Event.Type.CDATA;
            this.event.text = new UnprotectedStringBuffer();
            return true;
        }
        if (this.event.text.length() < 7) {
            this.event.text.append((char)c);
            if (this.event.text.isStartOf("DOCTYPE")) {
                return true;
            }
            sp.error(new XMLException(this.getPosition(), "Invalid XML", new Object[0]));
            return false;
        }
        if (!XMLStreamReaderAsync.isSpaceChar((char)c)) {
            sp.error(new XMLException(this.getPosition(), "Invalid XML", new Object[0]));
            return false;
        }
        this.state = State.DOCTYPE;
        this.event.type = XMLStreamEvents.Event.Type.DOCTYPE;
        this.event.text = new UnprotectedStringBuffer();
        return true;
    }

    private boolean readDocType(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (XMLStreamReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        if (!XMLStreamReaderAsync.isNameStartChar((char)c)) {
            sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf((char)c)));
            return false;
        }
        this.event.text.append((char)c);
        this.state = State.DOCTYPE_NAME;
        return true;
    }

    private boolean readDocTypeName(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (XMLStreamReaderAsync.isNameChar((char)c)) {
            this.event.text.append((char)c);
            return true;
        }
        if (XMLStreamReaderAsync.isSpaceChar((char)c)) {
            this.state = State.DOCTYPE_SPACE;
            return true;
        }
        if (c == 91) {
            this.state = State.DOCTYPE_INTERNAL_SUBSET;
            return true;
        }
        if (c == 62) {
            sp.unblock();
            return false;
        }
        sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf((char)c)));
        return false;
    }

    private boolean readDocTypeSpace(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (XMLStreamReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        if (c == 91) {
            this.state = State.DOCTYPE_INTERNAL_SUBSET;
            return true;
        }
        if (c == 62) {
            sp.unblock();
            return false;
        }
        if (c == 80) {
            this.state = State.DOCTYPE_PUBLIC_NAME;
            this.statePos = 1;
            return true;
        }
        if (c == 83) {
            this.state = State.DOCTYPE_SYSTEM_NAME;
            this.statePos = 1;
            return true;
        }
        sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf((char)c)));
        return false;
    }

    private boolean readDocTypePublicName(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (this.statePos < 6) {
            if (c != "PUBLIC".charAt(this.statePos)) {
                sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf((char)c)));
                return false;
            }
            ++this.statePos;
            return true;
        }
        if (this.event.publicId == null) {
            this.event.publicId = new UnprotectedStringBuffer();
        }
        if (this.event.publicId.length() > 0) {
            sp.error(new XMLException(this.getPosition(), (ILocalizableString)new LocalizableString("lc.xml.error", "Invalid XML", new Object[0])));
            return false;
        }
        if (!XMLStreamReaderAsync.isSpaceChar((char)c)) {
            sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf((char)c)));
            return false;
        }
        this.state = State.DOCTYPE_PUBLIC_SPACE;
        return true;
    }

    private boolean readDocTypePublicSpace(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (XMLStreamReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        if (c != 34 && c != 39) {
            sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf((char)c)));
            return false;
        }
        this.state = State.DOCTYPE_PUBLIC_ID;
        this.statePos = c;
        return true;
    }

    private boolean readDocTypePublicId(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (c == this.statePos) {
            this.state = State.DOCTYPE_SYSTEM_SPACE;
            return true;
        }
        if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 32 || c == 13 || c == 10 || c == 45 || c == 39 || c == 40 || c == 41 || c == 43 || c == 44 || c == 46 || c == 47 || c == 58 || c == 61 || c == 63 || c == 59 || c == 33 || c == 42 || c == 35 || c == 64 || c == 36 || c == 95 || c == 37) {
            this.event.publicId.append((char)c);
            return true;
        }
        sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf((char)c)));
        return false;
    }

    private boolean readDocTypeSystemName(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (this.statePos < 6) {
            if (c != "SYSTEM".charAt(this.statePos)) {
                sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf((char)c)));
                return false;
            }
            ++this.statePos;
            return true;
        }
        if (this.event.system == null) {
            this.event.system = new UnprotectedStringBuffer();
        }
        if (this.event.system.length() > 0) {
            sp.error(new XMLException(this.getPosition(), (ILocalizableString)new LocalizableString("lc.xml.error", "Invalid XML", new Object[0])));
            return false;
        }
        if (!XMLStreamReaderAsync.isSpaceChar((char)c)) {
            sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf((char)c)));
            return false;
        }
        this.state = State.DOCTYPE_SYSTEM_SPACE;
        return true;
    }

    private boolean readDocTypeSystemSpace(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (XMLStreamReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        if (c != 34 && c != 39) {
            sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf((char)c)));
            return false;
        }
        this.state = State.DOCTYPE_SYSTEM_VALUE;
        this.statePos = c;
        return true;
    }

    private boolean readDocTypeSystemValue(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (c == this.statePos) {
            this.state = State.DOCTYPE_SPACE;
            return true;
        }
        if (this.event.system == null) {
            this.event.system = new UnprotectedStringBuffer();
        }
        this.event.system.append((char)c);
        return true;
    }

    private boolean readComment(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "inside comment", new Object[0])));
            return false;
        }
        if (this.maxTextSize > 0 && this.event.text.length() >= this.maxTextSize) {
            if (this.event.text.charAt(this.event.text.length() - 1) == '-') {
                if (this.event.text.charAt(this.event.text.length() - 2) == '-') {
                    if (c == 62) {
                        this.event.text.removeEndChars(2);
                        sp.unblock();
                        return false;
                    }
                    this.event.text.setCharAt(this.event.text.length() - 1, (char)c);
                    return true;
                }
                if (c != 45) {
                    this.event.text.setCharAt(this.event.text.length() - 1, (char)c);
                    return true;
                }
                this.event.text.setCharAt(this.event.text.length() - 2, (char)c);
                return true;
            }
            this.event.text.setCharAt(this.event.text.length() - 1, (char)c);
            return true;
        }
        this.event.text.append((char)c);
        if (this.event.text.endsWith("-->")) {
            this.event.text.removeEndChars(3);
            sp.unblock();
            return false;
        }
        return true;
    }

    private boolean readCData(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "inside CDATA", new Object[0])));
            return false;
        }
        if (this.maxCDataSize > 0 && this.event.text.length() >= this.maxCDataSize) {
            if (this.event.text.charAt(this.event.text.length() - 1) == ']') {
                if (this.event.text.charAt(this.event.text.length() - 2) == ']') {
                    if (c == 62) {
                        this.event.text.removeEndChars(2);
                        sp.unblock();
                        return false;
                    }
                    this.event.text.setCharAt(this.event.text.length() - 1, (char)c);
                    return true;
                }
                if (c != 93) {
                    this.event.text.setCharAt(this.event.text.length() - 1, (char)c);
                    return true;
                }
                this.event.text.setCharAt(this.event.text.length() - 2, (char)c);
                return true;
            }
            this.event.text.setCharAt(this.event.text.length() - 1, (char)c);
            return true;
        }
        this.event.text.append((char)c);
        if (this.event.text.endsWith("]]>")) {
            this.event.text.removeEndChars(3);
            sp.unblock();
            return false;
        }
        return true;
    }

    private boolean readStartElementName(int i, SynchronizationPoint<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        char c = (char)i;
        if (XMLStreamReaderAsync.isNameChar(c)) {
            this.event.text.append(c);
            return true;
        }
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            this.state = State.START_ELEMENT_SPACE;
            return true;
        }
        if (c == '>') {
            this.onStartElement();
            sp.unblock();
            return false;
        }
        if (c == '/') {
            this.state = State.START_ELEMENT_CLOSED;
            return true;
        }
        sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c)));
        return false;
    }

    private boolean readStartElementClosed(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (c != 62) {
            sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf((char)c)));
            return false;
        }
        this.event.isClosed = true;
        this.onStartElement();
        sp.unblock();
        return false;
    }

    private boolean readStartElementSpace(int i, SynchronizationPoint<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        char c = (char)i;
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            return true;
        }
        if (XMLStreamReaderAsync.isNameStartChar(c)) {
            XMLStreamEvents.Attribute a = new XMLStreamEvents.Attribute();
            a.text = new UnprotectedStringBuffer();
            a.text.append(c);
            this.event.attributes.add(a);
            this.state = State.ATTRIBUTE_NAME;
            return true;
        }
        if (!XMLStreamEvents.Event.Type.PROCESSING_INSTRUCTION.equals((Object)this.event.type)) {
            if (c == '>') {
                this.onStartElement();
                sp.unblock();
                return false;
            }
            if (c == '/') {
                this.state = State.START_ELEMENT_CLOSED;
                return true;
            }
            sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c)));
            return false;
        }
        if (c == '?') {
            this.state = State.PROCESSING_INSTRUCTION_CLOSED;
            return true;
        }
        return true;
    }

    private boolean readAttributeName(int i, SynchronizationPoint<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        char c = (char)i;
        XMLStreamEvents.Attribute a = this.event.attributes.getLast();
        if (XMLStreamReaderAsync.isNameChar(c)) {
            a.text.append(c);
            return true;
        }
        i = a.text.indexOf(':');
        if (i < 0) {
            a.namespacePrefix = new UnprotectedStringBuffer();
            a.localName = a.text;
        } else {
            a.namespacePrefix = a.text.substring(0, i);
            a.localName = a.text.substring(i + 1);
        }
        this.state = State.ATTRIBUTE_NAME_SPACE;
        return this.readAttributeNameSpace(c, sp);
    }

    private boolean readAttributeNameSpace(int i, SynchronizationPoint<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        char c = (char)i;
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            return true;
        }
        if (c == '=') {
            this.state = State.ATTRIBUTE_VALUE_SPACE;
            return true;
        }
        this.state = State.START_ELEMENT_SPACE;
        this.stream.back(c);
        return true;
    }

    private boolean readAttributeValueSpace(int i, SynchronizationPoint<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        char c = (char)i;
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            return true;
        }
        if (c == '\"') {
            this.state = State.ATTRIBUTE_VALUE;
            this.statePos = 1;
            XMLStreamEvents.Attribute a = this.event.attributes.getLast();
            a.value = new UnprotectedStringBuffer();
            return true;
        }
        if (c == '\'') {
            this.state = State.ATTRIBUTE_VALUE;
            this.statePos = 2;
            XMLStreamEvents.Attribute a = this.event.attributes.getLast();
            a.value = new UnprotectedStringBuffer();
            return true;
        }
        sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c)));
        return false;
    }

    private boolean readAttributeValue(int i, SynchronizationPoint<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        char c = (char)i;
        XMLStreamEvents.Attribute a = this.event.attributes.getLast();
        if (c == '\"' && this.statePos == 1) {
            XMLStreamReaderAsync.resolveReferences(a.value);
            this.state = State.START_ELEMENT_SPACE;
            return true;
        }
        if (c == '\'' && this.statePos == 2) {
            XMLStreamReaderAsync.resolveReferences(a.value);
            this.state = State.START_ELEMENT_SPACE;
            return true;
        }
        if (c == '<') {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected character", Character.valueOf(c)), new LocalizableString("lc.xml.error", "in attribute value", new Object[0])));
            return false;
        }
        if (c == '\n') {
            a.value.append(' ');
        } else {
            if (c == '\r') {
                return true;
            }
            a.value.append(c);
        }
        return true;
    }

    private boolean readProcessingInstruction(int i, SynchronizationPoint<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        char c = (char)i;
        if (this.event.text.length() == 0) {
            if (!XMLStreamReaderAsync.isNameStartChar(c)) {
                sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c)));
                return false;
            }
            this.event.text.append(c);
            return true;
        }
        if (XMLStreamReaderAsync.isNameChar(c)) {
            this.event.text.append(c);
            return true;
        }
        this.state = State.START_ELEMENT_SPACE;
        return this.readStartElementSpace(i, sp);
    }

    private boolean readProcessingInstructionClosed(int c, SynchronizationPoint<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        if (c != 62) {
            this.stream.back((char)c);
            this.state = State.START_ELEMENT_SPACE;
            return true;
        }
        sp.unblock();
        return false;
    }

    private boolean readChars(int i, SynchronizationPoint<Exception> sp) {
        if (i == -1) {
            this.event.text.replace((CharSequence)"\r\n", (CharSequence)"\n");
            XMLStreamReaderAsync.resolveReferences(this.event.text);
            sp.unblock();
            return false;
        }
        char c = (char)i;
        if (c == '<') {
            this.stream.back(c);
            this.event.text.replace((CharSequence)"\r\n", (CharSequence)"\n");
            XMLStreamReaderAsync.resolveReferences(this.event.text);
            sp.unblock();
            return false;
        }
        this.event.text.append(c);
        if (this.maxTextSize > 0 && this.event.text.length() >= this.maxTextSize) {
            this.event.text.replace((CharSequence)"\r\n", (CharSequence)"\n");
            XMLStreamReaderAsync.resolveReferences(this.event.text);
            sp.unblock();
            return false;
        }
        return true;
    }

    private boolean readEndElementName(int i, SynchronizationPoint<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in XML document", new Object[0])));
            return false;
        }
        char c = (char)i;
        if (this.event.text.length() == 0) {
            if (!XMLStreamReaderAsync.isNameStartChar(c)) {
                sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c)));
                return false;
            }
            this.event.text.append(c);
            this.statePos = 0;
            return true;
        }
        if (c == '>') {
            XMLStreamEvents.ElementContext ctx = this.event.context.peekFirst();
            if (ctx == null) {
                sp.error(new XMLException(this.getPosition(), "Unexpected end element", this.event.text.asString()));
                return false;
            }
            if (!ctx.text.equals(this.event.text)) {
                sp.error(new XMLException(this.getPosition(), "Unexpected end element expected is", this.event.text.asString(), ctx.text.asString()));
                return false;
            }
            i = this.event.text.indexOf(':');
            if (i < 0) {
                this.event.namespacePrefix = new UnprotectedStringBuffer();
                this.event.localName = this.event.text;
            } else {
                this.event.namespacePrefix = this.event.text.substring(0, i);
                this.event.localName = this.event.text.substring(i + 1);
            }
            this.event.namespaceURI = this.getNamespaceURI(this.event.namespacePrefix);
            sp.unblock();
            return false;
        }
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            this.statePos = 1;
            return true;
        }
        if (this.statePos != 0 || !XMLStreamReaderAsync.isNameChar(c)) {
            sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c)));
            return false;
        }
        this.event.text.append(c);
        return true;
    }

    private static void resolveReferences(UnprotectedStringBuffer s) {
        int j;
        int i;
        int pos = 0;
        while ((i = s.indexOf('&', pos)) != -1 && (j = s.indexOf(';', i + 1)) >= 0) {
            int c;
            if (s.charAt(i + 1) == '#') {
                INumberEncoding n;
                pos = i;
                if (s.charAt(i + 2) == 'x') {
                    n = new HexadecimalNumber();
                    i += 3;
                } else {
                    n = new DecimalNumber();
                    i += 2;
                }
                while (i < j) {
                    n.addChar(s.charAt(i++));
                }
                char[] chars = Character.toChars((int)n.getNumber());
                s.replace(pos, j, chars);
                pos += chars.length;
                continue;
            }
            UnprotectedStringBuffer name = s.substring(i + 1, j);
            if (name.equals("amp")) {
                c = 38;
            } else if (name.equals("apos")) {
                c = 39;
            } else if (name.equals("lt")) {
                c = 60;
            } else if (name.equals("gt")) {
                c = 62;
            } else if (name.equals("quot")) {
                c = 34;
            } else {
                pos = i + 1;
                continue;
            }
            s.replace(i, j, (char)c);
            pos = i + 1;
        }
    }

    private boolean readInternalSubset(int i, SynchronizationPoint<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in internal subset declaration", new Object[0])));
            return false;
        }
        char c = (char)i;
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            return true;
        }
        if (c == ']') {
            this.state = State.DOCTYPE_SPACE;
            return true;
        }
        if (c == '%') {
            this.state = State.DOCTYPE_INTERNAL_SUBSET_PEREFERENCE;
            this.statePos = 0;
            return true;
        }
        if (c != '<') {
            sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c)));
            return false;
        }
        this.state = State.DOCTYPE_INTERNAL_SUBSET_TAG;
        this.statePos = 0;
        return true;
    }

    private boolean readInternalSubsetPEReference(int i, SynchronizationPoint<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in internal subset declaration", new Object[0])));
            return false;
        }
        char c = (char)i;
        if (this.statePos == 0) {
            if (!XMLStreamReaderAsync.isNameStartChar(c)) {
                sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c)));
                return false;
            }
            this.statePos = 1;
            return true;
        }
        if (this.statePos == 1) {
            if (XMLStreamReaderAsync.isNameChar(c)) {
                return true;
            }
            if (XMLStreamReaderAsync.isSpaceChar(c)) {
                this.statePos = 2;
                return true;
            }
            if (c == ';') {
                this.state = State.DOCTYPE_INTERNAL_SUBSET;
                return true;
            }
            sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c)));
            return false;
        }
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            return true;
        }
        if (c == ';') {
            this.state = State.DOCTYPE_INTERNAL_SUBSET;
            return true;
        }
        sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c)));
        return false;
    }

    private boolean readInternalSubsetTag(int i, SynchronizationPoint<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException(this.getPosition(), new LocalizableString("lc.xml.error", "Unexpected end", new Object[0]), new LocalizableString("lc.xml.error", "in internal subset declaration", new Object[0])));
            return false;
        }
        char c = (char)i;
        if (this.statePos == 0) {
            if (c == '!') {
                this.statePos = 1;
                return true;
            }
            if (c == '?') {
                this.statePos = 10;
                return true;
            }
            sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c)));
            return false;
        }
        if (this.statePos == 1) {
            if (c == '-') {
                this.statePos = 2;
                return true;
            }
            this.statePos = 10;
            return true;
        }
        if (this.statePos == 2) {
            this.statePos = c == '-' ? 3 : 10;
            return true;
        }
        if (this.statePos == 3) {
            if (c == '-') {
                this.statePos = 4;
            }
            return true;
        }
        if (this.statePos == 4) {
            this.statePos = c == '-' ? 5 : 3;
            return true;
        }
        if (this.statePos == 5) {
            if (c == '>') {
                this.state = State.DOCTYPE_INTERNAL_SUBSET;
                return true;
            }
            if (c != '-') {
                this.statePos = 3;
            }
            return true;
        }
        if (this.statePos == 10) {
            if (c == '>') {
                this.state = State.DOCTYPE_INTERNAL_SUBSET;
                return true;
            }
            if (c == '\"') {
                this.statePos = 11;
            }
            return true;
        }
        if (this.statePos == 11) {
            if (c == '\"') {
                this.statePos = 10;
            }
            return true;
        }
        sp.error(new XMLException(this.getPosition(), "Unexpected character", Character.valueOf(c)));
        return false;
    }

    private static boolean isNameStartChar(char c) {
        if (c < '\u00f8') {
            if (c < ':') {
                return false;
            }
            if (c < '\u00c0') {
                if (c == ':' || c == '_') {
                    return true;
                }
                if (c >= 'a' && c <= 'z') {
                    return true;
                }
                return c >= 'A' && c <= 'Z';
            }
            if (c == '\u00d7') {
                return false;
            }
            return c != '\u00f7';
        }
        if (c < '\u2000') {
            if (c >= '\u0300' && c <= '\u036f') {
                return false;
            }
            return c != '\u037e';
        }
        if (c < '\ud800') {
            if (c <= '\u3000') {
                if (c < '\u2070') {
                    return c != '\u200c' && c != '\u200d';
                }
                if (c < '\u2190') {
                    return true;
                }
                if (c < '\u2c00') {
                    return false;
                }
                if (c > '\u2fef') {
                    return false;
                }
            }
            return true;
        }
        if (c >= '\ue000') {
            if (c < '\uf900') {
                return false;
            }
            if (c <= '\ufdcf') {
                return true;
            }
            if (c < '\ufdf0') {
                return false;
            }
            return c <= '\ufffd';
        }
        return c < '\udc00';
    }

    private static boolean isNameChar(char c) {
        if (c < '\u00f8') {
            if (c < ':') {
                if (c < '-') {
                    return false;
                }
                return c != '/';
            }
            if (c < '\u00c0') {
                if (c == ':' || c == '_') {
                    return true;
                }
                if (c >= 'a' && c <= 'z') {
                    return true;
                }
                if (c >= 'A' && c <= 'Z') {
                    return true;
                }
                return c == '\u00b7';
            }
            if (c == '\u00d7') {
                return false;
            }
            return c != '\u00f7';
        }
        if (c < '\u2000') {
            return c != '\u037e';
        }
        if (c < '\ud800') {
            if (c <= '\u3000') {
                if (c < '\u2070') {
                    return c != '\u200c' && c != '\u200d' && c != '\u203f' && c != '\u2040';
                }
                if (c < '\u2190') {
                    return true;
                }
                if (c < '\u2c00') {
                    return false;
                }
                if (c > '\u2fef') {
                    return false;
                }
            }
            return true;
        }
        if (c >= '\ue000') {
            if (c < '\uf900') {
                return false;
            }
            if (c <= '\ufdcf') {
                return true;
            }
            if (c < '\ufdf0') {
                return false;
            }
            return c <= '\ufffd';
        }
        return true;
    }

    private static enum State {
        START,
        TAG,
        TAG_EXCLAMATION,
        PROCESSING_INSTRUCTION,
        PROCESSING_INSTRUCTION_CLOSED,
        END_ELEMENT_NAME,
        START_ELEMENT_NAME,
        START_ELEMENT_SPACE,
        START_ELEMENT_CLOSED,
        ATTRIBUTE_NAME,
        ATTRIBUTE_NAME_SPACE,
        ATTRIBUTE_VALUE_SPACE,
        ATTRIBUTE_VALUE,
        COMMENT,
        CDATA,
        DOCTYPE,
        DOCTYPE_NAME,
        DOCTYPE_SPACE,
        DOCTYPE_PUBLIC_NAME,
        DOCTYPE_PUBLIC_SPACE,
        DOCTYPE_PUBLIC_ID,
        DOCTYPE_SYSTEM_NAME,
        DOCTYPE_SYSTEM_SPACE,
        DOCTYPE_SYSTEM_VALUE,
        DOCTYPE_INTERNAL_SUBSET,
        DOCTYPE_INTERNAL_SUBSET_PEREFERENCE,
        DOCTYPE_INTERNAL_SUBSET_TAG,
        CHARS;

    }
}

