/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.serialization;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.SimpleBufferedWritable;
import net.lecousin.framework.io.encoding.Base64;
import net.lecousin.framework.io.serialization.AbstractSerializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.util.UnprotectedString;
import net.lecousin.framework.xml.XMLWriter;
import net.lecousin.framework.xml.serialization.XMLCustomSerialization;
import net.lecousin.framework.xml.serialization.XMLDeserializer;

public class XMLSerializer
extends AbstractSerializer {
    protected String rootNamespaceURI;
    protected String rootLocalName;
    protected Map<String, String> namespaces;
    protected Charset encoding;
    protected int bufferSize;
    protected boolean includeXMLDeclaration;
    protected IO.Writable.Buffered bout;
    protected XMLWriter output;
    protected static final Comparator<SerializationClass.Attribute> attributesComparator = new Comparator<SerializationClass.Attribute>(){

        @Override
        public int compare(SerializationClass.Attribute o1, SerializationClass.Attribute o2) {
            Class<?> c = o1.getType().getBase();
            if (c.isPrimitive()) {
                return -1;
            }
            if (Boolean.class.equals(c)) {
                return -1;
            }
            if (Number.class.isAssignableFrom(c)) {
                return -1;
            }
            if (String.class.equals(c)) {
                return -1;
            }
            if (c.isEnum()) {
                return -1;
            }
            c = o2.getType().getBase();
            if (c.isPrimitive()) {
                return 1;
            }
            if (Boolean.class.equals(c)) {
                return 1;
            }
            if (Number.class.isAssignableFrom(c)) {
                return 1;
            }
            if (String.class.equals(c)) {
                return 1;
            }
            if (c.isEnum()) {
                return 1;
            }
            return 0;
        }
    };

    public XMLSerializer(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces) {
        this(rootNamespaceURI, rootLocalName, namespaces, null);
    }

    public XMLSerializer(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, boolean includeXMLDeclaration) {
        this(rootNamespaceURI, rootLocalName, namespaces, null, includeXMLDeclaration);
    }

    public XMLSerializer(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding) {
        this(rootNamespaceURI, rootLocalName, namespaces, encoding, 4096);
    }

    public XMLSerializer(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding, boolean includeXMLDeclaration) {
        this(rootNamespaceURI, rootLocalName, namespaces, encoding, 4096, includeXMLDeclaration);
    }

    public XMLSerializer(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding, int bufferSize) {
        this(rootNamespaceURI, rootLocalName, namespaces, encoding, bufferSize, true);
    }

    public XMLSerializer(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding, int bufferSize, boolean includeXMLDeclaration) {
        this.rootNamespaceURI = rootNamespaceURI;
        this.rootLocalName = rootLocalName;
        this.namespaces = namespaces;
        this.encoding = encoding;
        this.bufferSize = bufferSize;
        this.includeXMLDeclaration = includeXMLDeclaration;
    }

    public XMLSerializer(XMLWriter writer) {
        this.output = writer;
    }

    protected ISynchronizationPoint<IOException> initializeSerialization(IO.Writable output) {
        this.bout = output instanceof IO.Writable.Buffered ? (IO.Writable.Buffered)output : new SimpleBufferedWritable(output, this.bufferSize);
        this.output = new XMLWriter(this.bout, this.encoding, this.includeXMLDeclaration);
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        if (!this.namespaces.containsKey("http://www.w3.org/2001/XMLSchema-instance")) {
            this.namespaces.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        }
        return this.output.start(this.rootNamespaceURI, this.rootLocalName, this.namespaces);
    }

    @Override
    protected ISynchronizationPoint<? extends Exception> finalizeSerialization() {
        SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        this.output.end().listenInlineSP(() -> this.bout.flush().listenInlineSP(sp), sp);
        return sp;
    }

    protected ISynchronizationPoint<IOException> serializeBooleanValue(boolean value) {
        return this.output.addText(Boolean.toString(value));
    }

    protected ISynchronizationPoint<IOException> serializeNullValue() {
        return this.output.addAttribute("xsi:nil", "true");
    }

    protected ISynchronizationPoint<IOException> serializeCharacterValue(char value) {
        return this.output.addText(new String(new char[]{value}));
    }

    protected ISynchronizationPoint<IOException> serializeNumericValue(Number value) {
        return this.output.addText(value.toString());
    }

    protected ISynchronizationPoint<IOException> serializeStringValue(CharSequence value) {
        return this.output.addText(value);
    }

    protected ISynchronizationPoint<IOException> startCollectionValue(SerializationContext.CollectionContext context, String path, List<SerializationRule> rules) {
        return this.output.endOfAttributes();
    }

    protected ISynchronizationPoint<IOException> startCollectionValueElement(SerializationContext.CollectionContext context, Object element, int elementIndex, String elementPath, List<SerializationRule> rules) {
        return this.output.openElement(null, "element", null);
    }

    @Override
    protected ISynchronizationPoint<? extends Exception> endCollectionValueElement(SerializationContext.CollectionContext context, Object element, int elementIndex, String elementPath, List<SerializationRule> rules) {
        return this.output.closeElement();
    }

    protected ISynchronizationPoint<IOException> endCollectionValue(SerializationContext.CollectionContext context, String path, List<SerializationRule> rules) {
        return new SynchronizationPoint<boolean>(true);
    }

    @Override
    protected List<SerializationClass.Attribute> sortAttributes(List<SerializationClass.Attribute> attributes) {
        attributes.sort(attributesComparator);
        return attributes;
    }

    protected ISynchronizationPoint<IOException> startObjectValue(SerializationContext.ObjectContext context, String path, List<SerializationRule> rules) {
        Object instance = context.getInstance();
        if (instance != null) {
            Class<?> type;
            boolean customInstantiator = false;
            for (SerializationRule rule : rules) {
                if (!rule.canInstantiate(context.getOriginalType(), context)) continue;
                customInstantiator = true;
                break;
            }
            if (!(customInstantiator || context.getParent() instanceof SerializationContext.AttributeContext && ((SerializationContext.AttributeContext)context.getParent()).getAttribute().hasCustomInstantiation() || (type = context.getOriginalType().getBase()).equals(instance.getClass()))) {
                String attrName = "class";
                while (XMLDeserializer.hasAttribute(type, attrName)) {
                    attrName = "_" + attrName;
                }
                return this.output.addAttribute(attrName, instance.getClass().getName());
            }
        }
        return new SynchronizationPoint<boolean>(true);
    }

    protected ISynchronizationPoint<IOException> endObjectValue(SerializationContext.ObjectContext context, String path, List<SerializationRule> rules) {
        return new SynchronizationPoint<boolean>(true);
    }

    protected ISynchronizationPoint<IOException> serializeNullAttribute(SerializationContext.AttributeContext context, String path) {
        Class<?> c = context.getAttribute().getType().getBase();
        if (c.isPrimitive() || Boolean.class.equals(c) || Number.class.isAssignableFrom(c) || String.class.equals(c) || c.isEnum()) {
            return new SynchronizationPoint<boolean>(true);
        }
        this.output.openElement(null, context.getAttribute().getName(), null);
        this.output.addAttribute("xsi:nil", "true");
        return this.output.closeElement();
    }

    protected ISynchronizationPoint<IOException> serializeBooleanAttribute(SerializationContext.AttributeContext context, boolean value, String path) {
        return this.output.addAttribute(context.getAttribute().getName(), Boolean.toString(value));
    }

    protected ISynchronizationPoint<IOException> serializeNumericAttribute(SerializationContext.AttributeContext context, Number value, String path) {
        return this.output.addAttribute(context.getAttribute().getName(), value.toString());
    }

    protected ISynchronizationPoint<IOException> serializeCharacterAttribute(SerializationContext.AttributeContext context, char value, String path) {
        return this.output.addAttribute(context.getAttribute().getName(), new UnprotectedString(value));
    }

    protected ISynchronizationPoint<IOException> serializeStringAttribute(SerializationContext.AttributeContext context, CharSequence value, String path) {
        return this.output.addAttribute(context.getAttribute().getName(), value);
    }

    @Override
    protected ISynchronizationPoint<? extends Exception> serializeObjectAttribute(SerializationContext.AttributeContext context, Object value, String path, List<SerializationRule> rules) {
        this.output.openElement(null, context.getAttribute().getName(), null);
        ISynchronizationPoint<? extends Exception> s = this.serializeObjectValue(context, value, context.getAttribute().getType(), path + '.' + context.getAttribute().getName(), rules);
        if (s.isUnblocked()) {
            if (s.hasError()) {
                return s;
            }
            return this.output.closeElement();
        }
        SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        s.listenAsyncSP(new AbstractSerializer.SerializationTask(() -> this.output.closeElement().listenInlineSP(sp)), sp);
        return sp;
    }

    @Override
    protected ISynchronizationPoint<? extends Exception> serializeCollectionAttribute(SerializationContext.CollectionContext context, String path, List<SerializationRule> rules) {
        SynchronizationPoint<Exception> result = new SynchronizationPoint<Exception>();
        this.serializeCollectionAttributeElement(context, context.getIterator(), 0, path + '.' + ((SerializationContext.AttributeContext)context.getParent()).getAttribute().getName(), rules, result);
        return result;
    }

    protected void serializeCollectionAttributeElement(SerializationContext.CollectionContext context, Iterator<?> it, int elementIndex, String colPath, List<SerializationRule> rules, SynchronizationPoint<Exception> result) {
        if (!it.hasNext()) {
            result.unblock();
            return;
        }
        Object element = it.next();
        String elementPath = colPath + '[' + elementIndex + ']';
        SerializationClass.Attribute colAttr = ((SerializationContext.AttributeContext)context.getParent()).getAttribute();
        this.output.openElement(null, colAttr.getName(), null);
        ISynchronizationPoint<? extends Exception> value = this.serializeValue(context, element, context.getElementType(), elementPath, rules);
        if (value.isUnblocked()) {
            if (value.hasError()) {
                result.error(value.getError());
            } else {
                this.output.closeElement();
                this.serializeCollectionAttributeElement(context, it, elementIndex + 1, colPath, rules, result);
            }
            return;
        }
        value.listenAsyncSP(new AbstractSerializer.SerializationTask(() -> {
            this.output.closeElement();
            this.serializeCollectionAttributeElement(context, it, elementIndex + 1, colPath, rules, result);
        }), result);
    }

    protected ISynchronizationPoint<IOException> serializeIOReadableValue(SerializationContext context, IO.Readable io, String path, List<SerializationRule> rules) {
        ISynchronizationPoint<IOException> encode = Base64.encodeAsync(io, new ICharacterStream.WriterAsync(){

            @Override
            public ISynchronizationPoint<IOException> writeAsync(char[] c, int offset, int length) {
                return XMLSerializer.this.output.addText(new UnprotectedString(c, offset, length, c.length));
            }
        });
        if (encode.isUnblocked()) {
            if (encode.hasError()) {
                return encode;
            }
            return this.output.closeElement();
        }
        SynchronizationPoint<IOException> sp = new SynchronizationPoint<IOException>();
        encode.listenAsync(new AbstractSerializer.SerializationTask(() -> this.output.closeElement().listenInline(sp)), sp);
        return sp;
    }

    protected ISynchronizationPoint<IOException> serializeIOReadableAttribute(SerializationContext.AttributeContext context, IO.Readable io, String path, List<SerializationRule> rules) {
        this.output.openElement(null, context.getAttribute().getName(), null);
        return this.serializeIOReadableValue(context, io, path, rules);
    }

    @Override
    protected ISynchronizationPoint<? extends Exception> serializeAttribute(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        Object value;
        XMLCustomSerialization custom = context.getAttribute().getAnnotation(false, XMLCustomSerialization.class);
        if (custom == null) {
            return super.serializeAttribute(context, path, rules);
        }
        try {
            value = context.getAttribute().getValue(context.getParent().getInstance());
        }
        catch (Exception e) {
            return new SynchronizationPoint<Exception>(new Exception("Unable to get value of attribute " + context.getAttribute().getOriginalName() + " on " + context.getAttribute().getOriginalType().getClass().getName(), e));
        }
        if (value == null) {
            return this.serializeNullAttribute(context, path);
        }
        try {
            return custom.value().newInstance().serialize(value, this, this.output, rules);
        }
        catch (Exception e) {
            return new SynchronizationPoint<Exception>(e);
        }
    }
}

