/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.serialization;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.SimpleBufferedWritable;
import net.lecousin.framework.io.serialization.AbstractSerializationSpecWriter;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.xml.XMLWriter;

public class XMLSpecWriter
extends AbstractSerializationSpecWriter {
    protected String rootNamespaceURI;
    protected String rootLocalName;
    protected Map<String, String> namespaces;
    protected Charset encoding;
    protected int bufferSize;
    protected boolean includeXMLDeclaration;
    protected IO.Writable.Buffered bout;
    protected XMLWriter output;
    private LinkedList<TypeContext> typesContext = new LinkedList();
    protected static final Comparator<SerializationClass.Attribute> attributesComparator = new Comparator<SerializationClass.Attribute>(){

        @Override
        public int compare(SerializationClass.Attribute o1, SerializationClass.Attribute o2) {
            Class<?> c = o1.getType().getBase();
            if (XMLSpecWriter.isAttribute(c)) {
                return 1;
            }
            c = o2.getType().getBase();
            if (XMLSpecWriter.isAttribute(c)) {
                return -1;
            }
            return 0;
        }
    };

    public XMLSpecWriter(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces) {
        this(rootNamespaceURI, rootLocalName, namespaces, StandardCharsets.UTF_8, true);
    }

    public XMLSpecWriter(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, boolean includeXMLDeclaration) {
        this(rootNamespaceURI, rootLocalName, namespaces, StandardCharsets.UTF_8, includeXMLDeclaration);
    }

    public XMLSpecWriter(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding) {
        this(rootNamespaceURI, rootLocalName, namespaces, encoding, 4096, true);
    }

    public XMLSpecWriter(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding, boolean includeXMLDeclaration) {
        this(rootNamespaceURI, rootLocalName, namespaces, encoding, 4096, includeXMLDeclaration);
    }

    public XMLSpecWriter(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding, int bufferSize) {
        this(rootNamespaceURI, rootLocalName, namespaces, encoding, bufferSize, true);
    }

    public XMLSpecWriter(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding, int bufferSize, boolean includeXMLDeclaration) {
        this.rootNamespaceURI = rootNamespaceURI;
        this.rootLocalName = rootLocalName;
        this.namespaces = namespaces;
        this.encoding = encoding;
        this.bufferSize = bufferSize;
        this.includeXMLDeclaration = includeXMLDeclaration;
    }

    protected ISynchronizationPoint<IOException> initializeSpecWriter(IO.Writable output) {
        this.bout = output instanceof IO.Writable.Buffered ? (IO.Writable.Buffered)output : new SimpleBufferedWritable(output, this.bufferSize);
        this.output = new XMLWriter(this.bout, this.encoding, this.includeXMLDeclaration);
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        if (!this.namespaces.containsKey("http://www.w3.org/2001/XMLSchema-instance")) {
            this.namespaces.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        }
        if (!this.namespaces.containsKey("http://www.w3.org/2001/XMLSchema")) {
            this.namespaces.put("http://www.w3.org/2001/XMLSchema", "xsd");
        }
        this.output.start("http://www.w3.org/2001/XMLSchema", "schema", this.namespaces);
        this.output.addAttribute("targetNamespace", this.rootNamespaceURI);
        this.output.openElement("http://www.w3.org/2001/XMLSchema", "element", null);
        return this.output.addAttribute("name", this.rootLocalName);
    }

    protected ISynchronizationPoint<IOException> finalizeSpecWriter() {
        SynchronizationPoint<IOException> sp = new SynchronizationPoint<IOException>();
        this.output.end().listenInline(() -> this.bout.flush().listenInline(sp), sp);
        return sp;
    }

    protected ISynchronizationPoint<IOException> specifyBooleanValue(boolean nullable) {
        this.output.addAttribute("type", "xsd:boolean");
        if (nullable) {
            this.output.addAttribute("nillable", "true");
        }
        return this.output.closeElement();
    }

    protected ISynchronizationPoint<IOException> specifyNumericValue(Class<?> type, boolean nullable, Number min, Number max) {
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            this.output.addAttribute("type", "xsd:byte");
        } else if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            this.output.addAttribute("type", "xsd:int");
        } else if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            this.output.addAttribute("type", "xsd:long");
        } else if (Short.TYPE.equals(type) || Short.class.equals(type) || BigInteger.class.equals(type)) {
            this.output.addAttribute("type", "xsd:integer");
        } else {
            this.output.addAttribute("type", "xsd:decimal");
        }
        if (nullable) {
            this.output.addAttribute("nillable", "true");
        }
        return this.output.closeElement();
    }

    @Override
    protected ISynchronizationPoint<? extends Exception> specifyStringValue(SerializationContext context, TypeDefinition type) {
        this.output.addAttribute("type", "xsd:string");
        return this.output.closeElement();
    }

    public static String getTypeName(Class<?> type) {
        return type.getName().replace('$', '-');
    }

    @Override
    protected ISynchronizationPoint<? extends Exception> specifyAnyValue(SerializationContext context) {
        this.output.endOfAttributes();
        this.output.openElement("http://www.w3.org/2001/XMLSchema", "complexType", null);
        this.output.openElement("http://www.w3.org/2001/XMLSchema", "sequence", null);
        this.output.openElement("http://www.w3.org/2001/XMLSchema", "any", null);
        this.output.addAttribute("minOccurs", "0");
        this.output.closeElement();
        this.output.closeElement();
        this.output.closeElement();
        return this.output.closeElement();
    }

    @Override
    protected ISynchronizationPoint<? extends Exception> specifyTypedValue(SerializationContext.ObjectContext context, List<SerializationRule> rules) {
        this.output.endOfAttributes();
        this.output.openElement("http://www.w3.org/2001/XMLSchema", "complexType", null);
        TypeContext ctx = new TypeContext();
        this.typesContext.addFirst(ctx);
        ISynchronizationPoint<? extends Exception> type = this.specifyTypeContent(context, rules);
        if (type.isUnblocked()) {
            if (type.hasError()) {
                return type;
            }
            this.typesContext.removeFirst();
            if (ctx.sequenceStarted) {
                this.output.closeElement();
            }
            this.output.closeElement();
            return this.output.closeElement();
        }
        SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        type.listenAsyncSP(new AbstractSerializationSpecWriter.SpecTask(() -> {
            this.typesContext.removeFirst();
            if (ctx.sequenceStarted) {
                this.output.closeElement();
            }
            this.output.closeElement();
            this.output.closeElement().listenInlineSP(sp);
        }), sp);
        return sp;
    }

    protected static final boolean isAttribute(Class<?> c) {
        if (c.isPrimitive()) {
            return true;
        }
        if (Boolean.class.equals(c)) {
            return true;
        }
        if (Number.class.isAssignableFrom(c)) {
            return true;
        }
        if (String.class.equals(c)) {
            return true;
        }
        return c.isEnum();
    }

    @Override
    protected List<SerializationClass.Attribute> sortAttributes(List<SerializationClass.Attribute> attributes) {
        attributes.sort(attributesComparator);
        return attributes;
    }

    @Override
    protected ISynchronizationPoint<? extends Exception> specifyTypeAttribute(SerializationContext.AttributeContext context, List<SerializationRule> rules) {
        SerializationClass.Attribute a = context.getAttribute();
        Class<?> type = a.getType().getBase();
        TypeContext ctx = this.typesContext.getFirst();
        if (XMLSpecWriter.isAttribute(type)) {
            if (ctx.sequenceStarted) {
                this.output.closeElement();
                ctx.sequenceStarted = false;
            }
            this.output.openElement("http://www.w3.org/2001/XMLSchema", "attribute", null);
            this.output.addAttribute("name", a.getName());
            return this.specifyValue(context, a.getType(), rules);
        }
        if (!ctx.sequenceStarted) {
            this.output.openElement("http://www.w3.org/2001/XMLSchema", "sequence", null);
            ctx.sequenceStarted = true;
        }
        this.output.openElement("http://www.w3.org/2001/XMLSchema", "element", null);
        this.output.addAttribute("name", a.getName());
        return this.specifyValue(context, a.getType(), rules);
    }

    private static class TypeContext {
        public boolean sequenceStarted = false;

        private TypeContext() {
        }
    }
}

