/*
 * Decompiled with CFR 0.152.
 */
package net.maffoo.jsonquote.literal;

import java.io.Serializable;
import net.maffoo.jsonquote.JsonError;
import net.maffoo.jsonquote.Lex$;
import net.maffoo.jsonquote.Pos;
import net.maffoo.jsonquote.Token;
import net.maffoo.jsonquote.Token$ARRAY_END$;
import net.maffoo.jsonquote.Token$ARRAY_START$;
import net.maffoo.jsonquote.Token$COLON$;
import net.maffoo.jsonquote.Token$COMMA$;
import net.maffoo.jsonquote.Token$EOF$;
import net.maffoo.jsonquote.Token$FALSE$;
import net.maffoo.jsonquote.Token$NULL$;
import net.maffoo.jsonquote.Token$OBJECT_END$;
import net.maffoo.jsonquote.Token$OBJECT_START$;
import net.maffoo.jsonquote.Token$OPTIONAL$;
import net.maffoo.jsonquote.Token$REPEAT$;
import net.maffoo.jsonquote.Token$SPLICE$;
import net.maffoo.jsonquote.Token$TRUE$;
import net.maffoo.jsonquote.Util$;
import net.maffoo.jsonquote.literal.Chunk;
import net.maffoo.jsonquote.literal.Json$;
import net.maffoo.jsonquote.literal.Segment;
import net.maffoo.jsonquote.literal.SpliceField$;
import net.maffoo.jsonquote.literal.SpliceFieldName$;
import net.maffoo.jsonquote.literal.SpliceFieldNameOpt$;
import net.maffoo.jsonquote.literal.SpliceFieldOpt;
import net.maffoo.jsonquote.literal.SpliceFields$;
import net.maffoo.jsonquote.literal.SpliceValue$;
import net.maffoo.jsonquote.literal.SpliceValues$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class Parse$ {
    public static Parse$ MODULE$;

    static {
        new Parse$();
    }

    public String coalesce(Seq<String> segments) {
        Iterator it = segments.iterator();
        StringBuilder b = new StringBuilder();
        while (it.hasNext()) {
            StringBuilder stringBuilder;
            String s = (String)it.next();
            if (b.nonEmpty() && Parse$.isOpener$1(BoxesRunTime.unboxToChar((Object)b.last())) && new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty() && Parse$.isComma$1(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(s)).head()))) {
                stringBuilder = b.append((String)new StringOps(Predef$.MODULE$.augmentString(s)).drop(1));
                continue;
            }
            if (b.nonEmpty() && Parse$.isComma$1(BoxesRunTime.unboxToChar((Object)b.last())) && new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty() && Parse$.isCommaOrCloser$1(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(s)).head()))) {
                b.deleteCharAt(b.length() - 1);
                stringBuilder = b.append(s);
                continue;
            }
            stringBuilder = b.append(s);
        }
        return b.toString();
    }

    public Seq<Segment> apply(Seq<String> s) {
        return this.apply(Lex$.MODULE$.apply(s));
    }

    public Seq<Segment> apply(Iterator<Tuple2<Token, Pos>> it) {
        BufferedIterator segments = this.parseValue((BufferedIterator<Tuple2<Token, Pos>>)it.buffered()).buffered();
        Util$.MODULE$.expect(Token$EOF$.MODULE$, it);
        Builder out = package$.MODULE$.IndexedSeq().newBuilder();
        while (segments.hasNext()) {
            Builder builder;
            Segment segment = (Segment)segments.head();
            if (segment instanceof Chunk) {
                StringBuilder chunk = new StringBuilder();
                while (segments.hasNext() && segments.head() instanceof Chunk) {
                    chunk.$plus$plus$eq(((Chunk)segments.next()).s());
                }
                builder = out.$plus$eq((Object)new Chunk(chunk.toString()));
                continue;
            }
            builder = out.$plus$eq(segments.next());
        }
        return (Seq)out.result();
    }

    public Iterator<Segment> parseValue(BufferedIterator<Tuple2<Token, Pos>> it) {
        Iterator iterator;
        Tuple2 tuple2 = (Tuple2)it.head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Token tok = (Token)tuple2._1();
        Pos pos = (Pos)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tok, (Object)pos);
        Tuple2 tuple23 = tuple22;
        Token tok2 = (Token)tuple23._1();
        Pos pos2 = (Pos)tuple23._2();
        Token token = tok2;
        if (Token$OBJECT_START$.MODULE$.equals(token)) {
            iterator = this.parseObject(it);
        } else if (Token$ARRAY_START$.MODULE$.equals(token)) {
            iterator = this.parseArray(it);
        } else if (token instanceof Token.NUMBER) {
            Token.NUMBER nUMBER = (Token.NUMBER)token;
            BigDecimal n = nUMBER.value();
            it.next();
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Chunk[]{new Chunk(n.toString())}));
        } else if (token instanceof Token.STRING) {
            Token.STRING sTRING = (Token.STRING)token;
            String s = sTRING.value();
            it.next();
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Chunk[]{new Chunk(Json$.MODULE$.quoteString(s))}));
        } else if (Token$TRUE$.MODULE$.equals(token)) {
            it.next();
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Chunk[]{new Chunk("true")}));
        } else if (Token$FALSE$.MODULE$.equals(token)) {
            it.next();
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Chunk[]{new Chunk("false")}));
        } else if (Token$NULL$.MODULE$.equals(token)) {
            it.next();
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Chunk[]{new Chunk("null")}));
        } else if (Token$SPLICE$.MODULE$.equals(token)) {
            it.next();
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SpliceValue$[]{SpliceValue$.MODULE$}));
        } else {
            throw new JsonError(new java.lang.StringBuilder(18).append("unexpected token: ").append(token).toString(), pos2);
        }
        return iterator;
    }

    public Iterator<Segment> parseArray(BufferedIterator<Tuple2<Token, Pos>> it) {
        Util$.MODULE$.expect(Token$ARRAY_START$.MODULE$, it);
        Object object = ((Tuple2)it.head())._1();
        Token$ARRAY_END$ token$ARRAY_END$ = Token$ARRAY_END$.MODULE$;
        Iterator<Segment> elems = !(object != null ? !object.equals(token$ARRAY_END$) : token$ARRAY_END$ != null) ? package$.MODULE$.Iterator().empty() : this.parseElements(it);
        Util$.MODULE$.expect(Token$ARRAY_END$.MODULE$, it);
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Chunk[]{new Chunk("[")})).$plus$plus((Function0 & Serializable & scala.Serializable)() -> elems).$plus$plus((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Chunk[]{new Chunk("]")})));
    }

    public Iterator<Segment> parseElements(BufferedIterator<Tuple2<Token, Pos>> it) {
        Builder b = Seq$.MODULE$.newBuilder();
        b.$plus$plus$eq((TraversableOnce)this.advance$1(true, it));
        while (true) {
            Object object = ((Tuple2)it.head())._1();
            Token$ARRAY_END$ token$ARRAY_END$ = Token$ARRAY_END$.MODULE$;
            if (!(object == null ? token$ARRAY_END$ != null : !object.equals(token$ARRAY_END$))) break;
            Util$.MODULE$.expect(Token$COMMA$.MODULE$, it);
            b.$plus$eq((Object)new Chunk(","));
            b.$plus$plus$eq((TraversableOnce)this.advance$1(false, it));
        }
        return ((IterableLike)b.result()).iterator();
    }

    public Iterator<Segment> parseObject(BufferedIterator<Tuple2<Token, Pos>> it) {
        Util$.MODULE$.expect(Token$OBJECT_START$.MODULE$, it);
        Object object = ((Tuple2)it.head())._1();
        Token$OBJECT_END$ token$OBJECT_END$ = Token$OBJECT_END$.MODULE$;
        Iterator<Segment> members = !(object != null ? !object.equals(token$OBJECT_END$) : token$OBJECT_END$ != null) ? package$.MODULE$.Iterator().empty() : this.parseMembers(it);
        Util$.MODULE$.expect(Token$OBJECT_END$.MODULE$, it);
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Chunk[]{new Chunk("{")})).$plus$plus((Function0 & Serializable & scala.Serializable)() -> members).$plus$plus((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Chunk[]{new Chunk("}")})));
    }

    public Iterator<Segment> parseMembers(BufferedIterator<Tuple2<Token, Pos>> it) {
        Builder b = Seq$.MODULE$.newBuilder();
        b.$plus$plus$eq((TraversableOnce)this.advance$2(true, it));
        while (true) {
            Object object = ((Tuple2)it.head())._1();
            Token$OBJECT_END$ token$OBJECT_END$ = Token$OBJECT_END$.MODULE$;
            if (!(object == null ? token$OBJECT_END$ != null : !object.equals(token$OBJECT_END$))) break;
            Util$.MODULE$.expect(Token$COMMA$.MODULE$, it);
            b.$plus$eq((Object)new Chunk(","));
            b.$plus$plus$eq((TraversableOnce)this.advance$2(false, it));
        }
        return ((IterableLike)b.result()).iterator();
    }

    public Iterator<Segment> parsePair(boolean first, BufferedIterator<Tuple2<Token, Pos>> it) {
        Iterator iterator;
        Tuple2 tuple2 = (Tuple2)it.next();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Token tok = (Token)tuple2._1();
        Pos pos = (Pos)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tok, (Object)pos);
        Tuple2 tuple23 = tuple22;
        Token tok2 = (Token)tuple23._1();
        Pos pos2 = (Pos)tuple23._2();
        Token token = tok2;
        if (token instanceof Token.STRING) {
            Iterator iterator2;
            Token.STRING sTRING = (Token.STRING)token;
            String k = sTRING.value();
            Util$.MODULE$.expect(Token$COLON$.MODULE$, it);
            Token token2 = (Token)((Tuple2)it.head())._1();
            if (Token$OPTIONAL$.MODULE$.equals(token2)) {
                it.next();
                Util$.MODULE$.expect(Token$SPLICE$.MODULE$, it);
                iterator2 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SpliceFieldOpt[]{new SpliceFieldOpt(k)}));
            } else {
                iterator2 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Chunk[]{new Chunk(Json$.MODULE$.quoteString(k)), new Chunk(":")})).$plus$plus((Function0 & Serializable & scala.Serializable)() -> MODULE$.parseValue(it));
            }
            iterator = iterator2;
        } else if (token instanceof Token.IDENT) {
            Iterator iterator3;
            Token.IDENT iDENT = (Token.IDENT)token;
            String k = iDENT.value();
            Util$.MODULE$.expect(Token$COLON$.MODULE$, it);
            Token token3 = (Token)((Tuple2)it.head())._1();
            if (Token$OPTIONAL$.MODULE$.equals(token3)) {
                it.next();
                Util$.MODULE$.expect(Token$SPLICE$.MODULE$, it);
                iterator3 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SpliceFieldOpt[]{new SpliceFieldOpt(k)}));
            } else {
                iterator3 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Chunk[]{new Chunk(Json$.MODULE$.quoteString(k)), new Chunk(":")})).$plus$plus((Function0 & Serializable & scala.Serializable)() -> MODULE$.parseValue(it));
            }
            iterator = iterator3;
        } else if (Token$SPLICE$.MODULE$.equals(token)) {
            Iterator iterator4;
            Token token4 = (Token)((Tuple2)it.head())._1();
            if (Token$COLON$.MODULE$.equals(token4)) {
                Iterator iterator5;
                it.next();
                Token token5 = (Token)((Tuple2)it.head())._1();
                if (Token$OPTIONAL$.MODULE$.equals(token5)) {
                    it.next();
                    Util$.MODULE$.expect(Token$SPLICE$.MODULE$, it);
                    iterator5 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SpliceFieldNameOpt$[]{SpliceFieldNameOpt$.MODULE$}));
                } else {
                    iterator5 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{SpliceFieldName$.MODULE$, new Chunk(":")})).$plus$plus((Function0 & Serializable & scala.Serializable)() -> MODULE$.parseValue(it));
                }
                iterator4 = iterator5;
            } else {
                iterator4 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SpliceField$[]{SpliceField$.MODULE$}));
            }
            iterator = iterator4;
        } else {
            throw new JsonError(new java.lang.StringBuilder(23).append("expected field but got ").append(token).toString(), pos2);
        }
        return iterator;
    }

    private static final boolean isComma$1(char c) {
        return c == ',';
    }

    private static final boolean isCommaOrCloser$1(char c) {
        return new StringOps(Predef$.MODULE$.augmentString(",]}")).contains((Object)BoxesRunTime.boxToCharacter((char)c));
    }

    private static final boolean isOpener$1(char c) {
        return new StringOps(Predef$.MODULE$.augmentString("{[")).contains((Object)BoxesRunTime.boxToCharacter((char)c));
    }

    private final Iterator advance$1(boolean first, BufferedIterator it$1) {
        Iterator iterator;
        Object object = ((Tuple2)it$1.head())._1();
        Token$REPEAT$ token$REPEAT$ = Token$REPEAT$.MODULE$;
        if (!(object != null ? !object.equals(token$REPEAT$) : token$REPEAT$ != null)) {
            it$1.next();
            Util$.MODULE$.expect(Token$SPLICE$.MODULE$, it$1);
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SpliceValues$[]{SpliceValues$.MODULE$}));
        } else {
            iterator = this.parseValue((BufferedIterator<Tuple2<Token, Pos>>)it$1);
        }
        return iterator;
    }

    private final Iterator advance$2(boolean first, BufferedIterator it$2) {
        Iterator iterator;
        Object object = ((Tuple2)it$2.head())._1();
        Token$REPEAT$ token$REPEAT$ = Token$REPEAT$.MODULE$;
        if (!(object != null ? !object.equals(token$REPEAT$) : token$REPEAT$ != null)) {
            it$2.next();
            Util$.MODULE$.expect(Token$SPLICE$.MODULE$, it$2);
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SpliceFields$[]{SpliceFields$.MODULE$}));
        } else {
            iterator = this.parsePair(first, (BufferedIterator<Tuple2<Token, Pos>>)it$2);
        }
        return iterator;
    }

    private Parse$() {
        MODULE$ = this;
    }
}

