/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.FastLz;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FastLzFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final int level;
    private final Checksum checksum;

    public FastLzFrameEncoder() {
        this(0, null);
    }

    public FastLzFrameEncoder(int level) {
        this(level, null);
    }

    public FastLzFrameEncoder(boolean validateChecksums) {
        this(0, validateChecksums ? new Adler32() : null);
    }

    public FastLzFrameEncoder(int level, Checksum checksum) {
        super(false);
        if (level != 0 && level != 1 && level != 2) {
            throw new IllegalArgumentException(String.format("level: %d (expected: %d or %d or %d)", level, 0, 1, 2));
        }
        this.level = level;
        this.checksum = checksum;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out2) throws Exception {
        Checksum checksum = this.checksum;
        while (in.isReadable()) {
            int chunkLength;
            int blockType;
            int idx = in.readerIndex();
            int length2 = Math.min(in.readableBytes(), 65535);
            int outputIdx = out2.writerIndex();
            out2.setMedium(outputIdx, 4607066);
            int outputOffset = outputIdx + 4 + (checksum != null ? 4 : 0);
            if (length2 < 32) {
                blockType = 0;
                out2.ensureWritable(outputOffset + 2 + length2);
                byte[] output = out2.array();
                int outputPtr = out2.arrayOffset() + outputOffset + 2;
                if (checksum != null) {
                    int inputPtr;
                    byte[] input2;
                    if (in.hasArray()) {
                        input2 = in.array();
                        inputPtr = in.arrayOffset() + idx;
                    } else {
                        input2 = new byte[length2];
                        in.getBytes(idx, input2);
                        inputPtr = 0;
                    }
                    checksum.reset();
                    checksum.update(input2, inputPtr, length2);
                    out2.setInt(outputIdx + 4, (int)checksum.getValue());
                    System.arraycopy(input2, inputPtr, output, outputPtr, length2);
                } else {
                    in.getBytes(idx, output, outputPtr, length2);
                }
                chunkLength = length2;
            } else {
                int inputPtr;
                byte[] input3;
                if (in.hasArray()) {
                    input3 = in.array();
                    inputPtr = in.arrayOffset() + idx;
                } else {
                    input3 = new byte[length2];
                    in.getBytes(idx, input3);
                    inputPtr = 0;
                }
                if (checksum != null) {
                    checksum.reset();
                    checksum.update(input3, inputPtr, length2);
                    out2.setInt(outputIdx + 4, (int)checksum.getValue());
                }
                int maxOutputLength = FastLz.calculateOutputBufferLength(length2);
                out2.ensureWritable(outputOffset + 4 + maxOutputLength);
                byte[] output = out2.array();
                int outputPtr = out2.arrayOffset() + outputOffset + 4;
                int compressedLength = FastLz.compress(input3, inputPtr, length2, output, outputPtr, this.level);
                if (compressedLength < length2) {
                    blockType = 1;
                    chunkLength = compressedLength;
                    out2.setShort(outputOffset, chunkLength);
                    outputOffset += 2;
                } else {
                    blockType = 0;
                    System.arraycopy(input3, inputPtr, output, outputPtr - 2, length2);
                    chunkLength = length2;
                }
            }
            out2.setShort(outputOffset, length2);
            out2.setByte(outputIdx + 3, blockType | (checksum != null ? 16 : 0));
            out2.writerIndex(outputOffset + 2 + chunkLength);
            in.skipBytes(length2);
        }
        return;
    }
}

