/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordEncoder;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.util.List;

@ChannelHandler.Sharable
public class DatagramDnsResponseEncoder
extends MessageToMessageEncoder<AddressedEnvelope<DnsResponse, InetSocketAddress>> {
    private final DnsRecordEncoder recordEncoder;

    public DatagramDnsResponseEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public DatagramDnsResponseEncoder(DnsRecordEncoder recordEncoder) {
        this.recordEncoder = ObjectUtil.checkNotNull(recordEncoder, "recordEncoder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<DnsResponse, InetSocketAddress> in, List<Object> out2) throws Exception {
        InetSocketAddress recipient = in.recipient();
        DnsResponse response2 = in.content();
        ByteBuf buf = this.allocateBuffer(ctx, in);
        boolean success = false;
        try {
            DatagramDnsResponseEncoder.encodeHeader(response2, buf);
            this.encodeQuestions(response2, buf);
            this.encodeRecords(response2, DnsSection.ANSWER, buf);
            this.encodeRecords(response2, DnsSection.AUTHORITY, buf);
            this.encodeRecords(response2, DnsSection.ADDITIONAL, buf);
            success = true;
        }
        finally {
            if (!success) {
                buf.release();
            }
        }
        out2.add(new DatagramPacket(buf, recipient, null));
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, AddressedEnvelope<DnsResponse, InetSocketAddress> msg) throws Exception {
        return ctx.alloc().ioBuffer(1024);
    }

    private static void encodeHeader(DnsResponse response2, ByteBuf buf) {
        buf.writeShort(response2.id());
        int flags = 32768;
        flags |= (response2.opCode().byteValue() & 0xFF) << 11;
        if (response2.isAuthoritativeAnswer()) {
            flags |= 0x400;
        }
        if (response2.isTruncated()) {
            flags |= 0x200;
        }
        if (response2.isRecursionDesired()) {
            flags |= 0x100;
        }
        if (response2.isRecursionAvailable()) {
            flags |= 0x80;
        }
        flags |= response2.z() << 4;
        buf.writeShort(flags |= response2.code().intValue());
        buf.writeShort(response2.count(DnsSection.QUESTION));
        buf.writeShort(response2.count(DnsSection.ANSWER));
        buf.writeShort(response2.count(DnsSection.AUTHORITY));
        buf.writeShort(response2.count(DnsSection.ADDITIONAL));
    }

    private void encodeQuestions(DnsResponse response2, ByteBuf buf) throws Exception {
        int count2 = response2.count(DnsSection.QUESTION);
        for (int i = 0; i < count2; ++i) {
            this.recordEncoder.encodeQuestion((DnsQuestion)response2.recordAt(DnsSection.QUESTION, i), buf);
        }
    }

    private void encodeRecords(DnsResponse response2, DnsSection section, ByteBuf buf) throws Exception {
        int count2 = response2.count(section);
        for (int i = 0; i < count2; ++i) {
            this.recordEncoder.encodeRecord((DnsRecord)response2.recordAt(section, i), buf);
        }
    }
}

