/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.haproxy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.haproxy.HAProxyConstants;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProtocolException;
import io.netty.handler.codec.haproxy.HAProxySSLTLV;
import io.netty.handler.codec.haproxy.HAProxyTLV;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import java.util.List;

@ChannelHandler.Sharable
public final class HAProxyMessageEncoder
extends MessageToByteEncoder<HAProxyMessage> {
    private static final int V2_VERSION_BITMASK = 32;
    static final int UNIX_ADDRESS_BYTES_LENGTH = 108;
    static final int TOTAL_UNIX_ADDRESS_BYTES_LENGTH = 216;
    public static final HAProxyMessageEncoder INSTANCE = new HAProxyMessageEncoder();

    private HAProxyMessageEncoder() {
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, HAProxyMessage msg, ByteBuf out2) throws Exception {
        switch (msg.protocolVersion()) {
            case V1: {
                HAProxyMessageEncoder.encodeV1(msg, out2);
                break;
            }
            case V2: {
                HAProxyMessageEncoder.encodeV2(msg, out2);
                break;
            }
            default: {
                throw new HAProxyProtocolException("Unsupported version: " + (Object)((Object)msg.protocolVersion()));
            }
        }
    }

    private static void encodeV1(HAProxyMessage msg, ByteBuf out2) {
        out2.writeBytes(HAProxyConstants.TEXT_PREFIX);
        out2.writeByte(32);
        out2.writeCharSequence(msg.proxiedProtocol().name(), CharsetUtil.US_ASCII);
        out2.writeByte(32);
        out2.writeCharSequence(msg.sourceAddress(), CharsetUtil.US_ASCII);
        out2.writeByte(32);
        out2.writeCharSequence(msg.destinationAddress(), CharsetUtil.US_ASCII);
        out2.writeByte(32);
        out2.writeCharSequence(String.valueOf(msg.sourcePort()), CharsetUtil.US_ASCII);
        out2.writeByte(32);
        out2.writeCharSequence(String.valueOf(msg.destinationPort()), CharsetUtil.US_ASCII);
        out2.writeByte(13);
        out2.writeByte(10);
    }

    private static void encodeV2(HAProxyMessage msg, ByteBuf out2) {
        out2.writeBytes(HAProxyConstants.BINARY_PREFIX);
        out2.writeByte(0x20 | msg.command().byteValue());
        out2.writeByte(msg.proxiedProtocol().byteValue());
        switch (msg.proxiedProtocol().addressFamily()) {
            case AF_IPv4: 
            case AF_IPv6: {
                byte[] srcAddrBytes = NetUtil.createByteArrayFromIpAddressString(msg.sourceAddress());
                byte[] dstAddrBytes = NetUtil.createByteArrayFromIpAddressString(msg.destinationAddress());
                out2.writeShort(srcAddrBytes.length + dstAddrBytes.length + 4 + msg.tlvNumBytes());
                out2.writeBytes(srcAddrBytes);
                out2.writeBytes(dstAddrBytes);
                out2.writeShort(msg.sourcePort());
                out2.writeShort(msg.destinationPort());
                HAProxyMessageEncoder.encodeTlvs(msg.tlvs(), out2);
                break;
            }
            case AF_UNIX: {
                out2.writeShort(216 + msg.tlvNumBytes());
                int srcAddrBytesWritten = out2.writeCharSequence(msg.sourceAddress(), CharsetUtil.US_ASCII);
                out2.writeZero(108 - srcAddrBytesWritten);
                int dstAddrBytesWritten = out2.writeCharSequence(msg.destinationAddress(), CharsetUtil.US_ASCII);
                out2.writeZero(108 - dstAddrBytesWritten);
                HAProxyMessageEncoder.encodeTlvs(msg.tlvs(), out2);
                break;
            }
            case AF_UNSPEC: {
                out2.writeShort(0);
                break;
            }
            default: {
                throw new HAProxyProtocolException("unexpected addrFamily");
            }
        }
    }

    private static void encodeTlv(HAProxyTLV haProxyTLV, ByteBuf out2) {
        if (haProxyTLV instanceof HAProxySSLTLV) {
            HAProxySSLTLV ssltlv = (HAProxySSLTLV)haProxyTLV;
            out2.writeByte(haProxyTLV.typeByteValue());
            out2.writeShort(ssltlv.contentNumBytes());
            out2.writeByte(ssltlv.client());
            out2.writeInt(ssltlv.verify());
            HAProxyMessageEncoder.encodeTlvs(ssltlv.encapsulatedTLVs(), out2);
        } else {
            out2.writeByte(haProxyTLV.typeByteValue());
            ByteBuf value = haProxyTLV.content();
            int readableBytes = value.readableBytes();
            out2.writeShort(readableBytes);
            out2.writeBytes(value.readSlice(readableBytes));
        }
    }

    private static void encodeTlvs(List<HAProxyTLV> haProxyTLVs, ByteBuf out2) {
        for (int i = 0; i < haProxyTLVs.size(); ++i) {
            HAProxyMessageEncoder.encodeTlv(haProxyTLVs.get(i), out2);
        }
    }
}

