/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.redis;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.redis.ArrayHeaderRedisMessage;
import io.netty.handler.codec.redis.ArrayRedisMessage;
import io.netty.handler.codec.redis.BulkStringHeaderRedisMessage;
import io.netty.handler.codec.redis.BulkStringRedisContent;
import io.netty.handler.codec.redis.ErrorRedisMessage;
import io.netty.handler.codec.redis.FixedRedisMessagePool;
import io.netty.handler.codec.redis.FullBulkStringRedisMessage;
import io.netty.handler.codec.redis.InlineCommandRedisMessage;
import io.netty.handler.codec.redis.IntegerRedisMessage;
import io.netty.handler.codec.redis.LastBulkStringRedisContent;
import io.netty.handler.codec.redis.RedisCodecUtil;
import io.netty.handler.codec.redis.RedisConstants;
import io.netty.handler.codec.redis.RedisMessage;
import io.netty.handler.codec.redis.RedisMessagePool;
import io.netty.handler.codec.redis.RedisMessageType;
import io.netty.handler.codec.redis.SimpleStringRedisMessage;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class RedisEncoder
extends MessageToMessageEncoder<RedisMessage> {
    private final RedisMessagePool messagePool;

    public RedisEncoder() {
        this(FixedRedisMessagePool.INSTANCE);
    }

    public RedisEncoder(RedisMessagePool messagePool) {
        this.messagePool = ObjectUtil.checkNotNull(messagePool, "messagePool");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, RedisMessage msg, List<Object> out2) throws Exception {
        try {
            this.writeRedisMessage(ctx.alloc(), msg, out2);
        }
        catch (CodecException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodecException(e);
        }
    }

    private void writeRedisMessage(ByteBufAllocator allocator, RedisMessage msg, List<Object> out2) {
        if (msg instanceof InlineCommandRedisMessage) {
            RedisEncoder.writeInlineCommandMessage(allocator, (InlineCommandRedisMessage)msg, out2);
        } else if (msg instanceof SimpleStringRedisMessage) {
            RedisEncoder.writeSimpleStringMessage(allocator, (SimpleStringRedisMessage)msg, out2);
        } else if (msg instanceof ErrorRedisMessage) {
            RedisEncoder.writeErrorMessage(allocator, (ErrorRedisMessage)msg, out2);
        } else if (msg instanceof IntegerRedisMessage) {
            this.writeIntegerMessage(allocator, (IntegerRedisMessage)msg, out2);
        } else if (msg instanceof FullBulkStringRedisMessage) {
            this.writeFullBulkStringMessage(allocator, (FullBulkStringRedisMessage)msg, out2);
        } else if (msg instanceof BulkStringRedisContent) {
            RedisEncoder.writeBulkStringContent(allocator, (BulkStringRedisContent)msg, out2);
        } else if (msg instanceof BulkStringHeaderRedisMessage) {
            this.writeBulkStringHeader(allocator, (BulkStringHeaderRedisMessage)msg, out2);
        } else if (msg instanceof ArrayHeaderRedisMessage) {
            this.writeArrayHeader(allocator, (ArrayHeaderRedisMessage)msg, out2);
        } else if (msg instanceof ArrayRedisMessage) {
            this.writeArrayMessage(allocator, (ArrayRedisMessage)msg, out2);
        } else {
            throw new CodecException("unknown message type: " + msg);
        }
    }

    private static void writeInlineCommandMessage(ByteBufAllocator allocator, InlineCommandRedisMessage msg, List<Object> out2) {
        RedisEncoder.writeString(allocator, RedisMessageType.INLINE_COMMAND, msg.content(), out2);
    }

    private static void writeSimpleStringMessage(ByteBufAllocator allocator, SimpleStringRedisMessage msg, List<Object> out2) {
        RedisEncoder.writeString(allocator, RedisMessageType.SIMPLE_STRING, msg.content(), out2);
    }

    private static void writeErrorMessage(ByteBufAllocator allocator, ErrorRedisMessage msg, List<Object> out2) {
        RedisEncoder.writeString(allocator, RedisMessageType.ERROR, msg.content(), out2);
    }

    private static void writeString(ByteBufAllocator allocator, RedisMessageType type2, String content2, List<Object> out2) {
        ByteBuf buf = allocator.ioBuffer(type2.length() + ByteBufUtil.utf8MaxBytes(content2) + 2);
        type2.writeTo(buf);
        ByteBufUtil.writeUtf8(buf, (CharSequence)content2);
        buf.writeShort(RedisConstants.EOL_SHORT);
        out2.add(buf);
    }

    private void writeIntegerMessage(ByteBufAllocator allocator, IntegerRedisMessage msg, List<Object> out2) {
        ByteBuf buf = allocator.ioBuffer(23);
        RedisMessageType.INTEGER.writeTo(buf);
        buf.writeBytes(this.numberToBytes(msg.value()));
        buf.writeShort(RedisConstants.EOL_SHORT);
        out2.add(buf);
    }

    private void writeBulkStringHeader(ByteBufAllocator allocator, BulkStringHeaderRedisMessage msg, List<Object> out2) {
        ByteBuf buf = allocator.ioBuffer(1 + (msg.isNull() ? 2 : 22));
        RedisMessageType.BULK_STRING.writeTo(buf);
        if (msg.isNull()) {
            buf.writeShort(RedisConstants.NULL_SHORT);
        } else {
            buf.writeBytes(this.numberToBytes(msg.bulkStringLength()));
            buf.writeShort(RedisConstants.EOL_SHORT);
        }
        out2.add(buf);
    }

    private static void writeBulkStringContent(ByteBufAllocator allocator, BulkStringRedisContent msg, List<Object> out2) {
        out2.add(msg.content().retain());
        if (msg instanceof LastBulkStringRedisContent) {
            out2.add(allocator.ioBuffer(2).writeShort(RedisConstants.EOL_SHORT));
        }
    }

    private void writeFullBulkStringMessage(ByteBufAllocator allocator, FullBulkStringRedisMessage msg, List<Object> out2) {
        if (msg.isNull()) {
            ByteBuf buf = allocator.ioBuffer(5);
            RedisMessageType.BULK_STRING.writeTo(buf);
            buf.writeShort(RedisConstants.NULL_SHORT);
            buf.writeShort(RedisConstants.EOL_SHORT);
            out2.add(buf);
        } else {
            ByteBuf headerBuf = allocator.ioBuffer(23);
            RedisMessageType.BULK_STRING.writeTo(headerBuf);
            headerBuf.writeBytes(this.numberToBytes(msg.content().readableBytes()));
            headerBuf.writeShort(RedisConstants.EOL_SHORT);
            out2.add(headerBuf);
            out2.add(msg.content().retain());
            out2.add(allocator.ioBuffer(2).writeShort(RedisConstants.EOL_SHORT));
        }
    }

    private void writeArrayHeader(ByteBufAllocator allocator, ArrayHeaderRedisMessage msg, List<Object> out2) {
        this.writeArrayHeader(allocator, msg.isNull(), msg.length(), out2);
    }

    private void writeArrayMessage(ByteBufAllocator allocator, ArrayRedisMessage msg, List<Object> out2) {
        if (msg.isNull()) {
            this.writeArrayHeader(allocator, msg.isNull(), -1L, out2);
        } else {
            this.writeArrayHeader(allocator, msg.isNull(), msg.children().size(), out2);
            for (RedisMessage child : msg.children()) {
                this.writeRedisMessage(allocator, child, out2);
            }
        }
    }

    private void writeArrayHeader(ByteBufAllocator allocator, boolean isNull, long length2, List<Object> out2) {
        if (isNull) {
            ByteBuf buf = allocator.ioBuffer(5);
            RedisMessageType.ARRAY_HEADER.writeTo(buf);
            buf.writeShort(RedisConstants.NULL_SHORT);
            buf.writeShort(RedisConstants.EOL_SHORT);
            out2.add(buf);
        } else {
            ByteBuf buf = allocator.ioBuffer(23);
            RedisMessageType.ARRAY_HEADER.writeTo(buf);
            buf.writeBytes(this.numberToBytes(length2));
            buf.writeShort(RedisConstants.EOL_SHORT);
            out2.add(buf);
        }
    }

    private byte[] numberToBytes(long value) {
        byte[] bytes = this.messagePool.getByteBufOfInteger(value);
        return bytes != null ? bytes : RedisCodecUtil.longToAsciiBytes(value);
    }
}

