/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.socksx.v4.Socks4CommandRequest;
import io.netty.util.NetUtil;

@ChannelHandler.Sharable
public final class Socks4ClientEncoder
extends MessageToByteEncoder<Socks4CommandRequest> {
    public static final Socks4ClientEncoder INSTANCE = new Socks4ClientEncoder();
    private static final byte[] IPv4_DOMAIN_MARKER = new byte[]{0, 0, 0, 1};

    private Socks4ClientEncoder() {
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Socks4CommandRequest msg, ByteBuf out2) throws Exception {
        out2.writeByte(msg.version().byteValue());
        out2.writeByte(msg.type().byteValue());
        out2.writeShort(msg.dstPort());
        if (NetUtil.isValidIpV4Address(msg.dstAddr())) {
            out2.writeBytes(NetUtil.createByteArrayFromIpAddressString(msg.dstAddr()));
            ByteBufUtil.writeAscii(out2, (CharSequence)msg.userId());
            out2.writeByte(0);
        } else {
            out2.writeBytes(IPv4_DOMAIN_MARKER);
            ByteBufUtil.writeAscii(out2, (CharSequence)msg.userId());
            out2.writeByte(0);
            ByteBufUtil.writeAscii(out2, (CharSequence)msg.dstAddr());
            out2.writeByte(0);
        }
    }
}

