/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.contact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.AnonymousMember;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.Member;
import net.mamoe.mirai.contact.MemberKt;
import net.mamoe.mirai.contact.OtherClient;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.events.FriendMessageEvent;
import net.mamoe.mirai.event.events.FriendMessageSyncEvent;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.GroupMessageSyncEvent;
import net.mamoe.mirai.event.events.GroupTempMessageEvent;
import net.mamoe.mirai.event.events.GroupTempMessageSyncEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.event.events.OtherClientMessageEvent;
import net.mamoe.mirai.event.events.StrangerMessageEvent;
import net.mamoe.mirai.event.events.StrangerMessageSyncEvent;
import net.mamoe.mirai.internal.contact.GroupImpl;
import net.mamoe.mirai.internal.contact.UtilKt;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.MessageUtils;
import net.mamoe.mirai.message.data.SingleMessage;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\f\u0010\u0011\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\u0014\u0010\u0016\u001a\u00020\u0003*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0019\u0010\u0006\u001a\u00020\u0007*\u00020\b8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0019\u0010\u000b\u001a\u00020\u0007*\u00020\f8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0019\u0010\u000b\u001a\u00020\u0007*\u00020\b8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\n\"\u0019\u0010\u000b\u001a\u00020\u0007*\u00020\u000f8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010\u00a8\u0006\u001a"}, d2={"charMappings", "", "", "", "getCharMappings", "()Ljava/util/Map;", "groupCode", "", "Lnet/mamoe/mirai/contact/Group;", "getGroupCode", "(Lnet/mamoe/mirai/contact/Group;)J", "uin", "Lnet/mamoe/mirai/Bot;", "getUin", "(Lnet/mamoe/mirai/Bot;)J", "Lnet/mamoe/mirai/contact/User;", "(Lnet/mamoe/mirai/contact/User;)J", "applyCharMapping", "logMessageReceived", "", "Lnet/mamoe/mirai/event/events/MessageEvent;", "replaceMagicCodes", "takeContent", "Lnet/mamoe/mirai/message/data/Message;", "length", "", "mirai-core"})
public final class UtilKt {
    @NotNull
    private static final Map<Character, String> charMappings;

    public static final long getUin(@NotNull Group $this$uin) {
        Intrinsics.checkNotNullParameter($this$uin, "<this>");
        boolean $i$f$getUin = false;
        Group $this$cast$iv = $this$uin;
        boolean $i$f$cast = false;
        return ((GroupImpl)$this$cast$iv).getUin();
    }

    public static final long getGroupCode(@NotNull Group $this$groupCode) {
        Intrinsics.checkNotNullParameter($this$groupCode, "<this>");
        boolean $i$f$getGroupCode = false;
        return $this$groupCode.getId();
    }

    public static final long getUin(@NotNull User $this$uin) {
        Intrinsics.checkNotNullParameter($this$uin, "<this>");
        boolean $i$f$getUin = false;
        return $this$uin.getId();
    }

    public static final long getUin(@NotNull Bot $this$uin) {
        Intrinsics.checkNotNullParameter($this$uin, "<this>");
        boolean $i$f$getUin = false;
        return $this$uin.getId();
    }

    public static final void logMessageReceived(@NotNull MessageEvent $this$logMessageReceived) {
        Intrinsics.checkNotNullParameter($this$logMessageReceived, "<this>");
        MiraiLogger $this$verbose$iv = $this$logMessageReceived.getBot().getLogger();
        boolean $i$f$verbose = false;
        if ($this$verbose$iv.isVerboseEnabled()) {
            MiraiLogger miraiLogger = $this$verbose$iv;
            boolean bl = false;
            MessageEvent messageEvent = $this$logMessageReceived;
            miraiLogger.verbose(UtilKt.replaceMagicCodes(messageEvent instanceof GroupMessageEvent ? UtilKt.logMessageReceived$renderGroupMessage(((GroupMessageEvent)$this$logMessageReceived).getGroup(), $this$logMessageReceived.getSenderName(), ((GroupMessageEvent)$this$logMessageReceived).getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof GroupMessageSyncEvent ? UtilKt.logMessageReceived$renderGroupMessageSync(((GroupMessageSyncEvent)$this$logMessageReceived).getGroup(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof GroupTempMessageEvent ? UtilKt.logMessageReceived$renderGroupTempMessage(((GroupTempMessageEvent)$this$logMessageReceived).getGroup(), $this$logMessageReceived.getSenderName(), ((GroupTempMessageEvent)$this$logMessageReceived).getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof GroupTempMessageSyncEvent ? UtilKt.logMessageReceived$renderGroupTempMessageSync(((GroupTempMessageSyncEvent)$this$logMessageReceived).getGroup(), MemberKt.getNameCardOrNick(((GroupTempMessageSyncEvent)$this$logMessageReceived).getSubject()), ((GroupTempMessageSyncEvent)$this$logMessageReceived).getSubject(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof StrangerMessageEvent ? UtilKt.logMessageReceived$renderStrangerMessage($this$logMessageReceived.getSenderName(), ((StrangerMessageEvent)$this$logMessageReceived).getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof StrangerMessageSyncEvent ? UtilKt.logMessageReceived$renderStrangerMessageSync(((StrangerMessageSyncEvent)$this$logMessageReceived).getSubject().getNick(), ((StrangerMessageSyncEvent)$this$logMessageReceived).getSubject(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof FriendMessageEvent ? UtilKt.logMessageReceived$renderFriendMessage(((FriendMessageEvent)$this$logMessageReceived).getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof FriendMessageSyncEvent ? UtilKt.logMessageReceived$renderFriendMessageSync(((FriendMessageSyncEvent)$this$logMessageReceived).getSubject(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof OtherClientMessageEvent ? UtilKt.logMessageReceived$renderOtherClientMessage($this$logMessageReceived, ((OtherClientMessageEvent)$this$logMessageReceived).getClient()) : $this$logMessageReceived.toString()))))))))));
        }
    }

    @NotNull
    public static final Map<Character, String> getCharMappings() {
        return charMappings;
    }

    @NotNull
    public static final String applyCharMapping(@NotNull String $this$applyCharMapping) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$applyCharMapping, "<this>");
        int n = $this$applyCharMapping.length();
        StringBuilder $this$applyCharMapping_u24lambda_u2d3 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        CharSequence $this$forEach$iv = $this$applyCharMapping;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl2 = false;
            Object object = charMappings.get(Character.valueOf(c));
            if (object == null) {
                object = Character.valueOf(c);
            }
            $this$applyCharMapping_u24lambda_u2d3.append(object);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String replaceMagicCodes(@NotNull String $this$replaceMagicCodes) {
        Intrinsics.checkNotNullParameter($this$replaceMagicCodes, "<this>");
        return UtilKt.applyCharMapping($this$replaceMagicCodes);
    }

    @NotNull
    public static final String takeContent(@NotNull Message $this$takeContent, int length2) {
        Intrinsics.checkNotNullParameter($this$takeContent, "<this>");
        return CollectionsKt.joinToString$default(MessageUtils.newChain($this$takeContent), "", null, null, length2, null, takeContent.1.INSTANCE, 22, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final String logMessageReceived$renderMessage(MessageChain message2) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = message2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            SingleMessage it = (SingleMessage)element$iv$iv;
            boolean bl = false;
            if (it instanceof MessageSource) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, null, 62, null);
    }

    private static final String logMessageReceived$renderGroupMessage(Group group, String senderName, Member sender2, MessageChain message2) {
        String displayId = sender2 instanceof AnonymousMember ? "\u533f\u540d" : String.valueOf(sender2.getId());
        return '[' + group.getName() + '(' + group.getId() + ")] " + senderName + '(' + displayId + ") -> " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderGroupMessageSync(Group group, MessageChain message2) {
        return '[' + group.getName() + '(' + group.getId() + ")][SYNC] <- " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderGroupTempMessage(Group group, String senderName, Member sender2, MessageChain message2) {
        return '[' + group.getName() + '(' + group.getId() + ")] " + senderName + "(Temp " + sender2.getId() + ") -> " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderGroupTempMessageSync(Group group, String subjectName, Member subject2, MessageChain message2) {
        return '[' + group.getName() + '(' + group.getId() + ")] " + subjectName + "(Temp " + subject2.getId() + ")[SYNC] <- " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderStrangerMessage(String senderName, User sender2, MessageChain message2) {
        return '[' + senderName + "(Stranger " + sender2.getId() + ") -> " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderStrangerMessageSync(String subjectName, User subject2, MessageChain message2) {
        return '[' + subjectName + "(Stranger " + subject2.getId() + ")[SYNC] <- " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderFriendMessage(User sender2, MessageChain message2) {
        return sender2.getNick() + '(' + sender2.getId() + ") -> " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderFriendMessageSync(User subject2, MessageChain message2) {
        return subject2.getNick() + '(' + subject2.getId() + ")[SYNC] <- " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderOtherClientMessage(MessageEvent $this_logMessageReceived, OtherClient client2) {
        OtherClient $this$platform$iv = client2;
        boolean $i$f$getPlatform = false;
        return (Object)((Object)$this$platform$iv.getInfo().getPlatform()) + " -> " + UtilKt.logMessageReceived$renderMessage($this_logMessageReceived.getMessage());
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Character.valueOf('\n'), "\\n"), TuplesKt.to(Character.valueOf('\r'), ""), TuplesKt.to(Character.valueOf('\u202e'), "<RTL>"), TuplesKt.to(Character.valueOf('\u202d'), "<LTR>")};
        charMappings = MapsKt.mapOf(pairArray);
    }
}

