/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.deps.io.ktor.http;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import net.mamoe.mirai.internal.deps.io.ktor.http.ContentRange;
import net.mamoe.mirai.internal.deps.io.ktor.http.RangeUnits;
import net.mamoe.mirai.internal.deps.io.ktor.http.RangesKt;
import net.mamoe.mirai.internal.deps.io.ktor.http.RangesSpecifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\b\b\u0002\u0010\u0002\u001a\u00020\b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\b2\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u001c\u0010\u0016\u001a\u00020\u00122\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u0018J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u0015J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001f\u001a\u00020\bH\u0016J\u001f\u0010 \u001a\b\u0012\u0004\u0012\u0002H!0\u0005\"\u0004\b\u0000\u0010!*\u0004\u0018\u0001H!H\u0002\u00a2\u0006\u0002\u0010\"R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lnet/mamoe/mirai/internal/deps/io/ktor/http/RangesSpecifier;", "", "unit", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/RangeUnits;", "ranges", "", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/ContentRange;", "(Lio/ktor/http/RangeUnits;Ljava/util/List;)V", "", "(Ljava/lang/String;Ljava/util/List;)V", "getRanges", "()Ljava/util/List;", "getUnit", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "isValid", "rangeUnitPredicate", "Lkotlin/Function1;", "merge", "Lkotlin/ranges/LongRange;", "length", "", "maxRangeCount", "mergeToSingle", "toString", "toList", "T", "(Ljava/lang/Object;)Ljava/util/List;", "ktor-http"})
public final class RangesSpecifier {
    @NotNull
    private final String unit;
    @NotNull
    private final List<ContentRange> ranges;

    public RangesSpecifier(@NotNull String unit, @NotNull List<? extends ContentRange> ranges) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(ranges, "ranges");
        this.unit = unit;
        this.ranges = ranges;
        if (!(!((Collection)this.ranges).isEmpty())) {
            boolean bl = false;
            String string = "It should be at least one range";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RangesSpecifier(String string, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = RangeUnits.Bytes.getUnitToken();
        }
        this(string, (List<? extends ContentRange>)list2);
    }

    @NotNull
    public final String getUnit() {
        return this.unit;
    }

    @NotNull
    public final List<ContentRange> getRanges() {
        return this.ranges;
    }

    public RangesSpecifier(@NotNull RangeUnits unit, @NotNull List<? extends ContentRange> ranges) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        Intrinsics.checkNotNullParameter(ranges, "ranges");
        this(unit.getUnitToken(), ranges);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValid(@NotNull Function1<? super String, Boolean> rangeUnitPredicate) {
        boolean bl;
        Intrinsics.checkNotNullParameter(rangeUnitPredicate, "rangeUnitPredicate");
        if (rangeUnitPredicate.invoke(this.unit) == false) return false;
        Iterable $this$none$iv = this.ranges;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            ContentRange it = (ContentRange)element$iv;
            boolean bl2 = false;
            ContentRange contentRange = it;
            if (contentRange instanceof ContentRange.Bounded) {
                if (((ContentRange.Bounded)it).getFrom() < 0L) return false;
                if (((ContentRange.Bounded)it).getTo() < ((ContentRange.Bounded)it).getFrom()) {
                    return false;
                }
                bl = false;
                continue;
            }
            if (contentRange instanceof ContentRange.TailFrom) {
                if (((ContentRange.TailFrom)it).getFrom() < 0L) {
                    return false;
                }
                bl = false;
                continue;
            }
            if (!(contentRange instanceof ContentRange.Suffix)) throw new NoWhenBranchMatchedException();
            if (((ContentRange.Suffix)it).getLastCount() < 0L) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    public static /* synthetic */ boolean isValid$default(RangesSpecifier rangesSpecifier, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = isValid.1.INSTANCE;
        }
        return rangesSpecifier.isValid(function1);
    }

    @NotNull
    public final List<LongRange> merge(long length2, int maxRangeCount) {
        if (this.ranges.size() > maxRangeCount) {
            return this.toList(this.mergeToSingle(length2));
        }
        return this.merge(length2);
    }

    public static /* synthetic */ List merge$default(RangesSpecifier rangesSpecifier, long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        return rangesSpecifier.merge(l, n);
    }

    @NotNull
    public final List<LongRange> merge(long length2) {
        return RangesKt.mergeRangesKeepOrder(RangesKt.toLongRanges(this.ranges, length2));
    }

    @Nullable
    public final LongRange mergeToSingle(long length2) {
        Object v1;
        Object v0;
        List<LongRange> mapped = RangesKt.toLongRanges(this.ranges, length2);
        if (mapped.isEmpty()) {
            return null;
        }
        Iterable $this$minByOrNull$iv = mapped;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                LongRange it = (LongRange)minElem$iv;
                boolean bl = false;
                long minValue$iv = it.getStart();
                do {
                    Object e$iv = iterator$iv.next();
                    LongRange it2 = (LongRange)e$iv;
                    $i$a$-minByOrNull-RangesSpecifier$mergeToSingle$start$1 = false;
                    long v$iv = it2.getStart();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        long start2 = ((LongRange)v0).getStart();
        Iterable $this$maxByOrNull$iv = mapped;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv2 = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v1 = maxElem$iv;
            } else {
                LongRange it = (LongRange)maxElem$iv;
                boolean bl = false;
                long maxValue$iv = it.getEndInclusive();
                do {
                    Object e$iv = iterator$iv2.next();
                    LongRange it3 = (LongRange)e$iv;
                    $i$a$-maxByOrNull-RangesSpecifier$mergeToSingle$endInclusive$1 = false;
                    long v$iv = it3.getEndInclusive();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v1 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v1);
        long endInclusive = kotlin.ranges.RangesKt.coerceAtMost(((LongRange)v1).getEndInclusive(), length2 - 1L);
        return new LongRange(start2, endInclusive);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default(this.ranges, ",", this.unit + '=', null, 0, null, null, 60, null);
    }

    private final <T> List<T> toList(T $this$toList) {
        T t = $this$toList;
        return t == null ? CollectionsKt.emptyList() : CollectionsKt.listOf(t);
    }

    @NotNull
    public final String component1() {
        return this.unit;
    }

    @NotNull
    public final List<ContentRange> component2() {
        return this.ranges;
    }

    @NotNull
    public final RangesSpecifier copy(@NotNull String unit, @NotNull List<? extends ContentRange> ranges) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(ranges, "ranges");
        return new RangesSpecifier(unit, ranges);
    }

    public static /* synthetic */ RangesSpecifier copy$default(RangesSpecifier rangesSpecifier, String string, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = rangesSpecifier.unit;
        }
        if ((n & 2) != 0) {
            list2 = rangesSpecifier.ranges;
        }
        return rangesSpecifier.copy(string, list2);
    }

    public int hashCode() {
        int result2 = this.unit.hashCode();
        result2 = result2 * 31 + ((Object)this.ranges).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RangesSpecifier)) {
            return false;
        }
        RangesSpecifier rangesSpecifier = (RangesSpecifier)other;
        if (!Intrinsics.areEqual(this.unit, rangesSpecifier.unit)) {
            return false;
        }
        return Intrinsics.areEqual(this.ranges, rangesSpecifier.ranges);
    }
}

