/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.protocol.data.richstatus;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.mamoe.mirai.internal.network.protocol.data.richstatus.RichStatus;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u00a8\u0006\u0004"}, d2={"parseRichStatusImpl", "Lnet/mamoe/mirai/internal/network/protocol/data/richstatus/RichStatus;", "rawData", "", "mirai-core"})
public final class RichStatusKt {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final RichStatus parseRichStatusImpl(@Nullable byte[] rawData) {
        RichStatus rsp = new RichStatus(0, 0, null, 0, null, null, 0, 0, null, 0, 0, null, 0, null, 0, 0L, 0, 0, 262143, null);
        if (rawData == null || rawData.length <= 2) {
            return rsp;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(rawData).order(ByteOrder.BIG_ENDIAN);
        int lastPosition = 0;
        String lastStringData = null;
        block18: while (byteBuffer.remaining() >= 2) {
            void $this$pos$iv;
            Buffer $this$pos$iv2;
            boolean $i$f$setPos;
            int value$iv;
            int dataType = MiraiUtils.toIntUnsigned(byteBuffer.get());
            int dataLength = MiraiUtils.toIntUnsigned(byteBuffer.get());
            if (byteBuffer.remaining() < dataLength) break;
            int dataStartPosition = lastPosition + 2;
            boolean bl = 1 <= dataType ? dataType < 128 : false;
            if (bl) {
                String dataContent = new String(rawData, dataStartPosition, dataLength, Charsets.UTF_8);
                lastPosition = dataStartPosition + dataLength;
                Intrinsics.checkNotNullExpressionValue(byteBuffer, "byteBuffer");
                Buffer buffer = byteBuffer;
                value$iv = lastPosition;
                $i$f$setPos = false;
                $this$pos$iv2.position(value$iv);
                switch (dataType) {
                    case 1: {
                        rsp.actionText = dataContent;
                        continue block18;
                    }
                    case 2: {
                        rsp.dataText = dataContent;
                        continue block18;
                    }
                    case 4: {
                        if (lastStringData != null) {
                            rsp.addPlainText(lastStringData);
                            lastStringData = null;
                        }
                        if (rsp.plainText != null) {
                            List<String> list2 = rsp.plainText;
                            Intrinsics.checkNotNull(list2);
                            rsp.locationPosition = list2.size();
                        } else {
                            rsp.locationPosition = 0;
                        }
                        rsp.locationText = dataContent;
                        continue block18;
                    }
                }
                if (lastStringData == null) {
                    lastStringData = dataContent;
                    continue;
                }
                lastStringData = lastStringData + dataContent;
                continue;
            }
            boolean $i$a$-run-RichStatusKt$parseRichStatusImpl$22 = false;
            switch (dataType) {
                case 129: {
                    if (byteBuffer.remaining() < 8) break;
                    rsp.actionId = byteBuffer.getInt();
                    rsp.dataId = byteBuffer.getInt();
                    break;
                }
                case 130: {
                    if (byteBuffer.remaining() < 8) break;
                    rsp.lontitude = byteBuffer.getInt();
                    rsp.latitude = byteBuffer.getInt();
                    break;
                }
                case 144: {
                    rsp.feedsId = new String(rawData, dataStartPosition, dataLength, Charsets.UTF_8);
                    break;
                }
                case 145: {
                    rsp.tplId = byteBuffer.getInt();
                    break;
                }
                case 146: {
                    rsp.tplType = byteBuffer.getInt();
                    break;
                }
                case 147: {
                    rsp.actId = byteBuffer.getInt();
                    break;
                }
                case 148: {
                    if (byteBuffer.remaining() < 4) break;
                    lastPosition = byteBuffer.getInt();
                    break;
                }
                case 149: {
                    if (byteBuffer.remaining() < 5) break;
                    for (lastPosition = dataLength; lastPosition >= 5; lastPosition -= 5) {
                        byteBuffer.getInt();
                        MiraiUtils.toIntUnsigned(byteBuffer.get());
                    }
                    break;
                }
                case 161: {
                    Intrinsics.checkNotNullExpressionValue(byteBuffer, "byteBuffer");
                    $this$pos$iv2 = byteBuffer;
                    Buffer $this$pos$iv3 = byteBuffer;
                    boolean $i$f$getPos = false;
                    value$iv = $this$pos$iv3.position() + dataLength;
                    $i$f$setPos = false;
                    $this$pos$iv2.position(value$iv);
                    break;
                }
                case 162: {
                    rsp.fontId = byteBuffer.getInt();
                    break;
                }
                case 163: {
                    rsp.fontType = byteBuffer.getInt();
                }
            }
            lastPosition = dataStartPosition + dataLength;
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "byteBuffer");
            Buffer $i$a$-run-RichStatusKt$parseRichStatusImpl$22 = byteBuffer;
            int value$iv2 = lastPosition;
            boolean $i$f$setPos2 = false;
            $this$pos$iv.position(value$iv2);
        }
        if (lastStringData != null) {
            rsp.addPlainText(lastStringData);
        }
        return rsp;
    }
}

