/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lnet/mamoe/mirai/internal/utils/FileSystem;", "", "()V", "checkLegitimacy", "", "path", "", "isLegal", "", "normalize", "parent", "name", "mirai-core"})
public final class FileSystem {
    @NotNull
    public static final FileSystem INSTANCE = new FileSystem();

    private FileSystem() {
    }

    public final void checkLegitimacy(@NotNull String path) {
        Character c;
        block2: {
            Character c2;
            Intrinsics.checkNotNullParameter(path, "path");
            CharSequence $this$firstOrNull$iv = path;
            boolean $i$f$firstOrNull = false;
            for (int i = 0; i < $this$firstOrNull$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$firstOrNull$iv.charAt(i);
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)":*?\"<>|", it, false, 2, null)) continue;
                c2 = Character.valueOf(element$iv);
                break block2;
            }
            c2 = c = null;
        }
        if (c != null) {
            throw new IllegalArgumentException("Chars ':*?\"<>|' are not allowed in path. RemoteFile path contains illegal char: '" + c + "'. path='" + path + '\'');
        }
    }

    public final boolean isLegal(@NotNull String path) {
        Character c;
        block1: {
            Intrinsics.checkNotNullParameter(path, "path");
            CharSequence $this$firstOrNull$iv = path;
            boolean $i$f$firstOrNull = false;
            for (int i = 0; i < $this$firstOrNull$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$firstOrNull$iv.charAt(i);
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)":*?\"<>|", it, false, 2, null)) continue;
                c = Character.valueOf(element$iv);
                break block1;
            }
            c = null;
        }
        return c == null;
    }

    @NotNull
    public final String normalize(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        this.checkLegitimacy(path);
        return StringsKt.replace$default(path, '\\', '/', false, 4, null);
    }

    @NotNull
    public final String normalize(@NotNull String parent, @NotNull String name) {
        int slash;
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(name, "name");
        String nName = this.normalize(name);
        if (StringsKt.startsWith$default((CharSequence)nName, '/', false, 2, null)) {
            return nName;
        }
        nName = StringsKt.removeSuffix(nName, (CharSequence)"/");
        String nParent = this.normalize(parent);
        if (Intrinsics.areEqual(nParent, "/")) {
            return '/' + nName;
        }
        if (!StringsKt.startsWith$default((CharSequence)nParent, '/', false, 2, null)) {
            nParent = '/' + nParent;
        }
        if ((slash = StringsKt.indexOf$default((CharSequence)nName, '/', 0, false, 6, null)) != -1) {
            StringBuilder stringBuilder = new StringBuilder().append(nParent);
            char c = '/';
            String string = nName.substring(0, slash);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = string;
            nParent = stringBuilder.append(c + string2).toString();
            String string3 = nName.substring(slash + 1);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
            nName = string3;
        }
        return nParent + '/' + nName;
    }
}

