/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils.crypto;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.utils.crypto.Ecdh;
import net.mamoe.mirai.internal.utils.crypto.EcdhKeyPair;
import net.mamoe.mirai.internal.utils.crypto.QQEcdhInitialPublicKey;
import net.mamoe.mirai.internal.utils.crypto.QQEcdhKt;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lnet/mamoe/mirai/internal/utils/crypto/QQEcdh;", "", "initialPublicKey", "Lnet/mamoe/mirai/internal/utils/crypto/QQEcdhInitialPublicKey;", "(Lnet/mamoe/mirai/internal/utils/crypto/QQEcdhInitialPublicKey;)V", "fallbackMode", "", "getFallbackMode", "()Z", "initialQQShareKey", "", "getInitialQQShareKey", "()[B", "keyPair", "Lnet/mamoe/mirai/internal/utils/crypto/EcdhKeyPair;", "publicKey", "getPublicKey", "version", "", "getVersion", "()I", "calculateQQShareKey", "peerKey", "component1", "copy", "equals", "other", "hashCode", "toString", "", "mirai-core"})
public final class QQEcdh {
    @NotNull
    private final QQEcdhInitialPublicKey initialPublicKey;
    private final int version;
    @Nullable
    private final EcdhKeyPair<Object, Object> keyPair;
    @NotNull
    private final byte[] publicKey;
    @NotNull
    private final byte[] initialQQShareKey;
    private final boolean fallbackMode;

    public QQEcdh(@NotNull QQEcdhInitialPublicKey initialPublicKey2) {
        EcdhKeyPair<Object, Object> ecdhKeyPair;
        block9: {
            block8: {
                EcdhKeyPair<Object, Object> it;
                EcdhKeyPair<Object, Object> ecdhKeyPair2;
                QQEcdh qQEcdh;
                block7: {
                    block6: {
                        EcdhKeyPair ecdhKeyPair3;
                        QQEcdh qQEcdh2;
                        Intrinsics.checkNotNullParameter(initialPublicKey2, "initialPublicKey");
                        this.initialPublicKey = initialPublicKey2;
                        this.version = this.initialPublicKey.getVersion();
                        qQEcdh = this;
                        try {
                            qQEcdh2 = qQEcdh;
                            ecdhKeyPair3 = Ecdh.Companion.getInstance().generateKeyPair();
                        }
                        catch (Throwable throwable) {
                            qQEcdh2 = qQEcdh;
                            ecdhKeyPair3 = null;
                        }
                        qQEcdh2.keyPair = ecdhKeyPair3;
                        QQEcdh qQEcdh3 = this;
                        ecdhKeyPair2 = this.keyPair;
                        if (ecdhKeyPair2 == null) break block6;
                        EcdhKeyPair<Object, Object> ecdhKeyPair4 = ecdhKeyPair2;
                        qQEcdh = qQEcdh3;
                        boolean bl = false;
                        byte[] byArray = Ecdh.Companion.getInstance().exportPublicKey(it.getPublic());
                        qQEcdh3 = qQEcdh;
                        ecdhKeyPair2 = (EcdhKeyPair<Object, Object>)byArray;
                        if (byArray != null) break block7;
                    }
                    ecdhKeyPair2 = (EcdhKeyPair<Object, Object>)QQEcdhKt.access$getDefaultPublicKey$p();
                }
                qQEcdh3.publicKey = (byte[])ecdhKeyPair2;
                QQEcdh qQEcdh4 = this;
                ecdhKeyPair = this.keyPair;
                if (ecdhKeyPair == null) break block8;
                it = ecdhKeyPair;
                qQEcdh = qQEcdh4;
                boolean bl = false;
                byte[] byArray = Arrays.copyOf(Ecdh.Companion.getInstance().calculateShareKey(this.initialPublicKey.getKey$mirai_core(), it.getPrivate()), 16);
                Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(this, newSize)");
                byte[] byArray2 = MiraiUtils.md5$default(byArray, 0, 0, 3, null);
                qQEcdh4 = qQEcdh;
                ecdhKeyPair = (EcdhKeyPair<Object, Object>)byArray2;
                if (byArray2 != null) break block9;
            }
            ecdhKeyPair = (EcdhKeyPair<Object, Object>)QQEcdhKt.access$getDefaultQQShareKey$p();
        }
        qQEcdh4.initialQQShareKey = (byte[])ecdhKeyPair;
        this.fallbackMode = this.keyPair == null;
    }

    public /* synthetic */ QQEcdh(QQEcdhInitialPublicKey qQEcdhInitialPublicKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            qQEcdhInitialPublicKey = QQEcdhInitialPublicKey.Companion.getDefault$mirai_core();
        }
        this(qQEcdhInitialPublicKey);
    }

    public final int getVersion() {
        return this.version;
    }

    @NotNull
    public final byte[] getPublicKey() {
        return this.publicKey;
    }

    @NotNull
    public final byte[] getInitialQQShareKey() {
        return this.initialQQShareKey;
    }

    public final boolean getFallbackMode() {
        return this.fallbackMode;
    }

    @NotNull
    public final byte[] calculateQQShareKey(@NotNull Object peerKey) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(peerKey, "peerKey");
        if (!(this.keyPair != null)) {
            boolean $i$a$-check-QQEcdh$calculateQQShareKey$22 = false;
            String $i$a$-check-QQEcdh$calculateQQShareKey$22 = "cannot calculate QQShareKey in fallback mode";
            throw new IllegalStateException($i$a$-check-QQEcdh$calculateQQShareKey$22.toString());
        }
        Object $this$cast$iv = peerKey;
        boolean $i$f$cast = false;
        byArray = Ecdh.Companion.getInstance().calculateShareKey(byArray, this.keyPair.getPrivate());
        int n = 16;
        byte[] byArray2 = Arrays.copyOf(byArray, n);
        Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(this, newSize)");
        return MiraiUtils.md5$default(byArray2, 0, 0, 3, null);
    }

    private final QQEcdhInitialPublicKey component1() {
        return this.initialPublicKey;
    }

    @NotNull
    public final QQEcdh copy(@NotNull QQEcdhInitialPublicKey initialPublicKey2) {
        Intrinsics.checkNotNullParameter(initialPublicKey2, "initialPublicKey");
        return new QQEcdh(initialPublicKey2);
    }

    public static /* synthetic */ QQEcdh copy$default(QQEcdh qQEcdh, QQEcdhInitialPublicKey qQEcdhInitialPublicKey, int n, Object object) {
        if ((n & 1) != 0) {
            qQEcdhInitialPublicKey = qQEcdh.initialPublicKey;
        }
        return qQEcdh.copy(qQEcdhInitialPublicKey);
    }

    @NotNull
    public String toString() {
        return "QQEcdh(initialPublicKey=" + this.initialPublicKey + ')';
    }

    public int hashCode() {
        return this.initialPublicKey.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QQEcdh)) {
            return false;
        }
        QQEcdh qQEcdh = (QQEcdh)other;
        return Intrinsics.areEqual(this.initialPublicKey, qQEcdh.initialPublicKey);
    }

    public QQEcdh() {
        this(null, 1, null);
    }
}

