/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserException;
import io.ktor.http.URLProtocol;
import io.ktor.util.CharsetKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\f\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0007H\u0002\u001a,\u0010\u000f\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a$\u0010\u0011\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\u0012\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\u0013\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0015\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0016"}, d2={"count", "", "urlString", "", "startIndex", "endIndex", "char", "", "findScheme", "fillHost", "", "Lio/ktor/http/URLBuilder;", "indexOfColonInHostPort", "isLetter", "", "parseFile", "slashCount", "parseFragment", "parseMailto", "parseQuery", "takeFrom", "takeFromUnsafe", "ktor-http"})
public final class URLParserKt {
    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $this$takeFrom, @NotNull String urlString) {
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter($this$takeFrom, "<this>");
        Intrinsics.checkNotNullParameter(urlString, "urlString");
        try {
            uRLBuilder = URLParserKt.takeFromUnsafe($this$takeFrom, urlString);
        }
        catch (Throwable cause) {
            throw new URLParserException(urlString, cause);
        }
        return uRLBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final URLBuilder takeFromUnsafe(@NotNull URLBuilder $this$takeFromUnsafe, @NotNull String urlString) {
        String string;
        int it;
        boolean bl;
        int n;
        boolean bl2;
        int n2;
        int startIndex;
        int it22;
        block22: {
            int n3;
            int n4;
            block21: {
                Intrinsics.checkNotNullParameter($this$takeFromUnsafe, "<this>");
                Intrinsics.checkNotNullParameter(urlString, "urlString");
                CharSequence $this$indexOfFirst$iv = urlString;
                boolean $i$f$indexOfFirst = false;
                int n5 = 0;
                n4 = $this$indexOfFirst$iv.length();
                while (n5 < n4) {
                    void index$iv;
                    it22 = $this$indexOfFirst$iv.charAt((int)index$iv);
                    boolean bl3 = false;
                    if (!CharsKt.isWhitespace((char)it22)) {
                        n3 = index$iv;
                        break block21;
                    }
                    ++index$iv;
                }
                n3 = -1;
            }
            startIndex = n3;
            CharSequence $this$indexOfLast$iv = urlString;
            boolean $i$f$indexOfLast = false;
            n4 = $this$indexOfLast$iv.length();
            --n4;
            it22 = 0;
            while (n4 >= 0) {
                void index$iv;
                char it3 = $this$indexOfLast$iv.charAt((int)index$iv);
                boolean bl4 = false;
                if (!CharsKt.isWhitespace(it3)) {
                    n2 = index$iv;
                    break block22;
                }
                --index$iv;
            }
            n2 = -1;
        }
        int endIndex = n2 + 1;
        int schemeLength = URLParserKt.findScheme(urlString, startIndex, endIndex);
        if (schemeLength > 0) {
            String index$iv = urlString;
            it22 = startIndex + schemeLength;
            bl2 = false;
            String string2 = index$iv.substring(startIndex, it22);
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String scheme = string2;
            $this$takeFromUnsafe.setProtocol(URLProtocol.Companion.createOrDefault(scheme));
            startIndex += schemeLength + 1;
        }
        int slashCount = URLParserKt.count(urlString, startIndex, endIndex, '/');
        startIndex += slashCount;
        if (Intrinsics.areEqual($this$takeFromUnsafe.getProtocol().getName(), "file")) {
            URLParserKt.parseFile($this$takeFromUnsafe, urlString, startIndex, endIndex, slashCount);
            return $this$takeFromUnsafe;
        }
        if (Intrinsics.areEqual($this$takeFromUnsafe.getProtocol().getName(), "mailto")) {
            boolean index$iv = slashCount == 0;
            it22 = 0;
            bl2 = false;
            bl2 = false;
            n = 0;
            if (!index$iv) {
                boolean bl5 = false;
                String string3 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            URLParserKt.parseMailto($this$takeFromUnsafe, urlString, startIndex, endIndex);
            return $this$takeFromUnsafe;
        }
        if (slashCount >= 2) {
            int delimiter;
            while (true) {
                Object object = StringsKt.indexOfAny$default((CharSequence)urlString, CharsetKt.toCharArray("@/\\?#"), startIndex, false, 4, null);
                n = 0;
                bl = false;
                it = ((Number)object).intValue();
                boolean bl6 = false;
                Integer it22 = it > 0 ? object : null;
                int n6 = delimiter = it22 == null ? endIndex : it22;
                if (delimiter >= endIndex || urlString.charAt(delimiter) != '@') break;
                int passwordIndex = URLParserKt.indexOfColonInHostPort(urlString, startIndex, delimiter);
                if (passwordIndex != -1) {
                    object = urlString;
                    n = 0;
                    String string4 = ((String)object).substring(startIndex, passwordIndex);
                    Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setUser(CodecsKt.decodeURLPart$default(string4, 0, 0, null, 7, null));
                    object = urlString;
                    n = passwordIndex + 1;
                    bl = false;
                    String string5 = ((String)object).substring(n, delimiter);
                    Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setPassword(CodecsKt.decodeURLPart$default(string5, 0, 0, null, 7, null));
                } else {
                    object = urlString;
                    n = 0;
                    String string6 = ((String)object).substring(startIndex, delimiter);
                    Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setUser(CodecsKt.decodeURLPart$default(string6, 0, 0, null, 7, null));
                }
                startIndex = delimiter + 1;
            }
            URLParserKt.fillHost($this$takeFromUnsafe, urlString, startIndex, delimiter);
            startIndex = delimiter;
        }
        if (startIndex >= endIndex) {
            $this$takeFromUnsafe.setEncodedPath(urlString.charAt(endIndex - 1) == '/' ? "/" : "");
            return $this$takeFromUnsafe;
        }
        if (slashCount == 0) {
            int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)$this$takeFromUnsafe.getEncodedPath(), '/', 0, false, 6, null);
            if (lastSlashIndex != $this$takeFromUnsafe.getEncodedPath().length() - 1) {
                if (lastSlashIndex != -1) {
                    String passwordIndex = $this$takeFromUnsafe.getEncodedPath();
                    int n7 = 0;
                    n = lastSlashIndex + 1;
                    bl = false;
                    String string7 = passwordIndex;
                    if (string7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.substring(n7, n);
                    string = string8;
                    Intrinsics.checkNotNullExpressionValue(string8, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = "/";
                }
            } else {
                string = $this$takeFromUnsafe.getEncodedPath();
            }
        } else {
            string = "";
        }
        $this$takeFromUnsafe.setEncodedPath(string);
        Object object = StringsKt.indexOfAny$default((CharSequence)urlString, CharsetKt.toCharArray("?#"), startIndex, false, 4, null);
        n = 0;
        bl = false;
        it = ((Number)object).intValue();
        boolean bl7 = false;
        Integer passwordIndex = it > 0 ? object : null;
        int pathEnd = passwordIndex == null ? endIndex : passwordIndex;
        object = urlString;
        n = 0;
        String string9 = ((String)object).substring(startIndex, pathEnd);
        Intrinsics.checkNotNullExpressionValue(string9, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String rawPath = string9;
        object = $this$takeFromUnsafe;
        ((URLBuilder)object).setEncodedPath(Intrinsics.stringPlus(((URLBuilder)object).getEncodedPath(), CodecsKt.encodeURLPath(rawPath)));
        startIndex = pathEnd;
        if (startIndex < endIndex && urlString.charAt(startIndex) == '?') {
            startIndex = URLParserKt.parseQuery($this$takeFromUnsafe, urlString, startIndex, endIndex);
        }
        URLParserKt.parseFragment($this$takeFromUnsafe, urlString, startIndex, endIndex);
        return $this$takeFromUnsafe;
    }

    private static final void parseFile(URLBuilder $this$parseFile, String urlString, int startIndex, int endIndex, int slashCount) {
        int n = slashCount;
        switch (n) {
            case 2: {
                int nextSlash = StringsKt.indexOf$default((CharSequence)urlString, '/', startIndex, false, 4, null);
                if (nextSlash == -1 || nextSlash == endIndex) {
                    String string = urlString;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(startIndex, endIndex);
                    Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    $this$parseFile.setHost(string3);
                    return;
                }
                String string = urlString;
                boolean bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(startIndex, nextSlash);
                Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                $this$parseFile.setHost(string5);
                string = urlString;
                bl = false;
                String string6 = string;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(nextSlash, endIndex);
                Intrinsics.checkNotNullExpressionValue(string7, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                $this$parseFile.setEncodedPath(string7);
                break;
            }
            case 3: {
                $this$parseFile.setHost("");
                String string = urlString;
                boolean bl = false;
                String string8 = string;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(startIndex, endIndex);
                Intrinsics.checkNotNullExpressionValue(string9, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                $this$parseFile.setEncodedPath(Intrinsics.stringPlus("/", string9));
                break;
            }
            default: {
                throw new IllegalArgumentException(Intrinsics.stringPlus("Invalid file url: ", urlString));
            }
        }
    }

    private static final void parseMailto(URLBuilder $this$parseMailto, String urlString, int startIndex, int endIndex) {
        int delimiter = StringsKt.indexOf$default((CharSequence)urlString, "@", startIndex, false, 4, null);
        if (delimiter == -1) {
            throw new IllegalArgumentException("Invalid mailto url: " + urlString + ", it should contain '@'.");
        }
        String string = urlString;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(startIndex, delimiter);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        $this$parseMailto.setUser(CodecsKt.decodeURLPart$default(string3, 0, 0, null, 7, null));
        string = urlString;
        n = delimiter + 1;
        boolean bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, endIndex);
        Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        $this$parseMailto.setHost(string5);
    }

    private static final int parseQuery(URLBuilder $this$parseQuery, String urlString, int startIndex, int endIndex) {
        if (startIndex + 1 == endIndex) {
            $this$parseQuery.setTrailingQuery(true);
            return endIndex;
        }
        Integer n = StringsKt.indexOf$default((CharSequence)urlString, '#', startIndex + 1, false, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Object object = it > 0 ? n : null;
        int fragmentStart = object == null ? endIndex : (Integer)object;
        ParametersBuilder parametersBuilder = $this$parseQuery.getParameters();
        object = urlString;
        int n2 = startIndex + 1;
        bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object2).substring(n2, fragmentStart);
        Intrinsics.checkNotNullExpressionValue(string, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        QueryKt.parseQueryStringTo$default(parametersBuilder, string, 0, 0, 12, null);
        return fragmentStart;
    }

    private static final void parseFragment(URLBuilder $this$parseFragment, String urlString, int startIndex, int endIndex) {
        if (startIndex < endIndex && urlString.charAt(startIndex) == '#') {
            String string = urlString;
            int n = startIndex + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, endIndex);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            $this$parseFragment.setFragment(string3);
        }
    }

    private static final void fillHost(URLBuilder $this$fillHost, String urlString, int startIndex, int endIndex) {
        Integer n = URLParserKt.indexOfColonInHostPort(urlString, startIndex, endIndex);
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Object object = it > 0 ? n : null;
        int colonIndex = object == null ? endIndex : (Integer)object;
        object = urlString;
        int n2 = 0;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object2).substring(startIndex, colonIndex);
        Intrinsics.checkNotNullExpressionValue(string, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        $this$fillHost.setHost(string);
        if (colonIndex + 1 < endIndex) {
            object = urlString;
            n2 = colonIndex + 1;
            bl = false;
            Object object3 = object;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)object3).substring(n2, endIndex);
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object = string2;
            n2 = 0;
            $this$fillHost.setPort(Integer.parseInt((String)object));
        } else {
            $this$fillHost.setPort(0);
        }
    }

    private static final int findScheme(String urlString, int startIndex, int endIndex) {
        int current = startIndex;
        int incorrectSchemePosition = -1;
        char firstChar = urlString.charAt(current);
        if (!('a' <= firstChar ? firstChar <= 'z' : false)) {
            if (!('A' <= firstChar ? firstChar <= 'Z' : false)) {
                incorrectSchemePosition = current;
            }
        }
        while (current < endIndex) {
            char c = urlString.charAt(current);
            if (c == ':') {
                if (incorrectSchemePosition != -1) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus("Illegal character in scheme at position ", incorrectSchemePosition));
                }
                return current - startIndex;
            }
            if (c == '/' || c == '?' || c == '#') {
                return -1;
            }
            if (incorrectSchemePosition == -1) {
                if (!('a' <= c ? c <= 'z' : false)) {
                    if (!('A' <= c ? c <= 'Z' : false)) {
                        if (!('0' <= c ? c <= '9' : false) && c != '.' && c != '+' && c != '-') {
                            incorrectSchemePosition = current;
                        }
                    }
                }
            }
            ++current;
        }
        return -1;
    }

    private static final int count(String urlString, int startIndex, int endIndex, char c) {
        int result2 = 0;
        while (startIndex + result2 < endIndex && urlString.charAt(startIndex + result2) == c) {
            int n = result2;
            result2 = n + 1;
        }
        return result2;
    }

    private static final int indexOfColonInHostPort(String $this$indexOfColonInHostPort, int startIndex, int endIndex) {
        boolean skip = false;
        int n = startIndex;
        if (n < endIndex) {
            do {
                int index;
                char c;
                if ((c = $this$indexOfColonInHostPort.charAt(index = n++)) == '[') {
                    skip = true;
                    continue;
                }
                if (c == ']') {
                    skip = false;
                    continue;
                }
                if (c != ':' || skip) continue;
                return index;
            } while (n < endIndex);
        }
        return -1;
    }

    private static final boolean isLetter(char $this$isLetter) {
        char c = $this$isLetter;
        boolean bl = false;
        char c2 = c;
        boolean bl2 = false;
        char c3 = Character.toLowerCase(c2);
        return 'a' <= c3 ? c3 <= 'z' : false;
    }
}

