/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.converters;

import io.ktor.util.converters.DataConversionException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002\u001a\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0000\u001a\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a8\u0006\t"}, d2={"convertSimpleTypes", "", "value", "", "klass", "Lkotlin/reflect/KClass;", "platformDefaultFromValues", "platformDefaultToValues", "", "ktor-utils"})
public final class ConversionServiceJvmKt {
    @Nullable
    public static final Object platformDefaultFromValues(@NotNull String value, @NotNull KClass<?> klass) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(klass, "klass");
        Object converted = ConversionServiceJvmKt.convertSimpleTypes(value, klass);
        if (converted != null) {
            return converted;
        }
        if (JvmClassMappingKt.getJavaClass(klass).isEnum()) {
            KClass<?> kClass;
            block7: {
                KClass<?> kClass2;
                KClass<?>[] kClassArray = JvmClassMappingKt.getJavaClass(klass).getEnumConstants();
                if (kClassArray == null) {
                    kClass2 = null;
                } else {
                    KClass<?>[] $this$firstOrNull$iv = kClassArray;
                    boolean $i$f$firstOrNull = false;
                    KClass<?>[] kClassArray2 = $this$firstOrNull$iv;
                    int n = kClassArray2.length;
                    for (int i = 0; i < n; ++i) {
                        KClass<?> element$iv;
                        KClass<?> it = element$iv = kClassArray2[i];
                        boolean bl = false;
                        if (it == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Enum<*>");
                        }
                        if (!Intrinsics.areEqual(((Enum)((Object)it)).name(), value)) continue;
                        kClass2 = element$iv;
                        break block7;
                    }
                    kClass2 = kClass = null;
                }
            }
            if (kClass == null) {
                throw new DataConversionException("Value " + value + " is not a enum member name of " + klass);
            }
            return kClass;
        }
        return null;
    }

    private static final Object convertSimpleTypes(String value, KClass<?> klass) {
        Object object;
        KClass<?> kClass = klass;
        if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Integer.class))) {
            String string = value;
            boolean bl = false;
            object = Integer.parseInt(string);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Float.class))) {
            String string = value;
            boolean bl = false;
            object = Float.valueOf(Float.parseFloat(string));
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Double.class))) {
            String string = value;
            boolean bl = false;
            object = Double.parseDouble(string);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Long.class))) {
            String string = value;
            boolean bl = false;
            object = Long.parseLong(string);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Short.class))) {
            String string = value;
            boolean bl = false;
            object = Short.parseShort(string);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Boolean.class))) {
            String string = value;
            boolean bl = false;
            object = Boolean.parseBoolean(string);
        } else {
            object = Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(String.class)) ? value : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Character.class)) ? (Serializable)Character.valueOf(value.charAt(0)) : (Serializable)(Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(BigDecimal.class)) ? new BigDecimal(value) : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(BigInteger.class)) ? new BigInteger(value) : null)));
        }
        return object;
    }

    @Nullable
    public static final List<String> platformDefaultToValues(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (value instanceof Enum) {
            return CollectionsKt.listOf(((Enum)value).name());
        }
        Object object = value;
        return object instanceof Integer ? CollectionsKt.listOf(value.toString()) : (object instanceof Float ? CollectionsKt.listOf(value.toString()) : (object instanceof Double ? CollectionsKt.listOf(value.toString()) : (object instanceof Long ? CollectionsKt.listOf(value.toString()) : (object instanceof Boolean ? CollectionsKt.listOf(value.toString()) : (object instanceof Short ? CollectionsKt.listOf(value.toString()) : (object instanceof String ? CollectionsKt.listOf(value.toString()) : (object instanceof Character ? CollectionsKt.listOf(value.toString()) : (object instanceof BigDecimal ? CollectionsKt.listOf(value.toString()) : (object instanceof BigInteger ? CollectionsKt.listOf(value.toString()) : null)))))))));
    }
}

