/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.utils;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/mamoe/mirai/utils/ResourceAccessLock;", "", "()V", "status", "Ljava/util/concurrent/atomic/AtomicInteger;", "currentStatus", "", "lockIfNotUsing", "", "release", "", "setDisposed", "setInitialized", "setLocked", "setUninitialized", "toString", "", "tryDispose", "tryInitialize", "tryUse", "unlock", "Companion", "mirai-core-utils"})
public final class ResourceAccessLock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicInteger status = new AtomicInteger(-1);
    public static final int LOCKED = -2;
    public static final int UNINITIALIZED = -1;
    public static final int INITIALIZED = 0;

    public final boolean tryDispose() {
        return this.status.compareAndSet(0, -1);
    }

    public final boolean tryInitialize() {
        return this.status.compareAndSet(-1, 0);
    }

    public final boolean tryUse() {
        int v;
        AtomicInteger c = this.status;
        do {
            if ((v = c.get()) >= 0) continue;
            return false;
        } while (!c.compareAndSet(v, v + 1));
        return true;
    }

    public final boolean lockIfNotUsing() {
        AtomicInteger count2 = this.status;
        do {
            int value;
            if ((value = count2.get()) == 0) continue;
            return false;
        } while (!count2.compareAndSet(0, -2));
        return true;
    }

    public final void release() {
        int value;
        AtomicInteger count2 = this.status;
        do {
            if ((value = count2.get()) >= 1) continue;
            throw new IllegalStateException("Current resource not in using");
        } while (!count2.compareAndSet(value, value - 1));
    }

    public final void unlock() {
        this.status.compareAndSet(-2, 0);
    }

    public final void setInitialized() {
        this.status.set(0);
    }

    public final void setLocked() {
        this.status.set(-2);
    }

    public final void setDisposed() {
        this.setUninitialized();
    }

    public final void setUninitialized() {
        this.status.set(-1);
    }

    public final int currentStatus() {
        return this.status.get();
    }

    @NotNull
    public String toString() {
        String string;
        int status = this.status.get();
        switch (status) {
            case 0: {
                string = "ResourceAccessLock(INITIALIZED)";
                break;
            }
            case -1: {
                string = "ResourceAccessLock(UNINITIALIZED)";
                break;
            }
            case -2: {
                string = "ResourceAccessLock(LOCKED)";
                break;
            }
            default: {
                string = "ResourceAccessLock(" + status + ')';
            }
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/mamoe/mirai/utils/ResourceAccessLock$Companion;", "", "()V", "INITIALIZED", "", "LOCKED", "UNINITIALIZED", "mirai-core-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

