/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public final class GzCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8192;
    private final File source;
    private final File destination;
    private final boolean deleteSource;
    private final int compressionLevel;

    public GzCompressAction(File source2, File destination, boolean deleteSource, int compressionLevel) {
        Objects.requireNonNull(source2, "source");
        Objects.requireNonNull(destination, "destination");
        this.source = source2;
        this.destination = destination;
        this.deleteSource = deleteSource;
        this.compressionLevel = compressionLevel;
    }

    @Deprecated
    public GzCompressAction(File source2, File destination, boolean deleteSource) {
        this(source2, destination, deleteSource, -1);
    }

    @Override
    public boolean execute() throws IOException {
        return GzCompressAction.execute(this.source, this.destination, this.deleteSource, this.compressionLevel);
    }

    @Deprecated
    public static boolean execute(File source2, File destination, boolean deleteSource) throws IOException {
        return GzCompressAction.execute(source2, destination, deleteSource, -1);
    }

    public static boolean execute(File source2, File destination, boolean deleteSource, int compressionLevel) throws IOException {
        if (source2.exists()) {
            try (FileInputStream fis = new FileInputStream(source2);
                 FileOutputStream fos = new FileOutputStream(destination);
                 ConfigurableLevelGZIPOutputStream gzipOut = new ConfigurableLevelGZIPOutputStream((OutputStream)fos, 8192, compressionLevel);
                 BufferedOutputStream os = new BufferedOutputStream(gzipOut, 8192);){
                int n;
                byte[] inbuf = new byte[8192];
                while ((n = fis.read(inbuf)) != -1) {
                    ((OutputStream)os).write(inbuf, 0, n);
                }
            }
            if (deleteSource && !source2.delete()) {
                LOGGER.warn("Unable to delete {}.", (Object)source2);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void reportException(Exception ex) {
        LOGGER.warn("Exception during compression of '" + this.source.toString() + "'.", (Throwable)ex);
    }

    public String toString() {
        return GzCompressAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", deleteSource=" + this.deleteSource + ']';
    }

    public File getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public boolean isDeleteSource() {
        return this.deleteSource;
    }

    private static final class ConfigurableLevelGZIPOutputStream
    extends GZIPOutputStream {
        ConfigurableLevelGZIPOutputStream(OutputStream out2, int bufSize, int level) throws IOException {
            super(out2, bufSize);
            this.def.setLevel(level);
        }
    }
}

