/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import org.apache.logging.log4j.util.Strings;

public final class Transform {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String CDATA_PSEUDO_END = "]]&gt;";
    private static final String CDATA_EMBEDED_END = "]]>]]&gt;<![CDATA[";
    private static final int CDATA_END_LEN = "]]>".length();

    private Transform() {
    }

    public static String escapeHtmlTags(String input2) {
        if (Strings.isEmpty(input2) || input2.indexOf(34) == -1 && input2.indexOf(38) == -1 && input2.indexOf(60) == -1 && input2.indexOf(62) == -1) {
            return input2;
        }
        StringBuilder buf = new StringBuilder(input2.length() + 6);
        int len = input2.length();
        block6: for (int i = 0; i < len; ++i) {
            char ch = input2.charAt(i);
            if (ch > '>') {
                buf.append(ch);
                continue;
            }
            switch (ch) {
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static void appendEscapingCData(StringBuilder buf, String str) {
        if (str != null) {
            int end2 = str.indexOf(CDATA_END);
            if (end2 < 0) {
                buf.append(str);
            } else {
                int start2 = 0;
                while (end2 > -1) {
                    buf.append(str.substring(start2, end2));
                    buf.append(CDATA_EMBEDED_END);
                    start2 = end2 + CDATA_END_LEN;
                    if (start2 < str.length()) {
                        end2 = str.indexOf(CDATA_END, start2);
                        continue;
                    }
                    return;
                }
                buf.append(str.substring(start2));
            }
        }
    }

    public static String escapeJsonControlCharacters(String input2) {
        if (Strings.isEmpty(input2) || input2.indexOf(34) == -1 && input2.indexOf(92) == -1 && input2.indexOf(47) == -1 && input2.indexOf(8) == -1 && input2.indexOf(12) == -1 && input2.indexOf(10) == -1 && input2.indexOf(13) == -1 && input2.indexOf(9) == -1) {
            return input2;
        }
        StringBuilder buf = new StringBuilder(input2.length() + 6);
        int len = input2.length();
        block10: for (int i = 0; i < len; ++i) {
            char ch = input2.charAt(i);
            String escBs = "\\";
            switch (ch) {
                case '\"': {
                    buf.append("\\");
                    buf.append(ch);
                    continue block10;
                }
                case '\\': {
                    buf.append("\\");
                    buf.append(ch);
                    continue block10;
                }
                case '/': {
                    buf.append("\\");
                    buf.append(ch);
                    continue block10;
                }
                case '\b': {
                    buf.append("\\");
                    buf.append('b');
                    continue block10;
                }
                case '\f': {
                    buf.append("\\");
                    buf.append('f');
                    continue block10;
                }
                case '\n': {
                    buf.append("\\");
                    buf.append('n');
                    continue block10;
                }
                case '\r': {
                    buf.append("\\");
                    buf.append('r');
                    continue block10;
                }
                case '\t': {
                    buf.append("\\");
                    buf.append('t');
                    continue block10;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }
}

